/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import edu.cmu.tetrad.util.Matrix;

public class LingUtils {
    public static Matrix normalizeDiagonal(Matrix matrix) {
        Matrix resultMatrix = matrix.copy();
        for (int i = 0; i < resultMatrix.rows(); ++i) {
            double factor = 1.0 / resultMatrix.get(i, i);
            for (int j = 0; j < resultMatrix.columns(); ++j) {
                resultMatrix.set(i, j, factor * resultMatrix.get(i, j));
            }
        }
        return resultMatrix;
    }

    public static boolean isPositiveDefinite(Matrix matrix) {
        return new CholeskyDecomposition(new DenseDoubleMatrix2D(matrix.toArray())).isSymmetricPositiveDefinite();
    }
}

