/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import org.apache.commons.math3.util.FastMath;

public class MathUtils {
    public static double logistic(double x) {
        return 1.0 / (1.0 + FastMath.exp(-x));
    }

    public static int factorial(int n) {
        int i = 1;
        for (int j = 1; j <= n; ++j) {
            i *= j;
        }
        return i;
    }

    public static double logFactorial(int n) {
        double i = 0.0;
        for (int j = 1; j <= n; ++j) {
            i += FastMath.log(j);
        }
        return i;
    }

    public static int choose(int a, int b) {
        if (a == 0 && b == 0) {
            return 1;
        }
        if (a == 0 && b > 0) {
            return (int)FastMath.round(FastMath.exp(1.0 - (MathUtils.logFactorial(b) + MathUtils.logFactorial(-b))));
        }
        if (a > 0 && b == 0) {
            return (int)FastMath.round(FastMath.exp(MathUtils.logFactorial(a) - (1.0 + MathUtils.logFactorial(a))));
        }
        if (a > 0 && b > 0) {
            return (int)FastMath.round(FastMath.exp(MathUtils.logFactorial(a) - (MathUtils.logFactorial(b) + MathUtils.logFactorial(a - b))));
        }
        throw new IllegalArgumentException();
    }

    public static double logChoose(int a, int b) {
        return MathUtils.logFactorial(a) - (MathUtils.logFactorial(b) + MathUtils.logFactorial(a - b));
    }
}

