/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.ParamDescription;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class ParamDescriptions {
    private static final ParamDescriptions INSTANCE = new ParamDescriptions();
    private final Map<String, ParamDescription> map = new TreeMap<String, ParamDescription>();
    private final List<String> paramsWithUnsupportedValueType = new ArrayList<String>();

    private ParamDescriptions() {
        Element doc = null;
        String VALUE_TYPE_STRING = "String";
        String VALUE_TYPE_INTEGER = "Integer";
        String VALUE_TYPE_DOUBLE = "Double";
        String VALUE_TYPE_LONG = "Long";
        String VALUE_TYPE_BOOLEAN = "Boolean";
        HashSet<String> PARAM_VALUE_TYPES = new HashSet<String>(Arrays.asList("String", "Integer", "Double", "Long", "Boolean"));
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("manual/index.html");){
            if (inputStream != null) {
                doc = Jsoup.parse(inputStream, "UTF-8", "");
            }
        }
        catch (IOException ex) {
            TetradLogger.getInstance().forceLogMessage("Failed to read tetrad HTML manual 'maunal/index.html' file from within the jar.");
        }
        if (doc != null) {
            Elements elements = doc.getElementsByClass("parameter_description");
            for (Element element : elements) {
                String paramName = element.id();
                String valueType = Objects.requireNonNull(doc.getElementById(paramName + "_value_type")).text().trim();
                if (!PARAM_VALUE_TYPES.contains(valueType)) {
                    this.paramsWithUnsupportedValueType.add(paramName);
                    continue;
                }
                String shortDescription = Objects.requireNonNull(doc.getElementById(paramName + "_short_desc")).text().trim();
                String longDescription = Objects.requireNonNull(doc.getElementById(paramName + "_long_desc")).text().trim();
                String defaultValue = Objects.requireNonNull(doc.getElementById(paramName + "_default_value")).text().trim();
                String lowerBound = Objects.requireNonNull(doc.getElementById(paramName + "_lower_bound")).text().trim();
                String upperBound = Objects.requireNonNull(doc.getElementById(paramName + "_upper_bound")).text().trim();
                if (shortDescription.equals("")) {
                    shortDescription = String.format("Missing short description for %s", paramName);
                }
                if (longDescription.equals("")) {
                    longDescription = String.format("Missing long description for %s", paramName);
                }
                if (!valueType.equals("String") && defaultValue.equals("")) {
                    System.out.println("Invalid default value of parameter: " + paramName);
                }
                ParamDescription paramDescription = null;
                if (valueType.equalsIgnoreCase("Integer")) {
                    Integer defaultValueInt = Integer.parseInt(defaultValue);
                    int lowerBoundInt = Integer.parseInt(lowerBound);
                    int upperBoundInt = Integer.parseInt(upperBound);
                    paramDescription = new ParamDescription(paramName, shortDescription, longDescription, (Serializable)defaultValueInt, lowerBoundInt, upperBoundInt);
                } else if (valueType.equalsIgnoreCase("Long")) {
                    Long defaultValueLong = Long.parseLong(defaultValue);
                    long lowerBoundLong = Long.parseLong(lowerBound);
                    long upperBoundLong = Long.parseLong(upperBound);
                    paramDescription = new ParamDescription(paramName, shortDescription, longDescription, (Serializable)defaultValueLong, lowerBoundLong, upperBoundLong);
                } else if (valueType.equalsIgnoreCase("Double")) {
                    Double defaultValueDouble = Double.parseDouble(defaultValue);
                    double lowerBoundDouble = Double.parseDouble(lowerBound);
                    double upperBoundDouble = Double.parseDouble(upperBound);
                    paramDescription = new ParamDescription(paramName, shortDescription, longDescription, (Serializable)defaultValueDouble, lowerBoundDouble, upperBoundDouble);
                } else if (valueType.equalsIgnoreCase("Boolean")) {
                    Boolean defaultValueBoolean = defaultValue.equalsIgnoreCase("true");
                    paramDescription = new ParamDescription(paramName, shortDescription, longDescription, defaultValueBoolean);
                } else if (valueType.equalsIgnoreCase("String")) {
                    paramDescription = new ParamDescription(paramName, shortDescription, longDescription, (Serializable)((Object)defaultValue));
                }
                this.map.put(paramName, paramDescription);
            }
        }
        this.map.put("printStream", new ParamDescription("printStream", "printStream", "A writer to print output messages.", (Serializable)((Object)"")));
    }

    public static ParamDescriptions getInstance() {
        return INSTANCE;
    }

    public ParamDescription get(String name) {
        ParamDescription paramDesc = this.map.get(name);
        return paramDesc == null ? new ParamDescription(name, String.format("Please add a description for %s to the manual.", name), "", Integer.valueOf(0)) : paramDesc;
    }

    public void put(String name, ParamDescription paramDescription) {
        this.map.put(name, paramDescription);
    }

    public Set<String> getNames() {
        return this.map.keySet();
    }

    public List<String> getParamsWithUnsupportedValueType() {
        return this.paramsWithUnsupportedValueType;
    }
}

