/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.ParamDescription;
import edu.cmu.tetrad.util.ParamDescriptions;
import edu.cmu.tetrad.util.TetradSerializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Parameters
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private Map<String, Object[]> parameters = new LinkedHashMap<String, Object[]>();
    private Set<String> usedParameters = new LinkedHashSet<String>();
    private Map<String, Object> overriddenParameters = new HashMap<String, Object>();

    public Parameters() {
    }

    public Parameters(Parameters parameters) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        this.parameters = new LinkedHashMap<String, Object[]>(parameters.parameters);
        this.usedParameters = new LinkedHashSet<String>(parameters.usedParameters);
        this.overriddenParameters = new HashMap<String, Object>(parameters.overriddenParameters);
    }

    public static Parameters serializableInstance() {
        return new Parameters();
    }

    public void putAll(Parameters parameters) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        this.parameters.putAll(parameters.parameters);
        this.usedParameters.addAll(parameters.usedParameters);
        this.overriddenParameters.putAll(parameters.overriddenParameters);
    }

    public String toString() {
        return this.usedParameters.stream().map(e -> String.format("%s = %s", e, this.parameters.get(e)[0])).collect(Collectors.joining(System.lineSeparator()));
    }

    public int getInt(String name) {
        return ((Number)this.get(name, ParamDescriptions.getInstance().get(name).getDefaultValue())).intValue();
    }

    public long getLong(String name) {
        return ((Number)this.get(name, ParamDescriptions.getInstance().get(name).getDefaultValue())).longValue();
    }

    public boolean getBoolean(String name) {
        try {
            return (Boolean)this.get(name, ParamDescriptions.getInstance().get(name).getDefaultValue());
        }
        catch (Exception e) {
            throw new RuntimeException("ERROR: Parameter " + name + " was not actually boolean.");
        }
    }

    public double getDouble(String name) {
        return ((Number)this.get(name, ParamDescriptions.getInstance().get(name).getDefaultValue())).doubleValue();
    }

    public String getString(String name) {
        return String.valueOf(this.get(name, ParamDescriptions.getInstance().get(name).getDefaultValue()));
    }

    public Object get(String name) {
        return this.get(name, ParamDescriptions.getInstance().get(name).getDefaultValue());
    }

    public int getInt(String name, int defaultValue) {
        return ((Number)this.get(name, defaultValue)).intValue();
    }

    public long getLong(String name, long defaultValue) {
        return ((Number)this.get(name, defaultValue)).longValue();
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        Object b = this.get(name, defaultValue);
        if (!(b instanceof Boolean)) {
            return false;
        }
        return (Boolean)b;
    }

    public double getDouble(String name, double defaultValue) {
        return ((Number)this.get(name, defaultValue)).doubleValue();
    }

    public String getString(String name, String defaultValue) {
        return String.valueOf(this.get(name, defaultValue));
    }

    public Object get(String name, Object defaultValue) {
        if (this.overriddenParameters.containsKey(name)) {
            return this.overriddenParameters.get(name);
        }
        this.usedParameters.add(name);
        Object[] objects = this.parameters.get(name);
        if (objects == null) {
            this.set(name, defaultValue);
            return defaultValue;
        }
        if (this.getNumValues(name) != 1) {
            System.out.println("ERROR. Parameter '" + name + "' was not listed among the algorithm parameters for this algorithm. Skipping this run.\n");
        }
        return objects[0];
    }

    public Object[] getValues(String name) {
        if (this.overriddenParameters.containsKey(name)) {
            return (Object[])this.overriddenParameters.get(name);
        }
        Object[] objects = this.parameters.get(name);
        if (objects == null) {
            ParamDescription paramDescription = ParamDescriptions.getInstance().get(name);
            return new Object[]{paramDescription.getDefaultValue()};
        }
        return objects;
    }

    public void set(String name, Object ... n) {
        this.parameters.put(name, n);
    }

    public void set(String name, String ... s) {
        this.parameters.put(name, s);
    }

    public int getNumValues(String name) {
        Object[] objects = this.parameters.get(name);
        if (objects == null) {
            return 0;
        }
        return objects.length;
    }

    public void set(String name, Object value) {
        if (value == null) {
            return;
        }
        this.parameters.put(name, new Object[]{value});
    }

    public void set(String name, String value) {
        this.parameters.put(name, new String[]{value});
    }

    public Set<String> getParametersNames() {
        return this.parameters.keySet();
    }
}

