/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.Function;
import edu.cmu.tetrad.util.TetradSerializable;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class PartialCorrelationPdf
implements Function,
TetradSerializable {
    static final long serialVersionUID = 23L;
    private final int n;
    private final int k;
    private double constant = Double.NaN;
    private final double outsideExp;

    public PartialCorrelationPdf(int n, int k) {
        this.n = n;
        this.k = k;
        double gammaRatio = this.gammaRatio(n, k);
        this.constant = 1.0 / FastMath.pow(Math.PI, 0.5) * gammaRatio;
        this.outsideExp = (double)(n - k - 2) / 2.0;
    }

    public static PartialCorrelationPdf serializableInstance() {
        return new PartialCorrelationPdf(5, 2);
    }

    @Override
    public double valueAt(double x) {
        return this.constant * FastMath.pow(1.0 - x * x, this.outsideExp);
    }

    private double gammaRatio(int n, int k) {
        double top = (double)(n - k + 1) / 2.0;
        double bottom = (double)(n - k) / 2.0;
        double lngamma = Gamma.logGamma(top) - Gamma.logGamma(bottom);
        return FastMath.exp(lngamma);
    }

    @Override
    public String toString() {
        return "Zero partial correlation distribution with n = " + this.getN() + " and k = " + this.getK() + "\n\n";
    }

    private int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }
}

