/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.Vector;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;

public class Point
implements Comparable<Point> {
    private final Vector vector;

    public Point(Vector vector) {
        this.vector = vector.copy();
    }

    public double getValue(int index) {
        return this.vector.get(index);
    }

    public int getSize() {
        return this.vector.size();
    }

    @Override
    public int compareTo(@NotNull Point p) {
        if (p == this) {
            return 0;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getValue(i) == p.getValue(i)) continue;
            return (int)FastMath.signum(p.getValue(i) - this.getValue(i));
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        for (int i = 0; i < this.getSize(); ++i) {
            buf.append(this.getValue(i));
            if (i >= this.getSize() - 1) continue;
            buf.append(", ");
        }
        buf.append(">");
        return buf.toString();
    }

    public Vector getVector() {
        return this.vector.copy();
    }
}

