/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.GumbelDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;
import org.apache.commons.math3.random.Well44497b;

public class RandomUtil {
    private static final Map<Thread, RandomUtil> randomUtils = new HashMap<Thread, RandomUtil>();
    private static final int SHUFFLE_THRESHOLD = 5;
    private RandomGenerator randomGenerator;

    private RandomUtil() {
        this.setSeed(System.nanoTime());
    }

    public static RandomUtil getInstance() {
        if (!randomUtils.containsKey(Thread.currentThread())) {
            System.out.println("new thread");
            randomUtils.put(Thread.currentThread(), new RandomUtil());
        }
        return randomUtils.get(Thread.currentThread());
    }

    public static void shuffle(List<?> list) {
        int size = list.size();
        if (size < 5 || list instanceof RandomAccess) {
            for (int i = size; i > 1; --i) {
                RandomUtil.swap(list, i - 1, RandomUtil.getInstance().nextInt(i));
            }
        } else {
            Object[] arr = list.toArray();
            for (int i = size; i > 1; --i) {
                RandomUtil.swap(arr, i - 1, RandomUtil.getInstance().nextInt(i));
            }
            ListIterator<?> it = list.listIterator();
            for (Object e : arr) {
                it.next();
                it.set(e);
            }
        }
    }

    private static void swap(List<?> list, int i, int j) {
        List<?> l = list;
        l.set(i, l.set(j, l.get(i)));
    }

    private static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public int nextInt(int n) {
        return this.randomGenerator.nextInt(n);
    }

    public double nextDouble() {
        return this.randomGenerator.nextDouble();
    }

    public double nextUniform(double low, double high) {
        if (low == high) {
            return low;
        }
        return new UniformRealDistribution(this.randomGenerator, low, high).sample();
    }

    public double nextNormal(double mean, double sd) {
        return new NormalDistribution(this.randomGenerator, mean, sd).sample();
    }

    public double nextTruncatedNormal(double mean, double sd, double low, double high) {
        double d;
        if (sd < 0.0) {
            throw new IllegalArgumentException("Standard deviation must be non-negative: " + sd);
        }
        if (low >= high) {
            throw new IllegalArgumentException("Low must be less than high.");
        }
        while (!((d = this.nextNormal(mean, sd)) >= low) || !(d <= high)) {
        }
        return d;
    }

    public void revertSeed(long seed) {
        this.randomGenerator = new Well44497b(seed);
    }

    public double nextPoisson(double lambda) {
        return new PoissonDistribution(this.randomGenerator, lambda, 1.0E-12, 100000).sample();
    }

    public double normalPdf(double mean, double sd, double value) {
        return new NormalDistribution(this.randomGenerator, mean, sd).density(value);
    }

    public double normalCdf(double mean, double sd, double value) {
        return new NormalDistribution(0.0, 1.0).cumulativeProbability((value - mean) / sd);
    }

    public double nextBeta(double alpha, double beta) {
        return new BetaDistribution(this.randomGenerator, alpha, beta).sample();
    }

    public double nextT(double df) {
        return new TDistribution(this.randomGenerator, df).sample();
    }

    public double nextExponential(double lambda) {
        return new ExponentialDistribution(this.randomGenerator, lambda).sample();
    }

    public double nextGumbel(double mu, double beta) {
        return new GumbelDistribution(this.randomGenerator, mu, beta).sample();
    }

    public double nextChiSquare(double df) {
        return new ChiSquaredDistribution(this.randomGenerator, df).sample();
    }

    public double nextGamma(double shape, double scale) {
        return new GammaDistribution(this.randomGenerator, shape, scale).sample();
    }

    public void setSeed(long seed) {
        this.randomGenerator = new SynchronizedRandomGenerator(new Well44497b(seed));
    }

    public RandomGenerator getRandomGenerator() {
        return this.randomGenerator;
    }

    public long nextLong() {
        return this.randomGenerator.nextLong();
    }

    private static void testDeterminism() {
        int length = 10000000;
        long seed = 392949394L;
        RandomUtil.getInstance().setSeed(seed);
        ArrayList<Double> d1 = new ArrayList<Double>();
        for (int i = 0; i < length; ++i) {
            d1.add(RandomUtil.getInstance().nextDouble());
        }
        RandomUtil.getInstance().setSeed(seed);
        ArrayList<Double> d2 = new ArrayList<Double>();
        for (int i = 0; i < length; ++i) {
            d2.add(RandomUtil.getInstance().nextDouble());
        }
        boolean deterministic = d1.equals(d2);
        System.out.println(deterministic ? "Deterministic" : "Not deterministic");
    }

    public static void main(String[] args) {
        RandomUtil.testDeterminism();
    }
}

