/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.util.Arrays;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class RocCalculator {
    public static final int ASCENDING = 0;
    private static final int DESCENDING = 1;
    private final int direction;
    private int[][] points;
    private final ScoreCategoryPair[] scoreCatPairs;

    public RocCalculator(double[] scores, boolean[] inCategory, int direction) {
        if (scores == null) {
            throw new NullPointerException();
        }
        if (inCategory == null) {
            throw new NullPointerException();
        }
        if (scores.length != inCategory.length) {
            throw new IllegalArgumentException("Scores array must have same number of items as inCategory array.");
        }
        if (direction != 0 && direction != 1) {
            throw new IllegalArgumentException("Direction must be ASCENDING or DESCENDING.");
        }
        this.direction = direction;
        this.scoreCatPairs = new ScoreCategoryPair[scores.length];
        for (int i = 0; i < scores.length; ++i) {
            this.scoreCatPairs[i] = new ScoreCategoryPair(scores[i], inCategory[i]);
        }
    }

    public double getAuc() {
        if (this.points == null) {
            this.getUnscaledRocPlot();
        }
        int lastPoint = this.points.length - 1;
        int height = 0;
        int area = 0;
        for (int i = 1; i < this.points.length; ++i) {
            if (this.points[i][1] > this.points[i - 1][1]) {
                ++height;
                continue;
            }
            if (this.points[i][0] <= this.points[i - 1][0]) continue;
            area += height;
        }
        return (double)area / (double)(this.points[lastPoint][0] * this.points[lastPoint][1]);
    }

    private void getUnscaledRocPlot() {
        int i;
        this.sortCases();
        OrderedPairInt p0 = new OrderedPairInt(0, 0);
        LinkedList<OrderedPairInt> plot = new LinkedList<OrderedPairInt>();
        plot.add(p0);
        int numPairs = this.scoreCatPairs.length;
        for (i = numPairs - 1; i >= 0; --i) {
            ScoreCategoryPair tPrime = this.scoreCatPairs[i];
            OrderedPairInt pPrime = tPrime.getHasProperty() ? new OrderedPairInt(p0.getFirst(), p0.getSecond() + 1) : new OrderedPairInt(p0.getFirst() + 1, p0.getSecond());
            plot.add(pPrime);
            p0 = pPrime;
        }
        this.points = new int[plot.size()][2];
        for (i = 0; i < plot.size(); ++i) {
            OrderedPairInt point = (OrderedPairInt)plot.get(i);
            this.points[i][0] = point.getFirst();
            this.points[i][1] = point.getSecond();
        }
    }

    public double[][] getScaledRocPlot() {
        if (this.points == null) {
            this.getUnscaledRocPlot();
        }
        int numPoints = this.points.length;
        double[][] pointsDouble = new double[numPoints][2];
        for (int i = 0; i < numPoints; ++i) {
            pointsDouble[i][0] = (double)this.points[i][0] / (double)this.points[numPoints - 1][0];
            pointsDouble[i][1] = (double)this.points[i][1] / (double)this.points[numPoints - 1][1];
        }
        return pointsDouble;
    }

    private void sortCases() {
        Arrays.sort(this.scoreCatPairs);
        if (this.direction == 1) {
            int numPairs = this.scoreCatPairs.length;
            ScoreCategoryPair[] scpRev = new ScoreCategoryPair[numPairs];
            for (int i = 0; i < numPairs; ++i) {
                scpRev[i] = this.scoreCatPairs[numPairs - i - 1];
            }
            System.arraycopy(scpRev, 0, this.scoreCatPairs, 0, numPairs);
        }
    }

    private static class ScoreCategoryPair
    implements Comparable<ScoreCategoryPair> {
        private final double score;
        private final boolean hasProperty;

        public ScoreCategoryPair(double score, boolean hasProperty) {
            this.score = score;
            this.hasProperty = hasProperty;
        }

        public double getScore() {
            return this.score;
        }

        public boolean getHasProperty() {
            return this.hasProperty;
        }

        @Override
        public int compareTo(@NotNull ScoreCategoryPair other) {
            if (this.getScore() < other.getScore()) {
                return -1;
            }
            if (this.getScore() == other.getScore()) {
                return 0;
            }
            return 1;
        }
    }

    private static class OrderedPairInt {
        private int first;
        private int second;

        public OrderedPairInt(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public int getFirst() {
            return this.first;
        }

        public void setFirst(int first) {
            this.first = first;
        }

        public int getSecond() {
            return this.second;
        }

        public void setSecond(int second) {
            this.second = second;
        }
    }
}

