/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.annotation.ScoreAnnotations;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class ScoreDescriptions {
    private static final ScoreDescriptions INSTANCE = new ScoreDescriptions();
    private final Map<String, String> descriptions = new HashMap<String, String>();

    private ScoreDescriptions() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("manual/index.html");){
            Document doc = Jsoup.parse(inputStream, StandardCharsets.UTF_8.name(), "");
            this.getShortNames().forEach(shortName -> {
                Element element = doc.getElementById((String)shortName);
                if (element != null) {
                    Elements paragraphs = element.children();
                    String desc = paragraphs.stream().map(p -> p.text().trim()).collect(Collectors.joining("\n"));
                    this.descriptions.put((String)shortName, desc);
                }
            });
        }
        catch (IOException ex) {
            TetradLogger.getInstance().forceLogMessage("Failed to read tetrad HTML manual 'maunal/index.html' file from within the jar.");
        }
    }

    public static ScoreDescriptions getInstance() {
        return INSTANCE;
    }

    public String get(String shortName) {
        String description = this.descriptions.get(shortName);
        return description == null ? String.format("Please add a description for %s.", shortName) : description;
    }

    private List<String> getShortNames() {
        return ScoreAnnotations.getInstance().getAnnotatedClasses().stream().map(e -> ((Score)e.getAnnotation()).command()).collect(Collectors.toList());
    }
}

