/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

public final class SelectionGenerator {
    private final int a;
    private final int[] selectionLocal;
    private final int[] selectionReturned;
    private boolean begun;

    public SelectionGenerator(int a) {
        if (a < 0) {
            throw new IllegalArgumentException("a must be non-zero");
        }
        this.a = a;
        this.selectionLocal = new int[a];
        this.selectionReturned = new int[a];
        for (int i = 1; i < a; ++i) {
            this.selectionLocal[i] = 0;
        }
        if (a > 0) {
            this.selectionLocal[a - 1] = -1;
        }
        this.begun = false;
    }

    public int[] next() {
        int i = this.getA();
        while (--i > -1) {
            if (this.selectionLocal[i] >= this.getA() - 1) continue;
            int n = i;
            this.selectionLocal[n] = this.selectionLocal[n] + 1;
            for (int i1 = i + 1; i1 < this.getA(); ++i1) {
                this.selectionLocal[i1] = 0;
            }
            this.begun = true;
            System.arraycopy(this.selectionLocal, 0, this.selectionReturned, 0, this.a);
            return this.selectionReturned;
        }
        if (this.begun) {
            return null;
        }
        this.begun = true;
        System.arraycopy(this.selectionLocal, 0, this.selectionReturned, 0, this.a);
        return this.selectionReturned;
    }

    public static void testPrint(int a) {
        int[] selection;
        SelectionGenerator cg = new SelectionGenerator(a);
        System.out.println();
        System.out.println("Printing selections for " + a + " items:");
        System.out.println();
        while ((selection = cg.next()) != null) {
            if (selection.length == 0) {
                System.out.println("zero-length array");
                continue;
            }
            for (int aSelection : selection) {
                System.out.print(aSelection + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    public int getA() {
        return this.a;
    }
}

