/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;

public final class StatUtils {
    private static final double logCoshExp = StatUtils.logCoshExp();
    static double pow2 = StatUtils.pow();

    public static double mean(long[] array) {
        return StatUtils.mean(array, array.length);
    }

    public static double mean(double[] array) {
        return StatUtils.mean(array, array.length);
    }

    public static double mean(long[] array, int N) {
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < N; ++i) {
            if (array[i] == -99L) continue;
            sum += (double)array[i];
            ++count;
        }
        return sum / (double)count;
    }

    public static double mean(double[] array, int N) {
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < N; ++i) {
            if (Double.isNaN(array[i])) continue;
            sum += array[i];
            ++count;
        }
        return sum / (double)count;
    }

    public static double mean(Vector data, int N) {
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < N; ++i) {
            if (Double.isNaN(data.get(i))) continue;
            sum += data.get(i);
            ++count;
        }
        return sum / (double)count;
    }

    public static double median(long[] array) {
        return StatUtils.median(array, array.length);
    }

    public static double median(double[] array) {
        return StatUtils.median(array, array.length);
    }

    public static long median(long[] array, int N) {
        long[] a = new long[N + 1];
        System.arraycopy(array, 0, a, 0, N);
        a[N] = Long.MAX_VALUE;
        int l = 0;
        int r = N - 1;
        int k1 = r / 2;
        int k2 = r - k1;
        while (r > l) {
            long t;
            long v = a[l];
            int i = l;
            int j = r + 1;
            while (true) {
                if (a[++i] < v) {
                    continue;
                }
                while (a[--j] > v) {
                }
                if (i >= j) break;
                t = a[i];
                a[i] = a[j];
                a[j] = t;
            }
            t = a[j];
            a[j] = a[l];
            a[l] = t;
            if (j <= k1) {
                l = j + 1;
            }
            if (j < k2) continue;
            r = j - 1;
        }
        return (a[k1] + a[k2]) / 2L;
    }

    public static double median(double[] array, int N) {
        double[] a = new double[N + 1];
        System.arraycopy(array, 0, a, 0, N);
        a[N] = Double.POSITIVE_INFINITY;
        int l = 0;
        int r = N - 1;
        int k1 = r / 2;
        int k2 = r - k1;
        while (r > l) {
            double t;
            double v = a[l];
            int i = l;
            int j = r + 1;
            while (true) {
                if (a[++i] < v) {
                    continue;
                }
                while (a[--j] > v) {
                }
                if (i >= j) break;
                t = a[i];
                a[i] = a[j];
                a[j] = t;
            }
            t = a[j];
            a[j] = a[l];
            a[l] = t;
            if (j <= k1) {
                l = j + 1;
            }
            if (j < k2) continue;
            r = j - 1;
        }
        return (a[k1] + a[k2]) / 2.0;
    }

    public static double quartile(long[] array, int quartileNumber) {
        return StatUtils.quartile(array, array.length, quartileNumber);
    }

    public static double quartile(double[] array, int quartileNumber) {
        return StatUtils.quartile(array, array.length, quartileNumber);
    }

    public static double quartile(long[] array, int N, int quartileNumber) {
        if (quartileNumber < 1 || quartileNumber > 3) {
            throw new IllegalArgumentException("StatUtils.quartile:  Quartile number must be 1, 2, or 3.");
        }
        long[] a = new long[N + 1];
        System.arraycopy(array, 0, a, 0, N);
        a[N] = Long.MAX_VALUE;
        int l = 0;
        int r = N - 1;
        double doubleIndex = (double)quartileNumber / 4.0 * ((double)N + 1.0) - 1.0;
        double ratio = doubleIndex - (double)((int)doubleIndex);
        int k1 = (int)FastMath.floor(doubleIndex);
        int k2 = (int)FastMath.ceil(doubleIndex);
        while (r > l) {
            long t;
            long v = a[l];
            int i = l;
            int j = r + 1;
            while (true) {
                if (a[++i] < v) {
                    continue;
                }
                while (a[--j] > v) {
                }
                if (i >= j) break;
                t = a[i];
                a[i] = a[j];
                a[j] = t;
            }
            t = a[j];
            a[j] = a[l];
            a[l] = t;
            if (j <= k1) {
                l = j + 1;
            }
            if (j < k2) continue;
            r = j - 1;
        }
        return (double)a[k1] + ratio * (double)(a[k2] - a[k1]);
    }

    public static double quartile(double[] array, int N, int quartileNumber) {
        if (quartileNumber < 1 || quartileNumber > 3) {
            throw new IllegalArgumentException("StatUtils.quartile:  Quartile number must be 1, 2, or 3.");
        }
        double[] a = new double[N + 1];
        System.arraycopy(array, 0, a, 0, N);
        a[N] = Double.POSITIVE_INFINITY;
        int l = 0;
        int r = N - 1;
        double doubleIndex = (double)quartileNumber / 4.0 * ((double)N + 1.0) - 1.0;
        double ratio = doubleIndex - (double)((int)doubleIndex);
        int k1 = (int)FastMath.floor(doubleIndex);
        int k2 = (int)FastMath.ceil(doubleIndex);
        while (r > l) {
            double t;
            double v = a[l];
            int i = l;
            int j = r + 1;
            while (true) {
                if (a[++i] < v) {
                    continue;
                }
                while (a[--j] > v) {
                }
                if (i >= j) break;
                t = a[i];
                a[i] = a[j];
                a[j] = t;
            }
            t = a[j];
            a[j] = a[l];
            a[l] = t;
            if (j <= k1) {
                l = j + 1;
            }
            if (j < k2) continue;
            r = j - 1;
        }
        return a[k1] + ratio * (a[k2] - a[k1]);
    }

    public static double min(long[] array) {
        return StatUtils.min(array, array.length);
    }

    public static double min(double[] array) {
        return StatUtils.min(array, array.length);
    }

    public static double min(long[] array, int N) {
        double min = array[0];
        for (int i = 1; i < N; ++i) {
            if (!((double)array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static double min(double[] array, int N) {
        double min = array[0];
        for (int i = 1; i < N; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static double max(long[] array) {
        return StatUtils.max(array, array.length);
    }

    public static double max(double[] array) {
        return StatUtils.max(array, array.length);
    }

    public static double max(long[] array, int N) {
        double max = array[0];
        for (int i = 0; i < N; ++i) {
            if (!((double)array[i] > max)) continue;
            max = array[i];
        }
        return max;
    }

    public static double max(double[] array, int N) {
        double max = array[0];
        for (int i = 0; i < N; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
        }
        return max;
    }

    public static double range(long[] array) {
        return StatUtils.max(array, array.length) - StatUtils.min(array, array.length);
    }

    public static double range(double[] array) {
        return StatUtils.max(array, array.length) - StatUtils.min(array, array.length);
    }

    public static double range(long[] array, int N) {
        return StatUtils.max(array, N) - StatUtils.min(array, N);
    }

    public static double range(double[] array, int N) {
        return StatUtils.max(array, N) - StatUtils.min(array, N);
    }

    public static int N(long[] array) {
        return array.length;
    }

    public static int N(double[] array) {
        return array.length;
    }

    public static double ssx(long[] array) {
        return StatUtils.ssx(array, array.length);
    }

    public static double ssx(double[] array) {
        return StatUtils.ssx(array, array.length);
    }

    public static double ssx(long[] array, int N) {
        double meanValue = StatUtils.mean(array, N);
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            double difference = (double)array[i] - meanValue;
            sum += difference * difference;
        }
        return sum;
    }

    public static double ssx(double[] array, int N) {
        double meanValue = StatUtils.mean(array, N);
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            double difference = array[i] - meanValue;
            sum += difference * difference;
        }
        return sum;
    }

    public static double sxy(long[] array1, long[] array2) {
        int N1 = array1.length;
        int N2 = array2.length;
        if (N1 != N2) {
            throw new IllegalArgumentException("StatUtils.SXY: Arrays passed (or lengths specified) of unequal lengths.");
        }
        return StatUtils.sxy(array1, array2, N1);
    }

    public static double sxy(double[] array1, double[] array2) {
        int N1 = array1.length;
        int N2 = array2.length;
        if (N1 != N2) {
            throw new IllegalArgumentException("StatUtils.SXY: Arrays passed (or lengths specified) of unequal lengths.");
        }
        return StatUtils.sxy(array1, array2, N1);
    }

    public static double sxy(long[] array1, long[] array2, int N) {
        double sum = 0.0;
        double meanX = StatUtils.mean(array1, N);
        double meanY = StatUtils.mean(array2, N);
        for (int i = 0; i < N; ++i) {
            sum += ((double)array1[i] - meanX) * ((double)array2[i] - meanY);
        }
        return sum;
    }

    public static double sxy(double[] array1, double[] array2, int N) {
        double sum = 0.0;
        double meanX = StatUtils.mean(array1, N);
        double meanY = StatUtils.mean(array2, N);
        for (int i = 0; i < N; ++i) {
            sum += (array1[i] - meanX) * (array2[i] - meanY);
        }
        return sum;
    }

    public static double sxy(Vector data1, Vector data2, int N) {
        double sum = 0.0;
        double meanX = StatUtils.mean(data1, N);
        double meanY = StatUtils.mean(data2, N);
        for (int i = 0; i < N; ++i) {
            sum += (data1.get(i) - meanX) * (data2.get(i) - meanY);
        }
        return sum;
    }

    public static double variance(long[] array) {
        return StatUtils.variance(array, array.length);
    }

    public static double variance(double[] array) {
        return StatUtils.variance(array, array.length);
    }

    public static double variance(long[] array, int N) {
        return StatUtils.ssx(array, N) / (double)(N - 1);
    }

    public static double variance(double[] array, int N) {
        return StatUtils.ssx(array, N) / (double)(N - 1);
    }

    public static double sd(long[] array) {
        return StatUtils.sd(array, array.length);
    }

    public static double sd(double[] array) {
        return StatUtils.sd(array, array.length);
    }

    public static double sd(long[] array, int N) {
        return FastMath.pow(StatUtils.ssx(array, N) / (double)(N - 1), 0.5);
    }

    public static double sd(double[] array, int N) {
        return FastMath.pow(StatUtils.ssx(array, N) / (double)(N - 1), 0.5);
    }

    public static double covariance(long[] array1, long[] array2) {
        int N1 = array1.length;
        int N2 = array2.length;
        if (N1 != N2) {
            throw new IllegalArgumentException("Arrays passed (or lengths specified) of unequal lengths.");
        }
        return StatUtils.covariance(array1, array2, N1);
    }

    public static double covariance(double[] array1, double[] array2) {
        int N1 = array1.length;
        int N2 = array2.length;
        if (N1 != N2) {
            throw new IllegalArgumentException("Arrays passed (or lengths specified) of unequal lengths.");
        }
        return StatUtils.covariance(array1, array2, N1);
    }

    public static double covariance(long[] array1, long[] array2, int N) {
        return StatUtils.sxy(array1, array2, N) / (double)(N - 1);
    }

    public static double covariance(double[] array1, double[] array2, int N) {
        return StatUtils.sxy(array1, array2, N) / (double)(N - 1);
    }

    public static double correlation(long[] array1, long[] array2) {
        int N1 = array1.length;
        int N2 = array2.length;
        if (N1 != N2) {
            throw new IllegalArgumentException("Arrays passed (or lengths specified) of unequal lengths.");
        }
        return StatUtils.correlation(array1, array2, N1);
    }

    public static double correlation(double[] array1, double[] array2) {
        int N1 = array1.length;
        int N2 = array2.length;
        if (N1 != N2) {
            throw new IllegalArgumentException("Arrays passed (or lengths specified) of unequal lengths.");
        }
        return StatUtils.correlation(array1, array2, N1);
    }

    public static double correlation(Vector data1, Vector data2) {
        int N = data1.size();
        double covXY = StatUtils.sxy(data1, data2, N);
        double covXX = StatUtils.sxy(data1, data1, N);
        double covYY = StatUtils.sxy(data2, data2, N);
        return covXY / (FastMath.sqrt(covXX) * FastMath.sqrt(covYY));
    }

    public static short compressedCorrelation(Vector data1, Vector data2) {
        return (short)(StatUtils.correlation(data1, data2) * 10000.0);
    }

    public static double correlation(long[] array1, long[] array2, int N) {
        double covXY = StatUtils.sxy(array1, array2, N);
        double covXX = StatUtils.sxy(array1, array1, N);
        double covYY = StatUtils.sxy(array2, array2, N);
        return covXY / (FastMath.pow(covXX, 0.5) * FastMath.pow(covYY, 0.5));
    }

    public static double correlation(double[] array1, double[] array2, int N) {
        double covXY = StatUtils.sxy(array1, array2, N);
        double covXX = StatUtils.sxy(array1, array1, N);
        double covYY = StatUtils.sxy(array2, array2, N);
        return covXY / (FastMath.sqrt(covXX) * FastMath.sqrt(covYY));
    }

    public static double rankCorrelation(double[] arr1, double[] arr2) {
        if (arr1.length != arr2.length) {
            throw new IllegalArgumentException("Arrays not the same length.");
        }
        double[] ranks1 = StatUtils.getRanks(arr1);
        double[] ranks2 = StatUtils.getRanks(arr2);
        return StatUtils.correlation(ranks1, ranks2);
    }

    public static double kendallsTau(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays not the same length.");
        }
        int numerator = 0;
        int N = x.length;
        for (int i = 0; i < N; ++i) {
            for (int j = i + 1; j < N; ++j) {
                numerator = (int)((double)numerator + FastMath.signum(x[i] - x[j]) * FastMath.signum(y[i] - y[j]));
            }
        }
        return (double)numerator / (0.5 * (double)N * (double)(N - 1));
    }

    public static double[] getRanks(double[] arr) {
        double[] arr2 = new double[arr.length];
        System.arraycopy(arr, 0, arr2, 0, arr.length);
        Arrays.sort(arr2);
        double[] ranks = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            double sum = 0.0;
            int n = 0;
            for (int j = 0; j < arr2.length; ++j) {
                if (arr2[j] != arr[i]) continue;
                sum += (double)(j + 1);
                ++n;
            }
            ranks[i] = sum / (double)n;
        }
        return ranks;
    }

    public static double sSquare(long[] array) {
        return StatUtils.sSquare(array, array.length);
    }

    public static double sSquare(double[] array) {
        return StatUtils.ssx(array, array.length);
    }

    public static double sSquare(long[] array, int N) {
        return StatUtils.ssx(array, N) / (double)(N - 1);
    }

    public static double sSquare(double[] array, int N) {
        return StatUtils.ssx(array, N) / (double)(N - 1);
    }

    public static double varHat(long[] array) {
        return StatUtils.varHat(array, array.length);
    }

    public static double varHat(double[] array) {
        return StatUtils.varHat(array, array.length);
    }

    public static double varHat(long[] array, int N) {
        double sum = 0.0;
        double meanX = StatUtils.mean(array, N);
        for (int i = 0; i < N; ++i) {
            double difference = (double)array[i] - meanX;
            sum += difference * difference;
        }
        return sum / (double)(N - 1);
    }

    public static double varHat(double[] array, int N) {
        double sum = 0.0;
        double meanX = StatUtils.mean(array, N);
        for (int i = 0; i < N; ++i) {
            double difference = array[i] - meanX;
            sum += difference * difference;
        }
        return sum / (double)(N - 1);
    }

    public static double mu(long[] array) {
        return StatUtils.mean(array, array.length);
    }

    public static double mu(double[] array) {
        return StatUtils.mean(array, array.length);
    }

    public static double mu(long[] array, int N) {
        return StatUtils.mean(array, N);
    }

    public static double mu(double[] array, int N) {
        return StatUtils.mean(array, N);
    }

    public static double muHat(long[] array) {
        return StatUtils.muHat(array, array.length);
    }

    public static double muHat(double[] array) {
        return StatUtils.muHat(array, array.length);
    }

    public static double muHat(long[] array, int N) {
        return StatUtils.mean(array, N);
    }

    public static double muHat(double[] array, int N) {
        return StatUtils.mean(array, N);
    }

    public static double averageDeviation(long[] array) {
        return StatUtils.averageDeviation(array, array.length);
    }

    public static double averageDeviation(double[] array) {
        return StatUtils.averageDeviation(array, array.length);
    }

    public static double averageDeviation(long[] array, int N) {
        double mean = StatUtils.mean(array, N);
        double adev = 0.0;
        for (int j = 0; j < N; ++j) {
            adev += FastMath.abs((double)array[j] - mean);
        }
        return adev /= (double)N;
    }

    public static double averageDeviation(double[] array, int N) {
        double mean = StatUtils.mean(array, N);
        double adev = 0.0;
        for (int j = 0; j < N; ++j) {
            adev += FastMath.abs(array[j] - mean);
        }
        return adev /= (double)N;
    }

    public static double skewness(long[] array) {
        return StatUtils.skewness(array, array.length);
    }

    public static double skewness(double[] array) {
        return StatUtils.skewness(array, array.length);
    }

    public static double skewness(long[] array, int N) {
        double mean = StatUtils.mean(array, N);
        double secondMoment = 0.0;
        double thirdMoment = 0.0;
        for (int j = 0; j < N; ++j) {
            double s = (double)array[j] - mean;
            secondMoment += s * s;
            thirdMoment += s * s * s;
        }
        double ess = secondMoment / (double)(N - 1);
        double esss = thirdMoment / (double)N;
        if (secondMoment == 0.0) {
            throw new ArithmeticException("StatUtils.skew:  There is no skew when the variance is zero.");
        }
        return esss / FastMath.pow(ess, 1.5);
    }

    public static double skewness(double[] array, int N) {
        double mean = StatUtils.mean(array, N);
        double secondMoment = 0.0;
        double thirdMoment = 0.0;
        for (int j = 0; j < N; ++j) {
            double s = array[j] - mean;
            secondMoment += s * s;
            thirdMoment += s * s * s;
        }
        double ess = secondMoment / (double)N;
        double esss = thirdMoment / (double)N;
        if (secondMoment == 0.0) {
            throw new ArithmeticException("StatUtils.skew:  There is no skew when the variance is zero.");
        }
        return esss / FastMath.pow(ess, 1.5);
    }

    public static double[] removeNaN(double[] x1) {
        int i;
        for (i = 0; i < x1.length && !Double.isNaN(x1[i]); ++i) {
        }
        i = i > x1.length ? x1.length : i;
        return Arrays.copyOf(x1, i);
    }

    public static double kurtosis(long[] array) {
        return StatUtils.kurtosis(array, array.length);
    }

    public static double kurtosis(double[] array) {
        return StatUtils.kurtosis(array, array.length);
    }

    public static double kurtosis(long[] array, int N) {
        double mean = StatUtils.mean(array, N);
        double variance = StatUtils.variance(array, N);
        double kurt = 0.0;
        for (int j = 0; j < N; ++j) {
            double s = (double)array[j] - mean;
            kurt += s * s * s * s;
        }
        if (variance == 0.0) {
            throw new ArithmeticException("Kurtosis is undefined when variance is zero.");
        }
        kurt /= (double)N;
        kurt = kurt / (variance * variance) - 3.0;
        return kurt;
    }

    public static double standardizedFifthMoment(double[] array) {
        return StatUtils.standardizedFifthMoment(array, array.length);
    }

    public static double standardizedFifthMoment(double[] array, int N) {
        double mean = StatUtils.mean(array, N);
        double variance = StatUtils.variance(array, N);
        double kurt = 0.0;
        for (int j = 0; j < N; ++j) {
            double s = array[j] - mean;
            kurt += s * s * s * s * s;
        }
        if (variance == 0.0) {
            throw new ArithmeticException("Kurtosis is undefined when variance is zero.");
        }
        return kurt /= (double)N * FastMath.pow(variance, 2.5);
    }

    public static double standardizedSixthMoment(double[] array) {
        return StatUtils.standardizedFifthMoment(array, array.length);
    }

    public static double standardizedSixthMoment(double[] array, int N) {
        double mean = StatUtils.mean(array, N);
        double variance = StatUtils.variance(array, N);
        double kurt = 0.0;
        for (int j = 0; j < N; ++j) {
            double s = array[j] - mean;
            kurt += s * s * s * s * s * s;
        }
        if (variance == 0.0) {
            throw new ArithmeticException("Kurtosis is undefined when variance is zero.");
        }
        return kurt /= (double)N * FastMath.pow(variance, 3.0);
    }

    public static double kurtosis(double[] array, int N) {
        double mean = StatUtils.mean(array, N);
        double variance = StatUtils.variance(array, N);
        double kurt = 0.0;
        for (int j = 0; j < N; ++j) {
            double s = array[j] - mean;
            kurt += s * s * s * s;
        }
        kurt /= (double)N;
        kurt = kurt / (variance * variance) - 3.0;
        kurt = (double)((N + 1) * N) / (double)((N - 1) * (N - 2) * (N - 3)) * kurt - (double)(3 * (N - 1) * (N - 1)) / (double)((N - 2) * (N - 3));
        return kurt;
    }

    public static double gamma(double z) {
        if (z < 2.0) {
            return StatUtils.Internalgamma(z);
        }
        double multiplier = FastMath.floor(z / 1.2);
        double remainder = z / multiplier;
        double coef1 = FastMath.pow(Math.PI * 2, 0.5 * (1.0 - multiplier));
        double coef2 = FastMath.pow(multiplier, multiplier * remainder - 0.5);
        int N = (int)multiplier;
        double prod = 1.0;
        for (int k = 0; k < N; ++k) {
            prod *= StatUtils.Internalgamma(remainder + (double)k / multiplier);
        }
        return coef1 * coef2 * prod;
    }

    private static double Internalgamma(double z) {
        double sum = 0.0;
        double[] c = new double[]{1.0, 0.5772156649015329, -0.6558780715202538, -0.0420026350340952, 0.1665386113822915, -0.0421977345555443, -0.009621971527877, 0.007218943246663, -0.0011651675918591, -2.152416741149E-4, 1.280502823882E-4, -2.01348547807E-5, -1.2504934821E-6, 1.133027232E-6, -2.056338417E-7, 6.116095E-9, 5.0020075E-9, -1.1812746E-9, 1.043427E-10, 7.7823E-12, -3.6968E-12, 5.1E-13, -2.06E-14, -5.4E-15, 1.4E-15, 1.0E-16};
        for (int i = 0; i < c.length; ++i) {
            sum += c[i] * FastMath.pow(z, i + 1);
        }
        return 1.0 / sum;
    }

    public static double beta(double x1, double x2) {
        return StatUtils.gamma(x1) * StatUtils.gamma(x2) / StatUtils.gamma(x1 + x2);
    }

    public static double igamma(double a, double x) {
        double coef = FastMath.exp(-x) * FastMath.pow(x, a) / StatUtils.gamma(a);
        double sum = 0.0;
        for (int i = 0; i < 100; ++i) {
            sum += StatUtils.gamma(a) / StatUtils.gamma(a + 1.0 + (double)i) * FastMath.pow(x, i);
        }
        return coef * sum;
    }

    public static double erf(double x) {
        return StatUtils.igamma(0.5, FastMath.pow(x, 2.0));
    }

    public static double poisson(double k, double x, boolean cum) {
        if (x < 0.0 || k < 1.0) {
            throw new ArithmeticException("The Poisson Distribution Function requires x>=0 and k >= 1");
        }
        k += 1.0;
        if (cum) {
            return 1.0 - StatUtils.igamma(k, x);
        }
        return FastMath.exp(-x) * FastMath.pow(x, k) / StatUtils.gamma(k);
    }

    public static double chidist(double x, int degreesOfFreedom) {
        if (x < 0.0 || degreesOfFreedom < 0) {
            throw new ArithmeticException("The Chi Distribution Function requires x > 0.0 and degrees of freedom > 0");
        }
        return 1.0 - StatUtils.igamma((double)degreesOfFreedom / 2.0, x / 2.0);
    }

    public static int dieToss(int n) {
        return (int)FastMath.floor((double)n * FastMath.random());
    }

    public static double fdrCutoff(double alpha, List<Double> pValues, boolean negativelyCorrelated, boolean pSorted) {
        return StatUtils.fdrCutoff(alpha, pValues, new int[1], negativelyCorrelated, pSorted);
    }

    public static double fdrCutoff(double alpha, List<Double> pValues, boolean negativelyCorrelated) {
        return StatUtils.fdrCutoff(alpha, pValues, new int[1], negativelyCorrelated, false);
    }

    public static double fdrCutoff(double alpha, List<Double> pValues, int[] _k, boolean negativelyCorrelated, boolean pSorted) {
        if (_k.length != 1) {
            throw new IllegalArgumentException("k must be a length 1 int array, to return the index of q.");
        }
        if (!pSorted) {
            Collections.sort(pValues);
        }
        _k[0] = StatUtils.fdr(alpha, pValues, negativelyCorrelated, true);
        return _k[0] == -1 ? 0.0 : pValues.get(_k[0]);
    }

    public static int fdr(double alpha, List<Double> pValues) {
        return StatUtils.fdr(alpha, pValues, true, false);
    }

    public static int fdr(double alpha, List<Double> pValues, boolean negativelyCorrelated, boolean pSorted) {
        if (!pSorted) {
            pValues = new ArrayList<Double>(pValues);
            Collections.sort(pValues);
        }
        int m = pValues.size();
        if (negativelyCorrelated) {
            double[] c = new double[m];
            double _c = 0.0;
            for (int i = 0; i < m; ++i) {
                c[i] = _c += 1.0 / (double)(i + 1);
            }
            int _k = -1;
            for (int k = 0; k < m; ++k) {
                if (!(pValues.get(k) <= (double)(k + 1) / (c[k] * (double)(m + 1)) * alpha)) continue;
                _k = k;
            }
            return _k;
        }
        int _k = -1;
        for (int k = 0; k < m; ++k) {
            if (!(pValues.get(k) <= (double)(k + 1) / (double)(m + 1) * alpha)) continue;
            _k = k;
        }
        return _k;
    }

    public static double fdrQ(List<Double> pValues, int k) {
        double high = 1.0;
        double low = 0.0;
        double q = Double.NaN;
        int lastK = -1;
        while (high - low > 0.0) {
            q = (high + low) / 2.0;
            int _k = StatUtils.fdr(q, pValues);
            if (_k == lastK) {
                high = q;
                low = q;
            } else if (_k > k) {
                high = q;
            } else if (_k < k) {
                low = q;
            }
            lastK = _k;
        }
        return q;
    }

    public static double partialCovarianceWhittaker(Matrix submatrix) {
        double covXy = submatrix.get(0, 1);
        int[] _z = new int[submatrix.rows() - 2];
        for (int i = 0; i < submatrix.rows() - 2; ++i) {
            _z[i] = i + 2;
        }
        Matrix covXz = submatrix.getSelection(new int[]{0}, _z);
        Matrix covZy = submatrix.getSelection(_z, new int[]{1});
        Matrix covZ = submatrix.getSelection(_z, _z);
        Matrix _zInverse = covZ.inverse();
        Matrix temp1 = covXz.times(_zInverse);
        Matrix temp2 = temp1.times(covZy);
        return covXy - temp2.get(0, 0);
    }

    public static double partialCovarianceWhittaker(Matrix covariance, int x, int y, int ... z) {
        if (x > covariance.rows()) {
            throw new IllegalArgumentException();
        }
        if (y > covariance.rows()) {
            throw new IllegalArgumentException();
        }
        for (int aZ : z) {
            if (aZ <= covariance.rows()) continue;
            throw new IllegalArgumentException();
        }
        int[] selection = new int[z.length + 2];
        selection[0] = x;
        selection[1] = y;
        System.arraycopy(z, 0, selection, 2, z.length);
        return StatUtils.partialCovarianceWhittaker(covariance.getSelection(selection, selection));
    }

    public static double partialVariance(Matrix covariance, int x, int ... z) {
        return StatUtils.partialCovarianceWhittaker(covariance, x, x, z);
    }

    public static double partialStandardDeviation(Matrix covariance, int x, int ... z) {
        double var = StatUtils.partialVariance(covariance, x, z);
        return FastMath.sqrt(var);
    }

    public static synchronized double partialCorrelation(Matrix submatrix) throws SingularMatrixException {
        return StatUtils.partialCorrelationPrecisionMatrix(submatrix);
    }

    public static double partialCorrelationPrecisionMatrix(Matrix submatrix) throws SingularMatrixException {
        Matrix inverse = submatrix.inverse();
        return -inverse.get(0, 1) / FastMath.sqrt(inverse.get(0, 0) * inverse.get(1, 1));
    }

    public static double partialCorrelation(Matrix covariance, int x, int y, int ... z) {
        if (x > covariance.rows()) {
            throw new IllegalArgumentException();
        }
        if (y > covariance.rows()) {
            throw new IllegalArgumentException();
        }
        for (int aZ : z) {
            if (aZ <= covariance.rows()) continue;
            throw new IllegalArgumentException();
        }
        int[] selection = new int[z.length + 2];
        selection[0] = x;
        selection[1] = y;
        System.arraycopy(z, 0, selection, 2, z.length);
        return StatUtils.partialCorrelation(covariance.getSelection(selection, selection));
    }

    public static double logCoshScore(double[] _f) {
        _f = StatUtils.standardizeData(_f);
        DoubleArrayList f = new DoubleArrayList(_f);
        for (int k = 0; k < _f.length; ++k) {
            double v = FastMath.log(FastMath.cosh(f.get(k)));
            f.set(k, v);
        }
        double expected = Descriptive.mean(f);
        double diff = expected - logCoshExp;
        return diff * diff;
    }

    public static double meanAbsolute(double[] _f) {
        _f = StatUtils.standardizeData(_f);
        for (int k = 0; k < _f.length; ++k) {
            _f[k] = FastMath.abs(_f[k]);
        }
        double expected = StatUtils.mean(_f);
        double diff = expected - FastMath.sqrt(0.6366197723675814);
        return diff * diff;
    }

    public static double pow() {
        double sum = 0.0;
        for (int i = 0; i < 1000; ++i) {
            sum += FastMath.abs(RandomUtil.getInstance().nextNormal(0.0, 1.0));
        }
        return sum / 1000.0;
    }

    public static double expScore(double[] _f) {
        DoubleArrayList f = new DoubleArrayList(_f);
        for (int k = 0; k < _f.length; ++k) {
            f.set(k, FastMath.exp(f.get(k)));
        }
        double expected = Descriptive.mean(f);
        return FastMath.log(expected);
    }

    public static double logCoshExp() {
        return 0.3746764078432371;
    }

    public static double entropy(int numBins, double[] _f) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (double x : _f) {
            if (x < min) {
                min = x;
            }
            if (!(x > max)) continue;
            max = x;
        }
        int[] v = new int[numBins];
        double width = max - min;
        for (double x : _f) {
            int bin;
            double x3 = (x - min) / width;
            int n = bin = (int)(x3 * (double)(numBins - 1));
            v[n] = v[n] + 1;
        }
        double sum = 0.0;
        for (int aV : v) {
            if (aV == 0) continue;
            double p = (double)aV / (double)(numBins - 1);
            sum += p * FastMath.log(p);
        }
        return -sum;
    }

    public static double maxEntApprox(double[] x) {
        double xstd = StatUtils.sd(x);
        x = StatUtils.standardizeData(x);
        double k1 = 36.0 / (8.0 * FastMath.sqrt(3.0) - 9.0);
        double gamma = 0.37457;
        double k2 = 79.047;
        double gaussianEntropy = FastMath.log(Math.PI * 2) / 2.0 + 0.5;
        double b1 = 0.0;
        for (double aX1 : x) {
            b1 += FastMath.log(FastMath.cosh(aX1));
        }
        b1 /= (double)x.length;
        double b2 = 0.0;
        for (double aX : x) {
            b2 += aX * FastMath.exp(FastMath.pow(-aX, 2) / 2.0);
        }
        double negentropy = 79.047 * FastMath.pow(b1 - 0.37457, 2) + k1 * FastMath.pow(b2 /= (double)x.length, 2);
        return gaussianEntropy - negentropy + FastMath.log(xstd);
    }

    public static double[] standardizeData(double[] data) {
        double[] data2 = new double[data.length];
        double sum = 0.0;
        for (double aData : data) {
            sum += aData;
        }
        double mean = sum / (double)data.length;
        for (int i = 0; i < data.length; ++i) {
            data2[i] = data[i] - mean;
        }
        double norm = 0.0;
        for (double v : data2) {
            norm += v * v;
        }
        norm = FastMath.sqrt(norm / (double)(data2.length - 1));
        for (int i = 0; i < data2.length; ++i) {
            data2[i] = data2[i] / norm;
        }
        return data2;
    }

    public static double factorial(int c) {
        if (c < 0) {
            throw new IllegalArgumentException("Can't take the factorial of a negative number: " + c);
        }
        if (c == 0) {
            return 1.0;
        }
        return (double)c * StatUtils.factorial(c - 1);
    }

    public static double getZForAlpha(double alpha) {
        NormalDistribution dist = new NormalDistribution(0.0, 1.0);
        return 1.0 - dist.inverseCumulativeProbability(alpha / 2.0);
    }

    public static double logsum(List<Double> logs) {
        logs.sort((o1, o2) -> -Double.compare(o1, o2));
        double sum = 0.0;
        int N = logs.size() - 1;
        double loga0 = logs.get(0);
        for (int i = 1; i <= N; ++i) {
            sum += FastMath.exp(logs.get(i) - loga0);
        }
        return loga0 + FastMath.log(sum += 1.0);
    }

    public static double sum(double[] x) {
        double sum = 0.0;
        for (double xx : x) {
            sum += xx;
        }
        return sum;
    }

    public static double[] cov(double[] x, double[] y, double[] condition, double threshold, double direction) {
        double exy = 0.0;
        double exx = 0.0;
        double eyy = 0.0;
        double ex = 0.0;
        double ey = 0.0;
        int n = 0;
        for (int k = 0; k < x.length; ++k) {
            if (direction > threshold) {
                if (!(condition[k] > threshold)) continue;
                exy += x[k] * y[k];
                exx += x[k] * x[k];
                eyy += y[k] * y[k];
                ex += x[k];
                ey += y[k];
                ++n;
                continue;
            }
            if (!(direction < threshold) || !(condition[k] > threshold)) continue;
            exy += x[k] * y[k];
            exx += x[k] * x[k];
            eyy += y[k] * y[k];
            ex += x[k];
            ey += y[k];
            ++n;
        }
        double sxy = (exy /= (double)n) - (ex /= (double)n) * (ey /= (double)n);
        double sx = (exx /= (double)n) - ex * ex;
        double sy = (eyy /= (double)n) - ey * ey;
        return new double[]{sxy, sxy / FastMath.sqrt(sx * sy), sx, sy, n, ex, ey, sxy / sx};
    }

    public static double[][] covMatrix(double[] x, double[] y, double[][] z, double[] condition, double threshold, double direction) {
        int i;
        List<Integer> rows = StatUtils.getRows(condition, threshold, direction);
        double[][] allData = new double[z.length + 2][];
        allData[0] = x;
        allData[1] = y;
        System.arraycopy(z, 0, allData, 2, z.length);
        double[][] subdata = new double[allData.length][rows.size()];
        for (int c = 0; c < allData.length; ++c) {
            for (i = 0; i < rows.size(); ++i) {
                try {
                    subdata[c][i] = allData[c][rows.get(i)];
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        double[][] cov = new double[z.length + 2][z.length + 2];
        for (i = 0; i < z.length + 2; ++i) {
            for (int j = i; j < z.length + 2; ++j) {
                double c;
                cov[i][j] = c = StatUtils.covariance(subdata[i], subdata[j]);
                cov[j][i] = c;
            }
        }
        return cov;
    }

    public static List<Integer> getRows(double[] x, double threshold, double direction) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int k = 0; k < x.length; ++k) {
            if (direction > threshold) {
                if (!(x[k] > threshold)) continue;
                rows.add(k);
                continue;
            }
            if (direction < threshold) {
                if (!(x[k] > threshold)) continue;
                rows.add(k);
                continue;
            }
            if (!(x[k] > threshold)) continue;
            rows.add(k);
        }
        return rows;
    }

    public static List<Integer> getRows(double[] x, double[] condition, double threshold, double direction) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int k = 0; k < x.length; ++k) {
            if (direction > threshold) {
                if (!(condition[k] > threshold)) continue;
                rows.add(k);
                continue;
            }
            if (!(direction < threshold) || !(condition[k] > threshold)) continue;
            rows.add(k);
        }
        return rows;
    }

    public static double[] E(double[] x, double[] y, double[] condition, double threshold, double direction) {
        double exy = 0.0;
        double exx = 0.0;
        double eyy = 0.0;
        int n = 0;
        for (int k = 0; k < x.length; ++k) {
            if (direction > threshold) {
                if (!(condition[k] > threshold)) continue;
                exy += x[k] * y[k];
                exx += x[k] * x[k];
                eyy += y[k] * y[k];
                ++n;
                continue;
            }
            if (!(direction < threshold) || !(condition[k] > threshold)) continue;
            exy += x[k] * y[k];
            exx += x[k] * x[k];
            eyy += y[k] * y[k];
            ++n;
        }
        exx /= (double)n;
        eyy /= (double)n;
        exy /= (double)n;
        double exye = 0.0;
        double exxe = 0.0;
        double eyye = 0.0;
        for (int k = 0; k < x.length; ++k) {
            if (direction > threshold) {
                if (!(condition[k] > threshold)) continue;
                exye += (x[k] * y[k] - exy) * (x[k] * y[k] - exy);
                exxe += (x[k] * x[k] - exx) * (x[k] * x[k] - exx);
                eyye += (y[k] * y[k] - eyy) * (y[k] * y[k] - eyy);
                continue;
            }
            if (!(direction < threshold) || !(condition[k] > threshold)) continue;
            exye += (x[k] * y[k] - exy) * (x[k] * y[k] - exy);
            exxe += (x[k] * x[k] - exx) * (x[k] * x[k] - exx);
            eyye += (y[k] * y[k] - eyy) * (y[k] * y[k] - eyy);
        }
        double exyv = FastMath.sqrt((exye /= (double)n) / FastMath.sqrt((exxe /= (double)n) * (eyye /= (double)n))) / FastMath.sqrt(n - 1);
        return new double[]{exy, exy / FastMath.sqrt(exx * eyy), exx, eyy, n, exyv};
    }
}

