/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;

public class Beta
implements Distribution {
    static final long serialVersionUID = 23L;
    private double alpha = 0.5;
    private double beta = 0.5;

    private Beta() {
    }

    public static Beta serializableInstance() {
        return new Beta();
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextBeta(this.alpha, this.beta);
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.alpha = value;
        } else if (index == 1 && value >= 0.0) {
            this.beta = value;
        } else {
            throw new IllegalArgumentException("Illegal value: " + value);
        }
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.alpha;
        }
        if (index == 1) {
            return this.beta;
        }
        throw new IllegalArgumentException("Illegal index: " + index);
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Alpha";
        }
        if (index == 1) {
            return "Beta";
        }
        throw new IllegalArgumentException("Not a parameter index: " + index);
    }

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public String getName() {
        return "Beta";
    }

    public String toString() {
        return "B(" + this.alpha + ", " + this.beta + ")";
    }
}

