/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;
import org.apache.commons.math3.util.FastMath;

public class GaussianPower
implements Distribution {
    static final long serialVersionUID = 23L;
    private final double sd;
    private double power;
    private final String name;

    @Override
    public String getName() {
        return this.name;
    }

    public static GaussianPower serializableInstance() {
        return new GaussianPower(2.0);
    }

    public GaussianPower(double power) {
        this.sd = 1.0;
        this.power = power;
        this.name = "N^" + power + "(" + 0 + "," + 1.0 + ")";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.power = value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.sd;
        }
        if (index == 1) {
            return this.power;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Standard Deviation";
        }
        if (index == 1) {
            return "Power";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public double nextRandom() {
        double value = RandomUtil.getInstance().nextNormal(0.0, 1.0);
        double poweredValue = FastMath.pow(FastMath.abs(value), this.power);
        return value >= 0.0 ? poweredValue : -poweredValue;
    }
}

