/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;
import org.apache.commons.math3.util.FastMath;

public class LogNormal
implements Distribution {
    static final long serialVersionUID = 23L;
    private double sd;

    public static LogNormal serializableInstance() {
        return new LogNormal(0.5);
    }

    public LogNormal(double sd) {
        this.sd = sd;
    }

    @Override
    public int getNumParameters() {
        return 1;
    }

    @Override
    public String getName() {
        return "LogNormal";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.sd = value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.sd;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getParameterName(int index) {
        return "Standard Deviation";
    }

    @Override
    public double nextRandom() {
        double random = RandomUtil.getInstance().nextNormal(0.0, this.sd);
        return FastMath.exp(random);
    }

    public String toString() {
        return "LogNormal";
    }
}

