/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;

public class Split
implements Distribution {
    static final long serialVersionUID = 23L;
    private double a;
    private double b;

    public Split(double a, double b) {
        if (a < 0.0) {
            throw new IllegalArgumentException("When asking for a range from a to b, the value of a must be >= 0: a = " + a + " b = " + b);
        }
        if (b <= a) {
            throw new IllegalArgumentException("When asking for a range from a to b, the value of b must be > a: a = " + a + " b = " + b);
        }
        this.a = a;
        this.b = b;
    }

    public static Split serializableInstance() {
        return new Split(0.0, 1.0);
    }

    @Override
    public double nextRandom() {
        double c = RandomUtil.getInstance().nextDouble();
        double value = this.getA() + c * (this.getB() - this.getA());
        if (RandomUtil.getInstance().nextDouble() < 0.5) {
            value *= -1.0;
        }
        return value;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    @Override
    public String getName() {
        return "Split Distribution";
    }

    public String toString() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        return "Split(" + nf.format(this.a) + ", " + nf.format(this.b) + ", )";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0 && value < this.b) {
            this.a = value;
        } else if (index == 1 && value > this.a) {
            this.b = value;
        } else {
            throw new IllegalArgumentException("Cannot set value of " + index + " to " + value);
        }
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.a;
        }
        if (index == 1) {
            return this.b;
        }
        throw new IllegalArgumentException("There is no parameter " + index);
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Lower bound (> 0)";
        }
        if (index == 1) {
            return "Upper bound (> 0)";
        }
        throw new IllegalArgumentException("Not a parameter index: " + index);
    }

    @Override
    public int getNumParameters() {
        return 2;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.a < 0.0) {
            throw new IllegalStateException();
        }
        if (this.b <= this.a) {
            throw new IllegalStateException();
        }
    }
}

