/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp;

import edu.cmu.tetrad.graph.NodeEqualityMode;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Version;
import edu.cmu.tetradapp.app.TetradDesktop;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.ImageUtils;
import edu.cmu.tetradapp.util.SplashScreen;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.commons.math3.util.FastMath;

public final class Tetrad
implements PropertyChangeListener {
    private static final String EXP_OPT = "--experimental";
    private JFrame frame;
    private TetradDesktop desktop;
    private final String mainTitle = "Tetrad " + Version.currentViewableVersion();
    public static boolean enableExperimental;

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("exitProgram".equals(e.getPropertyName())) {
            this.exitApplication();
        }
    }

    public static void main(String[] argv) {
        boolean enableExperimental;
        if (argv != null && argv.length > 0) {
            Tetrad.enableExperimental = EXP_OPT.equals(argv[0]);
        }
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        Tetrad.setLookAndFeel();
        Locale.setDefault(Locale.US);
        SplashScreen.show("Loading Tetrad...", 1000);
        EventQueue.invokeLater(() -> new Tetrad().launchFrame());
        Tetrad.enableExperimental = enableExperimental = Preferences.userRoot().getBoolean("enableExperimental", false);
    }

    private static void setLookAndFeel() {
        try {
            String os = System.getProperties().getProperty("os.name");
            if (os.equals("Windows XP")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void launchFrame() {
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        NodeEqualityMode.setEqualityMode(NodeEqualityMode.Type.OBJECT);
        this.desktop = new TetradDesktop();
        this.getDesktop().addPropertyChangeListener(this);
        JOptionUtils.setCenteringComp(this.getDesktop());
        DesktopController.setReference(this.getDesktop());
        this.frame = new JFrame(this.mainTitle){
            private static final long serialVersionUID = -9077349253115802418L;

            @Override
            public Dimension getPreferredSize() {
                Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                double minLength = FastMath.min(size.getWidth(), size.getHeight());
                double height = minLength * 0.8;
                double width = height * 1.3333333333333333;
                return new Dimension((int)width, (int)height);
            }
        };
        this.frame.setPreferredSize(Toolkit.getDefaultToolkit().getScreenSize());
        this.getFrame().setContentPane(this.getDesktop());
        this.getFrame().pack();
        this.getFrame().setLocationRelativeTo(null);
        Image image = ImageUtils.getImage(this, "tyler16.png");
        this.getFrame().setIconImage(image);
        this.getDesktop().newSessionEditor();
        this.getFrame().setVisible(true);
        this.getFrame().setDefaultCloseOperation(0);
        this.getFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Tetrad.this.exitApplication();
            }
        });
        SplashScreen.hide();
    }

    private void exitApplication() {
        boolean succeeded = this.getDesktop().closeAllSessions();
        if (!succeeded) {
            return;
        }
        this.getFrame().setVisible(false);
        this.getFrame().dispose();
        TetradLogger.getInstance().removeNextOutputStream();
        try {
            System.exit(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JFrame getFrame() {
        return this.frame;
    }

    private TetradDesktop getDesktop() {
        return this.desktop;
    }
}

