/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetradapp.app.ModelChooser;
import edu.cmu.tetradapp.app.SessionNodeModelConfig;
import edu.cmu.tetradapp.app.SessionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CategorizingModelChooser
extends JPanel
implements ModelChooser {
    private String title;
    private String nodeName;
    private String nodeId;
    private JTree tree;
    private SessionNode sessionNode;

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException("The title must not be null");
        }
        this.title = title;
    }

    @Override
    public Class getSelectedModel() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            throw new NullPointerException("I had a problem figuring out the models for this box given the parents. Maybe\nthe parents are wrong, or maybe this isn't the box you were intending to use.");
        }
        Object selected = path.getLastPathComponent();
        if (selected instanceof ModelWrapper) {
            return ((ModelWrapper)selected).model;
        }
        return null;
    }

    @Override
    public void setModelConfigs(List<SessionNodeModelConfig> configs) {
        ChooserTreeModel model = new ChooserTreeModel(configs);
        this.tree = new JTree(model);
        this.tree.setCellRenderer(new ChooserRenderer());
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            Object selected = path.getLastPathComponent();
            if (selected instanceof ModelWrapper) {
                String name = ((ModelWrapper)selected).name;
                Preferences.userRoot().put(this.nodeId, name);
            }
        });
        String storedModelType = this.getModelTypeFromSessionNode(this.sessionNode, model);
        if (storedModelType == null) {
            storedModelType = Preferences.userRoot().get(this.nodeId, "");
        }
        System.out.println("Stored model type = " + storedModelType);
        if (storedModelType.length() != 0) {
            block1: for (Map.Entry entry : model.map.entrySet()) {
                for (ModelWrapper wrapper : (List)entry.getValue()) {
                    if (!storedModelType.equals(wrapper.name)) continue;
                    Object[] path = new Object[]{"Root", entry.getKey(), wrapper};
                    this.tree.setSelectionPath(new TreePath(path));
                    continue block1;
                }
            }
        }
    }

    private String getModelTypeFromSessionNode(SessionNode sessionNode, ChooserTreeModel model) {
        Class clazz = sessionNode.getLastModelClass();
        Object root = model.getRoot();
        for (int i = 0; i < model.getChildCount(root); ++i) {
            Object child = model.getChild(root, i);
            for (int j = 0; j < model.getChildCount(child); ++j) {
                ModelWrapper modelWrapper = (ModelWrapper)model.getChild(child, j);
                assert (modelWrapper != null);
                if (modelWrapper.model != clazz) continue;
                return modelWrapper.name;
            }
        }
        return null;
    }

    @Override
    public void setNodeId(String id) {
        if (id == null) {
            throw new NullPointerException("The given id must not be null");
        }
        this.nodeId = id;
    }

    @Override
    public void setSessionNode(SessionNode sessionNode) {
        this.sessionNode = sessionNode;
        this.nodeName = sessionNode.getDisplayName();
    }

    @Override
    public void setup() {
        this.setLayout(new BorderLayout());
        JButton info = new JButton("Help");
        info.addActionListener(e -> {
            Class model = this.getSelectedModel();
            if (model == null) {
                JOptionPane.showMessageDialog(this, "No node selected. Select a node to get help for it.");
            } else {
                SessionUtils.showPermissibleParentsDialog(model, this, false, false);
            }
        });
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(5));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(" Name of node: " + this.nodeName));
        box.add(Box.createHorizontalGlue());
        box.add(info);
        box.add(Box.createHorizontalStrut(5));
        vBox.add(box);
        vBox.add(Box.createVerticalStrut(5));
        this.add((Component)vBox, "North");
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    private static class ChooserTreeModel
    implements TreeModel {
        private static final String ROOT = "Root";
        private final Map<String, List<ModelWrapper>> map = new HashMap<String, List<ModelWrapper>>();
        private final List<String> categories = new LinkedList<String>();

        public ChooserTreeModel(List<SessionNodeModelConfig> configs) {
            for (SessionNodeModelConfig config : configs) {
                String category = config.getCategory();
                if (category == null) {
                    throw new NullPointerException("No Category name associated with model: " + config.getModel());
                }
                if ("Unlisted".equals(category)) continue;
                if (!this.categories.contains(category)) {
                    this.categories.add(category);
                }
                List models = this.map.computeIfAbsent(category, k -> new LinkedList());
                models.add(new ModelWrapper(config.getName(), config.getModel()));
            }
        }

        @Override
        public Object getRoot() {
            return ROOT;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (ROOT.equals(parent)) {
                return this.categories.get(index);
            }
            if (parent instanceof String) {
                List<ModelWrapper> models = this.map.get(parent);
                return models.get(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (ROOT.equals(parent)) {
                return this.categories.size();
            }
            if (parent instanceof ModelWrapper) {
                return 0;
            }
            List<ModelWrapper> models = this.map.get(parent);
            return models.size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof ModelWrapper;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (ROOT.equals(parent)) {
                return this.categories.indexOf(child);
            }
            List<ModelWrapper> models = this.map.get(parent);
            return models.indexOf(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }
    }

    private static class ModelWrapper {
        private final String name;
        private final Class model;

        public ModelWrapper(String name, Class model) {
            this.name = name;
            this.model = model;
        }
    }

    private static class ChooserRenderer
    extends DefaultTreeCellRenderer {
        private ChooserRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value == null) {
                this.setText("");
            } else if (value instanceof ModelWrapper) {
                this.setText(((ModelWrapper)value).name);
            } else {
                this.setText((String)value);
            }
            if (leaf) {
                this.setIcon(null);
            } else if (expanded) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
            if (selected) {
                this.setForeground(this.getTextSelectionColor());
            } else {
                this.setForeground(this.getTextNonSelectionColor());
            }
            this.selected = selected;
            return this;
        }
    }
}

