/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.app.NewSessionAction;
import edu.cmu.tetradapp.app.SaveSessionAction;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class CloseSessionAction
extends AbstractAction {
    private boolean saved;

    public CloseSessionAction() {
        super("Close Session");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench graph = sessionEditor.getSessionWorkbench();
        SessionWrapper sessionWrapper = graph.getSessionWrapper();
        if (sessionWrapper.isSessionChanged()) {
            String name = sessionWrapper.getName();
            String msg = "Do you want to save the changes you made to " + name + "?";
            int response = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), msg, "Fair Warning", 1);
            if (response == 0) {
                SaveSessionAction saveSessionAction = new SaveSessionAction();
                saveSessionAction.actionPerformed(e);
                this.saved = saveSessionAction.isSaved();
            } else if (response == 2) {
                return;
            }
        }
        DesktopController.getInstance().closeFrontmostSession();
        if (DesktopController.getInstance().getFrontmostSessionEditor() == null) {
            new NewSessionAction().actionPerformed(null);
        }
    }

    public String toString() {
        return "Close session action.";
    }

    public boolean isSaved() {
        return this.saved;
    }
}

