/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

final class FontSelectionAction
extends AbstractAction
implements ClipboardOwner {
    private JComboBox fontFamilyBox;
    private JComboBox styleBox;
    private JComboBox sizesBox;
    private JTextArea testArea;
    private Font font;

    public FontSelectionAction() {
        super("Font...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = graphicsEnvironment.getAvailableFontFamilyNames();
        this.fontFamilyBox = new JComboBox<String>(fontFamilies);
        this.fontFamilyBox.setBackground(Color.white);
        this.fontFamilyBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontSelectionAction.this.resetFont();
            }
        });
        String[] styles = new String[]{"Plain", "Italic", "Bold"};
        this.styleBox = new JComboBox<String>(styles);
        this.styleBox.setBackground(Color.white);
        this.styleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontSelectionAction.this.resetFont();
            }
        });
        String[] sizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        this.sizesBox = new JComboBox<String>(sizes);
        this.sizesBox.setBackground(Color.white);
        this.sizesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontSelectionAction.this.resetFont();
            }
        });
        this.testArea = new JTextArea(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 50);
            }
        };
        this.testArea.setText("Sample...");
        this.testArea.setBorder(new CompoundBorder(new LineBorder(Color.DARK_GRAY), new MatteBorder(3, 3, 3, 3, Color.WHITE)));
        Box b1 = Box.createHorizontalBox();
        Box b2 = Box.createVerticalBox();
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Font family:"));
        b3.add(Box.createHorizontalGlue());
        b2.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(Box.createHorizontalStrut(5));
        b4.add(this.fontFamilyBox);
        b2.add(b4);
        Box b5 = Box.createVerticalBox();
        Box b6 = Box.createHorizontalBox();
        b6.add(new JLabel("Font style:"));
        b6.add(Box.createHorizontalGlue());
        b5.add(b6);
        Box b7 = Box.createHorizontalBox();
        b7.add(Box.createHorizontalStrut(5));
        b7.add(this.styleBox);
        b5.add(b7);
        Box b8 = Box.createVerticalBox();
        Box b9 = Box.createHorizontalBox();
        b9.add(new JLabel("Size:"));
        b9.add(Box.createHorizontalGlue());
        b8.add(b9);
        Box b10 = Box.createHorizontalBox();
        b10.add(Box.createHorizontalStrut(5));
        b10.add(this.sizesBox);
        b8.add(b10);
        b1.add(b2);
        b1.add(Box.createHorizontalStrut(5));
        b1.add(b5);
        b1.add(Box.createHorizontalStrut(5));
        b1.add(b8);
        Box b11 = Box.createVerticalBox();
        b11.add(b1);
        b11.add(Box.createVerticalStrut(5));
        Box b12 = Box.createHorizontalBox();
        b12.add(new JLabel("Preview:"));
        b12.add(Box.createHorizontalGlue());
        Box b13 = Box.createHorizontalBox();
        b13.add(Box.createHorizontalStrut(5));
        b13.add(this.testArea);
        b11.add(b12);
        b11.add(b13);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)b11, "Center");
        panel.setBorder(new TitledBorder("Select the 'Plain' font:"));
        JOptionPane.showOptionDialog(JOptionUtils.centeringComp(), panel, "Font Selector", 2, 3, null, null, null);
    }

    private void resetFont() {
        int style;
        String family = (String)this.fontFamilyBox.getSelectedItem();
        String styleString = (String)this.styleBox.getSelectedItem();
        String sizeString = (String)this.sizesBox.getSelectedItem();
        if ("Plain".equals(styleString)) {
            style = 0;
        } else if ("Italic".equals(styleString)) {
            style = 2;
        } else if ("Bold".equals(styleString)) {
            style = 1;
        } else {
            throw new IllegalArgumentException("Unrecognized styleString: " + styleString);
        }
        int size = Integer.parseInt(sizeString);
        if (size < 1) {
            throw new IllegalArgumentException("Size Must be greater than or equal to 1: " + size);
        }
        this.font = new Font(family, style, size);
        this.testArea.setFont(this.getFont());
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private Font getFont() {
        return this.font;
    }
}

