/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Version;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.app.TetFileFilter;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.TetradMetadata;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.WatchedProcess;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

final class LoadSessionAction
extends AbstractAction {
    public LoadSessionAction() {
        super("Open Session...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Window owner = (Window)JOptionUtils.centeringComp().getTopLevelAncestor();
        JFileChooser chooser = new JFileChooser();
        String sessionSaveLocation = Preferences.userRoot().get("sessionSaveLocation", "");
        for (FileFilter filter : chooser.getChoosableFileFilters()) {
            chooser.removeChoosableFileFilter(filter);
        }
        chooser.setCurrentDirectory(new File(sessionSaveLocation));
        chooser.addChoosableFileFilter(new TetFileFilter());
        chooser.setFileSelectionMode(0);
        int ret1 = chooser.showOpenDialog(JOptionUtils.centeringComp());
        if (ret1 != 0) {
            return;
        }
        final File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        Preferences.userRoot().put("sessionSaveLocation", file.getParent());
        Session session = DesktopController.getInstance().getSessionByName(file.getName());
        if (session != null) {
            if (session.isEmpty()) {
                DesktopController.getInstance().closeSessionByName(file.getName());
            } else {
                int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "Replace existing session by that name?.", "Confirm", 0);
                if (ret == 0) {
                    DesktopController.getInstance().closeSessionByName(file.getName());
                } else {
                    return;
                }
            }
        }
        new WatchedProcess(owner){

            @Override
            public void watch() {
                try {
                    FileInputStream in = new FileInputStream(file);
                    DecompressibleInputStream objIn = new DecompressibleInputStream(in);
                    Object o = objIn.readObject();
                    TetradMetadata metadata = null;
                    SessionWrapper sessionWrapper = null;
                    if (o instanceof TetradMetadata) {
                        metadata = (TetradMetadata)o;
                        try {
                            sessionWrapper = (SessionWrapper)objIn.readObject();
                        }
                        catch (ClassNotFoundException e1) {
                            throw e1;
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    } else if (o instanceof SessionWrapper) {
                        sessionWrapper = (SessionWrapper)o;
                    }
                    in.close();
                    if (metadata == null) {
                        throw new NullPointerException("Could not read metadata.");
                    }
                    if (sessionWrapper == null) {
                        Version version = metadata.getVersion();
                        Date date = metadata.getDate();
                        SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy");
                        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not load this session file into Tetrad " + Version.currentViewableVersion() + "! \nThe session was saved by Tetrad " + version + " on " + df.format(date));
                        return;
                    }
                    SessionEditorWorkbench graph = new SessionEditorWorkbench(sessionWrapper);
                    String name = file.getName();
                    sessionWrapper.setName(name);
                    SessionEditor editor = new SessionEditor(name, graph);
                    DesktopController.getInstance().addSessionEditor(editor);
                    DesktopController.getInstance().closeEmptySessions();
                    DesktopController.getInstance().putMetadata(sessionWrapper, metadata);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "That wasn't a TETRAD session file: " + file);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "An error occurred attempting to load the session.");
                }
            }
        };
    }

    public static class DecompressibleInputStream
    extends ObjectInputStream {
        public DecompressibleInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            Class<?> localClass;
            ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
            try {
                localClass = Class.forName(resultClassDescriptor.getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                TetradLogger.getInstance().forceLogMessage("No local class for " + resultClassDescriptor.getName());
                return resultClassDescriptor;
            }
            ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
            if (localClassDescriptor != null) {
                long localSUID = localClassDescriptor.getSerialVersionUID();
                long streamSUID = resultClassDescriptor.getSerialVersionUID();
                if (streamSUID != localSUID) {
                    resultClassDescriptor = localClassDescriptor;
                }
            }
            return resultClassDescriptor;
        }
    }
}

