/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetradapp.app.SessionDisplayComp;
import edu.cmu.tetradapp.workbench.DisplayNodeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class NoteDisplayComp
extends JComponent
implements SessionDisplayComp {
    private boolean selected;
    private static final Color BORDER_COLOR = new Color(148, 152, 177);
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 219);
    private final JLabel name = new JLabel("Note");

    public NoteDisplayComp() {
        this.buildComponents();
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, width, height);
        int y = this.name.getSize().height;
        y += 2;
        g.setColor(BORDER_COLOR);
        while (y < height) {
            g.drawLine(0, y, width, y);
            y += 5;
        }
        g.setColor(BORDER_COLOR);
        g.drawRect(0, 0, width - 1, height - 1);
        super.paint(g);
    }

    @Override
    public void setAcronym(String acronym) {
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void setHasModel(boolean b) {
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.name.setText(name);
    }

    private void buildComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setBackground(BACKGROUND_COLOR);
        this.setFont(DisplayNodeUtils.getFont());
        Box b = Box.createVerticalBox();
        b.add(Box.createVerticalStrut(2));
        Box b2 = Box.createHorizontalBox();
        b2.add(Box.createHorizontalStrut(5));
        b2.add(this.name);
        b2.add(Box.createHorizontalStrut(5));
        b2.add(Box.createHorizontalGlue());
        b.add(b2);
        b.add(Box.createVerticalStrut(65));
        this.add((Component)b, "Center");
        this.revalidate();
        this.repaint();
    }
}

