/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.app.SaveSessionAsAction;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.TetradMetadata;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class SaveSessionAction
extends AbstractAction {
    private static final long serialVersionUID = -1812370698394158108L;
    private boolean saved;

    public SaveSessionAction() {
        super("Save Session");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int ret;
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench workbench = sessionEditor.getSessionWorkbench();
        SessionWrapper sessionWrapper = workbench.getSessionWrapper();
        TetradMetadata metadata = new TetradMetadata();
        Path outputFile = Paths.get(Preferences.userRoot().get("sessionSaveLocation", Preferences.userRoot().absolutePath()), sessionWrapper.getName());
        if (Files.notExists(outputFile, new LinkOption[0]) || sessionWrapper.isNewSession()) {
            SaveSessionAsAction saveSessionAsAction = new SaveSessionAsAction();
            saveSessionAsAction.actionPerformed(e);
            this.saved = saveSessionAsAction.isSaved();
            return;
        }
        if (Files.exists(outputFile, new LinkOption[0]) && (ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "File already exists. Overwrite?", "Save", 0)) == 1) {
            SaveSessionAsAction saveSessionAsAction = new SaveSessionAsAction();
            saveSessionAsAction.actionPerformed(e);
            this.saved = saveSessionAsAction.isSaved();
            return;
        }
        try (ObjectOutputStream objOut = new ObjectOutputStream(Files.newOutputStream(outputFile, new OpenOption[0]));){
            sessionWrapper.setNewSession(false);
            objOut.writeObject(metadata);
            objOut.writeObject(sessionWrapper);
        }
        catch (IOException exception) {
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), String.format("An error occurred while attempting to save the session as %s.", outputFile.toAbsolutePath()));
        }
        sessionWrapper.setSessionChanged(false);
        DesktopController.getInstance().putMetadata(sessionWrapper, metadata);
    }

    public boolean isSaved() {
        return this.saved;
    }
}

