/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.model.EditorUtils;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.TetradMetadata;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class SaveSessionAsAction
extends AbstractAction {
    private static final long serialVersionUID = 2798487128341621686L;
    private boolean saved;

    public SaveSessionAsAction() {
        super("Save Session As...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench workbench = sessionEditor.getSessionWorkbench();
        SessionWrapper sessionWrapper = workbench.getSessionWrapper();
        TetradMetadata metadata = new TetradMetadata();
        String sessionSaveLocation = Preferences.userRoot().get("sessionSaveLocation", "");
        File file = EditorUtils.getSaveFileWithPath(sessionEditor.getName(), "tet", JOptionUtils.centeringComp(), true, "Save Session As...", sessionSaveLocation);
        if (file == null) {
            this.saved = false;
            return;
        }
        if (DesktopController.getInstance().existsSessionByName(file.getName()) && !sessionWrapper.getName().equals(file.getName())) {
            this.saved = false;
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Another session by that name is currently open. Please \nclose that session first.");
            return;
        }
        sessionWrapper.setName(file.getName());
        sessionEditor.setName(file.getName());
        try (ObjectOutputStream objOut = new ObjectOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            objOut.writeObject(metadata);
            objOut.writeObject(sessionWrapper);
            sessionWrapper.setSessionChanged(false);
            sessionWrapper.setNewSession(false);
            this.saved = true;
        }
        catch (IOException exception) {
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "An error occurred while attempting to save the session.");
            this.saved = false;
        }
        DesktopController.getInstance().putMetadata(sessionWrapper, metadata);
        sessionEditor.firePropertyChange("name", null, file.getName());
    }

    public boolean isSaved() {
        return this.saved;
    }
}

