/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetradapp.app.SessionEditorNode;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.PointPair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;

final class SessionEditorEdge
extends DisplayEdge {
    private static final Color DIE_BACKGROUND = Color.red;
    private static final Color DIE_DOT = Color.black;
    public static final int UNRANDOMIZED = 0;
    private static final int RANDOMIZED = 1;
    private final Color curr_color = DIE_BACKGROUND;
    private int sessionEdgeMode;

    public SessionEditorEdge(SessionEditorNode node1, SessionEditorNode node2, int sessionEdgeMode) {
        super((DisplayNode)node1, (DisplayNode)node2, 5);
        if (sessionEdgeMode < 0 || sessionEdgeMode > 1) {
            throw new IllegalArgumentException();
        }
        this.sessionEdgeMode = sessionEdgeMode;
    }

    public SessionEditorEdge(SessionEditorNode node1, Point mouseTrackPoint) {
        super((DisplayNode)node1, mouseTrackPoint, 5);
    }

    public SessionEditorEdge(SessionEditorNode node1, Point mouseTrackPoint, int mode) {
        super((DisplayNode)node1, mouseTrackPoint, 5);
        this.sessionEdgeMode = mode;
    }

    private static Polygon calcDiceSleeve(Point[] dice) {
        int[] xpoint = new int[4];
        int[] ypoint = new int[4];
        xpoint[0] = dice[0].x;
        xpoint[1] = dice[1].x;
        xpoint[2] = dice[2].x;
        xpoint[3] = dice[3].x;
        ypoint[0] = dice[0].y;
        ypoint[1] = dice[1].y;
        ypoint[2] = dice[2].y;
        ypoint[3] = dice[3].y;
        return new Polygon(xpoint, ypoint, 4);
    }

    private void drawDice(Graphics g, Color c) {
        Polygon dice = this.getDiceSleeve();
        Circle[] dicedot = this.getDiceDot();
        g.setColor(c);
        g.fillPolygon(dice);
        g.setColor(DIE_DOT);
        g.drawPolygon(dice);
        int height = dicedot[0].radius * 2;
        for (Circle aDicedot : dicedot) {
            g.fillOval(aDicedot.center.x, aDicedot.center.y, height, height);
        }
    }

    private Point[] getDiceArea() {
        int[] xpoint = new int[4];
        int[] ypoint = new int[4];
        PointPair pp = this.getConnectedPoints();
        Point midPoint = new Point((pp.getFrom().x + pp.getTo().x) / 2, (pp.getFrom().y + pp.getTo().y) / 2);
        double d = DisplayEdge.distance(pp.getFrom(), pp.getTo());
        if (d < 1.0) {
            d = 1.0;
        }
        double sin = (double)(pp.getFrom().y - pp.getTo().y) / d;
        double cos = (double)(pp.getFrom().x - pp.getTo().x) / d;
        xpoint[0] = (int)((double)midPoint.x - 10.0 * cos);
        xpoint[1] = (int)((double)midPoint.x - 10.0 * sin);
        xpoint[2] = (int)((double)midPoint.x + 10.0 * cos);
        xpoint[3] = (int)((double)midPoint.x + 10.0 * sin);
        ypoint[0] = (int)((double)midPoint.y + 10.0 * sin);
        ypoint[1] = (int)((double)midPoint.y - 10.0 * cos);
        ypoint[2] = (int)((double)midPoint.y - 10.0 * sin);
        ypoint[3] = (int)((double)midPoint.y + 10.0 * cos);
        Point[] dice = new Point[]{new Point(xpoint[0], ypoint[0]), new Point(xpoint[1], ypoint[1]), new Point(xpoint[2], ypoint[2]), new Point(xpoint[3], ypoint[3])};
        return dice;
    }

    private Circle[] getDiceDot() {
        PointPair pp = this.getConnectedPoints();
        Point midPoint = new Point((pp.getFrom().x + pp.getTo().x) / 2, (pp.getFrom().y + pp.getTo().y) / 2);
        Point[] dice = this.getDiceArea();
        Circle[] dot = new Circle[]{new Circle(new Point(midPoint.x - 1, midPoint.y - 1), 2), new Circle(new Point((dice[0].x + midPoint.x) / 2 - 1, (dice[0].y + midPoint.y) / 2 - 1), 2), new Circle(new Point((dice[1].x + midPoint.x) / 2 - 1, (dice[1].y + midPoint.y) / 2 - 1), 2), new Circle(new Point((dice[2].x + midPoint.x) / 2 - 1, (dice[2].y + midPoint.y) / 2 - 1), 2), new Circle(new Point((dice[3].x + midPoint.x) / 2 - 1, (dice[3].y + midPoint.y) / 2 - 1), 2)};
        return dot;
    }

    private Polygon getDiceSleeve() {
        return SessionEditorEdge.calcDiceSleeve(this.getDiceArea());
    }

    @Override
    public void paint(Graphics g) {
        PointPair pp;
        Graphics2D g2d = (Graphics2D)g;
        boolean thick = true;
        float width = thick ? 2.5f : 1.1f;
        BasicStroke solid = new BasicStroke(width);
        g2d.setStroke(solid);
        switch (this.getMode()) {
            case 0: {
                g2d.setColor(this.getLineColor());
                pp = this.calculateEdge(this.getNode1(), this.getRelativeMouseTrackPoint());
                if (pp == null) break;
                pp.getFrom().translate(-this.getLocation().x, -this.getLocation().y);
                pp.getTo().translate(-this.getLocation().x, -this.getLocation().y);
                this.setClickRegion(null);
                g2d.drawLine(pp.getFrom().x, pp.getFrom().y, pp.getTo().x, pp.getTo().y);
                this.drawEndpoints(pp, g2d);
                this.firePropertyChange("newPointPair", null, pp);
                break;
            }
            case 1: {
                g2d.setColor(this.getLineColor());
                pp = this.calculateEdge(this.getNode1(), this.getNode2());
                if (pp == null) break;
                pp.getFrom().translate(-this.getLocation().x, -this.getLocation().y);
                pp.getTo().translate(-this.getLocation().x, -this.getLocation().y);
                this.setClickRegion(null);
                g2d.drawLine(pp.getFrom().x, pp.getFrom().y, pp.getTo().x, pp.getTo().y);
                this.drawEndpoints(pp, g2d);
                this.firePropertyChange("newPointPair", null, pp);
                break;
            }
            case 2: {
                g2d.setColor(this.getSelectedColor());
                pp = this.calculateEdge(this.getNode1(), this.getNode2());
                if (pp == null) break;
                pp.getFrom().translate(-this.getLocation().x, -this.getLocation().y);
                pp.getTo().translate(-this.getLocation().x, -this.getLocation().y);
                this.setClickRegion(null);
                g2d.drawLine(pp.getFrom().x, pp.getFrom().y, pp.getTo().x, pp.getTo().y);
                this.drawEndpoints(pp, g2d);
                this.firePropertyChange("newPointPair", null, pp);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.setConnectedPoints(pp);
        if (this.sessionEdgeMode == 1) {
            this.drawDice(g2d, this.curr_color);
        }
    }

    private static final class Circle {
        public final int radius;
        public final Point center;

        public Circle(Point c, int r) {
            this.radius = r;
            this.center = c;
        }
    }
}

