/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.session.CouldNotCreateModelException;
import edu.cmu.tetrad.session.ModificationRegistery;
import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.SimulationStudy;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TetradLoggerConfig;
import edu.cmu.tetradapp.app.ModelChooser;
import edu.cmu.tetradapp.app.NoteDisplayComp;
import edu.cmu.tetradapp.app.SessionDisplayComp;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.app.SessionNodeConfig;
import edu.cmu.tetradapp.app.SessionNodeModelConfig;
import edu.cmu.tetradapp.app.SessionUtils;
import edu.cmu.tetradapp.app.TetradApplicationConfig;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.editor.FinalizingParameterEditor;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.SessionNodeWrapper;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.UnlistedSessionModel;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.DisplayNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public final class SessionEditorNode
extends DisplayNode {
    private static final long serialVersionUID = -6145843764762585351L;
    private EditorWindow spawnedEditor;
    private final SimulationStudy simulationStudy;
    private SessionWrapper sessionWrapper;
    private final SessionNodeConfig config;
    JPopupMenu popup;

    public SessionEditorNode(SessionNodeWrapper modelNode, SimulationStudy simulationStudy) {
        this.setModelNode(modelNode);
        TetradApplicationConfig appConfig = TetradApplicationConfig.getInstance();
        this.config = appConfig.getSessionNodeConfig(modelNode.getButtonType());
        if (this.config == null) {
            throw new NullPointerException("There is no configuration for node of type: " + modelNode.getButtonType());
        }
        if (simulationStudy == null) {
            throw new NullPointerException("Simulation edu.cmu.tetrad.study must not be null.");
        }
        SessionDisplayComp displayComp = this.config.getSessionDisplayCompInstance();
        this.simulationStudy = simulationStudy;
        displayComp.setName(modelNode.getSessionName());
        if (displayComp instanceof NoteDisplayComp) {
            this.createParamObjects(this);
            this.setDisplayComp(displayComp);
            this.setLayout(new BorderLayout());
            this.add((Component)((JComponent)((Object)this.getSessionDisplayComp())), "Center");
            this.setSelected(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                        toolTipManager.setInitialDelay(750);
                        SessionEditorNode.this.getNotePopup().show(SessionEditorNode.this, e.getX(), e.getY());
                    }
                    e.consume();
                }
            });
        } else {
            this.setDisplayComp(displayComp);
            this.setLayout(new BorderLayout());
            this.add((Component)((JComponent)((Object)this.getSessionDisplayComp())), "Center");
            this.setSelected(false);
            this.createParamObjects(this);
            this.addListeners(this, modelNode);
        }
    }

    public void adjustToModel() {
        String acronym = this.getAcronym();
        this.getSessionDisplayComp().setHasModel(!"No model".equals(acronym));
        this.getSessionDisplayComp().setAcronym(acronym);
        this.setSelected(false);
        Dimension size = this.getSize();
        Point location = this.getLocation();
        int centerX = (int)location.getX() + size.width / 2;
        int centerY = (int)location.getY() + size.height / 2;
        int newX = centerX - this.getPreferredSize().width / 2;
        int newY = centerY - this.getPreferredSize().height / 2;
        this.setLocation(newX, newY);
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    private String getAcronym() {
        SessionNodeWrapper modelNode = (SessionNodeWrapper)this.getModelNode();
        SessionNode sessionNode = modelNode.getSessionNode();
        SessionModel model = sessionNode.getModel();
        if (model == null) {
            return "No model";
        }
        Class<?> modelClass = model.getClass();
        SessionNodeModelConfig modelConfig = this.config.getModelConfig(modelClass);
        if (modelConfig == null) {
            System.out.println("Tried to load model config for " + modelClass);
            return modelClass.getSimpleName();
        }
        return modelConfig.getAcronym();
    }

    @Override
    public void doDoubleClickAction() {
        this.doDoubleClickAction(null);
    }

    @Override
    public void doDoubleClickAction(Graph sessionWrapper) {
        this.sessionWrapper = (SessionWrapper)sessionWrapper;
        Window owner = (Window)this.getTopLevelAncestor();
        new WatchedProcess(owner){

            @Override
            public void watch() {
                TetradLogger.getInstance().setTetradLoggerConfig(SessionEditorNode.this.getSessionNode().getLoggerConfig());
                SessionEditorNode.this.launchEditorVisit();
            }
        };
    }

    private void launchEditorVisit() {
        try {
            if (this.spawnedEditor() != null) {
                return;
            }
            boolean created = this.createModel(false);
            if (!created) {
                return;
            }
            final SessionNode sessionNode = this.getSessionNode();
            boolean cloned = sessionNode.useClonedModel();
            SessionModel model = sessionNode.getModel();
            Class<?> modelClass = model.getClass();
            SessionNodeModelConfig modelConfig = this.config.getModelConfig(modelClass);
            Object[] arguments = new Object[]{model};
            JPanel editor = modelConfig.getEditorInstance(arguments);
            this.addEditorListener(editor);
            ModificationRegistery.registerEditor(sessionNode, editor);
            String descrip = modelConfig.getName();
            editor.setName(this.getName() + " (" + descrip + ")");
            EditorWindow editorWindow = new EditorWindow(editor, editor.getName(), "Done", cloned, this);
            editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    if (SessionEditorNode.this.getChildren().iterator().hasNext()) {
                        SessionEditorNode.this.finishedEditingDialog();
                    }
                    ModificationRegistery.unregisterSessionNode(sessionNode);
                    SessionEditorNode.this.spawnedEditor = null;
                    EditorWindow window = (EditorWindow)e.getSource();
                    if (window.isCanceled()) {
                        sessionNode.restoreOriginalModel();
                    }
                    sessionNode.forgetSavedModel();
                }
            });
            DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
            editorWindow.pack();
            editorWindow.setVisible(true);
            this.spawnedEditor = editorWindow;
            if (this.sessionWrapper != null) {
                this.sessionWrapper.setSessionChanged(true);
            }
        }
        catch (CouldNotCreateModelException e) {
            SessionUtils.showPermissibleParentsDialog(e.getModelClass(), this, true, true);
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            SessionEditorNode centeringComp = this;
            String s = cause.getMessage();
            if (!"".equals(s)) {
                JOptionPane.showMessageDialog(centeringComp, s, null, 2);
            }
            e.printStackTrace();
        }
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.getSessionDisplayComp().setSelected(selected);
    }

    private void addListeners(final SessionEditorNode sessionEditorNode, SessionNodeWrapper modelNode) {
        sessionEditorNode.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.setInitialDelay(750);
                    sessionEditorNode.getPopup().show(sessionEditorNode, e.getX(), e.getY());
                }
                e.consume();
            }
        });
        sessionEditorNode.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                sessionEditorNode.getSimulationStudy().getSession().setSessionChanged(true);
            }
        });
        SessionNode sessionNode = modelNode.getSessionNode();
        sessionNode.addSessionListener(new SessionAdapter(){

            @Override
            public void modelCreated(SessionEvent sessionEvent) {
                sessionEditorNode.adjustToModel();
                if (sessionEditorNode.spawnedEditor() != null) {
                    EditorWindow editorWindow = sessionEditorNode.spawnedEditor();
                    editorWindow.closeDialog();
                }
            }

            @Override
            public void modelDestroyed(SessionEvent sessionEvent) {
                sessionEditorNode.adjustToModel();
                if (sessionEditorNode.spawnedEditor() != null) {
                    EditorWindow editorWindow = sessionEditorNode.spawnedEditor();
                    editorWindow.closeDialog();
                }
            }

            @Override
            public void modelUnclear(SessionEvent sessionEvent) {
                try {
                    if (SessionEditorNode.this.simulationStudy == null) {
                        boolean created = sessionEditorNode.createModel(false);
                        if (!created) {
                            return;
                        }
                        sessionEditorNode.adjustToModel();
                    }
                }
                catch (Exception e) {
                    String message = "I could not make a model for this box, sorry. Maybe the \nparents aren't right or have not been constructed yet.";
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(sessionEditorNode, message);
                }
            }
        });
    }

    private void addEditorListener(JPanel editor) {
        editor.addPropertyChangeListener(evt -> {
            if ("changeNodeLabel".equals(evt.getPropertyName())) {
                this.getDisplayComp().setName((String)evt.getNewValue());
                SessionNodeWrapper wrapper = (SessionNodeWrapper)this.getModelNode();
                wrapper.setSessionName((String)evt.getNewValue());
                this.adjustToModel();
            }
        });
    }

    private JPopupMenu getNotePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem renameBox = new JMenuItem("Rename note");
        renameBox.setToolTipText("<html>Renames this note.</html>");
        renameBox.addActionListener(e -> {
            SessionEditorNode centeringComp = this;
            String name = JOptionPane.showInputDialog(centeringComp, (Object)"New name:");
            if (!NamingProtocol.isLegalName(name)) {
                JOptionPane.showMessageDialog(centeringComp, NamingProtocol.getProtocolDescription());
                return;
            }
            SessionNodeWrapper wrapper = (SessionNodeWrapper)this.getModelNode();
            wrapper.setSessionName(name);
            this.getSessionDisplayComp().setName(name);
            this.adjustToModel();
        });
        JMenuItem cloneBox = new JMenuItem("Clone Note");
        cloneBox.setToolTipText("<html>Makes a copy of this session note and its contents. To clone<br>a whole subgraph, or to paste into a different sessions, select<br>the subgraph and use the Copy/Paste gadgets in the Edit menu.</html>");
        cloneBox.addActionListener(e -> this.firePropertyChange("cloneMe", null, this));
        JMenuItem deleteBox = new JMenuItem("Delete Note");
        deleteBox.setToolTipText("<html>Deletes this note from the workbench</html>");
        deleteBox.addActionListener(e -> {
            SessionEditorNode centeringComp;
            int ret;
            if (this.getSessionNode().getModel() == null ? (ret = JOptionPane.showConfirmDialog(centeringComp = this, "Really delete note?")) != 0 : (ret = JOptionPane.showConfirmDialog(centeringComp = this, "<html>Really delete note? Any information it contains will<br>be destroyed.</html>")) != 0) {
                return;
            }
            this.firePropertyChange("deleteNode", null, null);
        });
        JMenuItem help = new JMenuItem("Help");
        deleteBox.setToolTipText("<html>Shows help for this box.</html>");
        help.addActionListener(e -> {
            SessionNodeWrapper sessionNodeWrapper = (SessionNodeWrapper)this.getModelNode();
            SessionNode sessionNode = sessionNodeWrapper.getSessionNode();
            this.showInfoBoxForModel(sessionNode, sessionNode.getModelClasses());
        });
        popup.add(renameBox);
        popup.add(cloneBox);
        popup.add(deleteBox);
        popup.addSeparator();
        popup.add(help);
        return popup;
    }

    private JPopupMenu getPopup() {
        ParameterEditor paramEditor;
        Class modelClass;
        if (this.popup != null && this.popup.isShowing()) {
            return this.popup;
        }
        this.popup = new JPopupMenu();
        JMenuItem createModel = new JMenuItem("Create Model");
        createModel.setToolTipText("<html>Creates a new model for this node<br>of the type selected.</html>");
        createModel.addActionListener(e -> {
            try {
                if (this.getSessionNode().getModel() == null) {
                    this.createModel(false);
                } else {
                    SessionEditorNode centeringComp = this;
                    JOptionPane.showMessageDialog(centeringComp, "Please destroy the model model first.");
                }
            }
            catch (Exception e1) {
                SessionEditorNode centeringComp = this;
                JOptionPane.showMessageDialog(centeringComp, "Could not create a model for this box.");
                e1.printStackTrace();
            }
        });
        JMenuItem editModel = new JMenuItem("Edit Model");
        editModel.setToolTipText("<html>Edits the model in this node.</html>");
        editModel.addActionListener(e -> {
            try {
                if (this.getSessionNode().getModel() == null) {
                    SessionEditorNode centeringComp = this;
                    JOptionPane.showMessageDialog(centeringComp, "Sorry, no model has been created yet; there's nothing to edit.");
                } else {
                    this.doDoubleClickAction();
                }
            }
            catch (Exception e1) {
                SessionEditorNode centeringComp = this;
                JOptionPane.showMessageDialog(centeringComp, "Double click failed. See console for exception.");
                e1.printStackTrace();
            }
        });
        JMenuItem destroyModel = new JMenuItem("Destroy Model");
        destroyModel.setToolTipText("<html>Destroys the model for this node, <br>if it has one, destroying any <br>downstream models as well.</html>");
        destroyModel.addActionListener(e -> {
            int ret;
            SessionEditorNode centeringComp = this;
            if (this.getSessionNode().getModel() == null) {
                JOptionPane.showMessageDialog(centeringComp, "Sorry, this box does not contain a model to destroy.");
                return;
            }
            Set<SessionNode> children = this.getSessionNode().getChildren();
            boolean found = false;
            for (SessionNode child : children) {
                if (child.getModel() == null) continue;
                found = true;
                break;
            }
            if (found && (ret = JOptionPane.showConfirmDialog(centeringComp, "Destroying the model in this box will also destroy models in any boxes\ndownstream. Is that OK?", null, 2, 2)) != 0) {
                return;
            }
            children.forEach(sessionNode -> Arrays.stream(sessionNode.getModelClasses()).forEach(m -> sessionNode.putParam((Class)m, new Parameters())));
            SessionNode sessionNode2 = this.getSessionNode();
            Arrays.stream(sessionNode2.getModelClasses()).forEach(m -> sessionNode2.putParam((Class)m, new Parameters()));
            this.destroyModel();
        });
        JMenuItem propagateDownstream = new JMenuItem("Propagate changes downstream");
        propagateDownstream.setToolTipText("<html>Fills in this box and downstream boxes with models,<br>overwriting any models that already exist.</html>");
        propagateDownstream.addActionListener(e -> {
            int ret;
            SessionEditorNode centeringComp = this;
            if (this.getSessionNode().getModel() != null && !this.getSessionNode().getChildren().isEmpty() && (ret = JOptionPane.showConfirmDialog(centeringComp, "You will be rewriting all downstream models. Is that OK?", "Confirm", 2, 2)) != 0) {
                return;
            }
            try {
                this.createDescendantModels();
            }
            catch (RuntimeException e1) {
                JOptionPane.showMessageDialog(centeringComp, "Could not complete the creation of descendant models.");
                e1.printStackTrace();
            }
        });
        JMenuItem renameBox = new JMenuItem("Rename Box");
        renameBox.setToolTipText("<html>Renames this session box.</html>");
        renameBox.addActionListener(e -> {
            SessionEditorNode centeringComp = this;
            String name = JOptionPane.showInputDialog(centeringComp, (Object)"New name:");
            if (!NamingProtocol.isLegalName(name)) {
                JOptionPane.showMessageDialog(centeringComp, NamingProtocol.getProtocolDescription());
                return;
            }
            SessionNodeWrapper wrapper = (SessionNodeWrapper)this.getModelNode();
            wrapper.setSessionName(name);
            this.getSessionDisplayComp().setName(name);
            this.adjustToModel();
        });
        JMenuItem cloneBox = new JMenuItem("Clone Box");
        cloneBox.setToolTipText("<html>Makes a copy of this session box and its contents. To clone<br>a whole subgraph, or to paste into a different sessions, select<br>the subgraph and use the Copy/Paste gadgets in the Edit menu.</html>");
        cloneBox.addActionListener(e -> this.firePropertyChange("cloneMe", null, this));
        JMenuItem deleteBox = new JMenuItem("Delete Box");
        deleteBox.setToolTipText("<html>Deletes this box from the workbench</html>");
        deleteBox.addActionListener(e -> {
            SessionEditorNode centeringComp = this;
            int ret = JOptionPane.showConfirmDialog(centeringComp, "Are you sure you want to delete this box? It contains some work.", null, 0);
            if (ret != 0) {
                return;
            }
            this.firePropertyChange("deleteNode", null, null);
        });
        this.popup.add(createModel);
        SessionModel model = this.getSessionNode().getModel();
        Class clazz = modelClass = model == null ? this.determineTheModelClass(this.getSessionNode()) : model.getClass();
        if (this.getSessionNode().existsParameterizedConstructor(modelClass) && (paramEditor = this.getParameterEditor(modelClass)) != null) {
            JMenuItem editSimulationParameters = new JMenuItem("Edit Parameters...");
            editSimulationParameters.setToolTipText("<html>");
            editSimulationParameters.addActionListener(e -> {
                Parameters param = this.getSessionNode().getParam(modelClass);
                Object[] arguments = this.getSessionNode().getModelConstructorArguments(modelClass);
                if (param != null) {
                    try {
                        this.editParameters(modelClass, param, arguments);
                        int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "Should I overwrite the contents of this box and all delete the contents\nof all boxes downstream?", "Double check...", 0);
                        if (ret == 0) {
                            this.getSessionNode().destroyModel();
                            this.getSessionNode().createModel(modelClass, true);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
            this.popup.add(editSimulationParameters);
        }
        this.popup.add(createModel);
        this.popup.add(editModel);
        this.popup.add(destroyModel);
        this.popup.addSeparator();
        this.popup.add(renameBox);
        this.popup.add(cloneBox);
        this.popup.add(deleteBox);
        this.popup.addSeparator();
        this.addEditLoggerSettings(this.popup);
        this.popup.add(propagateDownstream);
        return this.popup;
    }

    private ParameterEditor getParameterEditor(Class modelClass) {
        SessionNodeModelConfig modelConfig = this.config.getModelConfig(modelClass);
        return modelConfig.getParameterEditorInstance();
    }

    private void addEditLoggerSettings(JPopupMenu menu) {
        SessionNodeWrapper modelNode = (SessionNodeWrapper)this.getModelNode();
        SessionNode sessionNode = modelNode.getSessionNode();
        TetradLoggerConfig config = sessionNode.getLoggerConfig();
        if (config != null) {
            JMenuItem item = new JMenuItem("Edit Logger Settings ...");
            item.addActionListener(e -> this.showLogConfig(config));
            menu.add(item);
        }
    }

    private void showLogConfig(TetradLoggerConfig config) {
        List<TetradLoggerConfig.Event> events = config.getSupportedEvents();
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, events.size() / 3));
        for (TetradLoggerConfig.Event event : events) {
            String id = event.getId();
            JCheckBox checkBox = new JCheckBox(event.getDescription());
            checkBox.setHorizontalTextPosition(4);
            checkBox.setSelected(config.isEventActive(id));
            checkBox.addActionListener(e -> {
                JCheckBox box = (JCheckBox)e.getSource();
                config.setEventActive(id, box.isSelected());
            });
            panel.add(checkBox);
        }
        panel.setBorder(new TitledBorder("Select Events to Log"));
        JOptionPane.showMessageDialog(this, panel, "Edit Events to Log", -1);
    }

    private void executeSessionNode(final SessionNode sessionNode) {
        Window owner = (Window)this.getTopLevelAncestor();
        new WatchedProcess(owner){

            @Override
            public void watch() {
                Class<SessionEditorWorkbench> c = SessionEditorWorkbench.class;
                Container container = SwingUtilities.getAncestorOfClass(c, SessionEditorNode.this);
                SessionEditorWorkbench workbench = (SessionEditorWorkbench)container;
                System.out.println("Executing " + sessionNode);
                workbench.getSimulationStudy().execute(sessionNode, true);
            }
        };
    }

    private void createDescendantModels() {
        Window owner = (Window)this.getTopLevelAncestor();
        new WatchedProcess(owner){

            @Override
            public void watch() {
                Class<SessionEditorWorkbench> clazz = SessionEditorWorkbench.class;
                Container container = SwingUtilities.getAncestorOfClass(clazz, SessionEditorNode.this);
                SessionEditorWorkbench workbench = (SessionEditorWorkbench)container;
                if (workbench != null) {
                    workbench.getSimulationStudy().createDescendantModels(SessionEditorNode.this.getSessionNode(), true);
                }
            }
        };
    }

    private void finishedEditingDialog() {
        block6: {
            int selection;
            block5: {
                if (!ModificationRegistery.modelHasChanged(this.getSessionNode())) {
                    return;
                }
                for (SessionNode child : this.getChildren()) {
                    if (child.getModel() != null) continue;
                    return;
                }
                SessionEditorNode centeringComp = this;
                Object[] options = new Object[]{"Execute", "Break Edges"};
                selection = JOptionPane.showOptionDialog(centeringComp, "Changing this node will affect its children.\nClick on \"Execute\" to percolate changes down.\nClick on \"Break Edges\" to leave the children the same.", "Warning", -1, 2, null, options, options[0]);
                if (selection != 0) break block5;
                for (SessionNode child : this.getChildren()) {
                    this.executeSessionNode(child);
                }
                break block6;
            }
            if (selection != 1) break block6;
            for (Edge edge : this.sessionWrapper.getEdges(this.getModelNode())) {
                SessionNode other;
                SessionNodeWrapper otherWrapper;
                if (edge.getNode2() == this.getModelNode()) {
                    otherWrapper = (SessionNodeWrapper)edge.getNode1();
                    other = otherWrapper.getSessionNode();
                    if (!this.getChildren().contains(other)) continue;
                    this.sessionWrapper.removeEdge(edge);
                    continue;
                }
                otherWrapper = (SessionNodeWrapper)edge.getNode2();
                other = otherWrapper.getSessionNode();
                if (!this.getChildren().contains(other)) continue;
                this.sessionWrapper.removeEdge(edge);
            }
        }
    }

    public boolean createModel(boolean simulation) throws Exception {
        if (this.getSessionNode().getModel() != null) {
            return true;
        }
        SessionNode sessionNode = this.getSessionNode();
        Class modelClass = this.determineTheModelClass(sessionNode);
        if (modelClass == null && !simulation) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), this.config.getNodeSpecificMessage());
            return false;
        }
        if (sessionNode.existsParameterizedConstructor(modelClass)) {
            boolean edited;
            Parameters params = sessionNode.getParam(modelClass);
            Object[] arguments = sessionNode.getModelConstructorArguments(modelClass);
            if (params != null && !(edited = this.editParameters(modelClass, params, arguments))) {
                return false;
            }
        }
        sessionNode.createModel(modelClass, simulation);
        return true;
    }

    public Class determineTheModelClass(SessionNode sessionNode) {
        SessionEditorNode.loadModelClassesFromConfig(sessionNode);
        Class[] modelClasses = sessionNode.getConsistentModelClasses(true);
        if (modelClasses == null || modelClasses.length == 0) {
            return null;
        }
        return modelClasses.length > 1 ? this.getModelClassFromUser(modelClasses) : modelClasses[0];
    }

    private Class getModelClassFromUser(Class[] modelClasses) {
        LinkedList<Class> reducedList = new LinkedList<Class>();
        for (Class modelClass : modelClasses) {
            if (UnlistedSessionModel.class.isAssignableFrom(modelClass)) continue;
            reducedList.add(modelClass);
        }
        if (reducedList.isEmpty()) {
            throw new RuntimeException("There is no model to choose.");
        }
        SessionNodeWrapper sessionNodeWrapper = (SessionNodeWrapper)this.getModelNode();
        SessionNode sessionNode = sessionNodeWrapper.getSessionNode();
        ModelChooser chooser = this.config.getModelChooserInstance(sessionNode);
        SessionEditorNode centeringComp = this;
        int selection = JOptionPane.showOptionDialog(centeringComp, chooser, chooser.getTitle(), 2, -1, null, new String[]{"OK", "Cancel"}, "OK");
        if (selection == 0) {
            return chooser.getSelectedModel();
        }
        return null;
    }

    private void showInfoBoxForModel(SessionNode sessionNode, Class[] modelClasses) {
        LinkedList<Class> reducedList = new LinkedList<Class>();
        for (Class modelClass : modelClasses) {
            if (UnlistedSessionModel.class.isAssignableFrom(modelClass)) continue;
            reducedList.add(modelClass);
        }
        if (reducedList.isEmpty()) {
            throw new RuntimeException("There is no model to choose.");
        }
        ModelChooser chooser = this.config.getModelChooserInstance(sessionNode);
        SessionEditorNode centeringComp = this;
        JOptionPane.showMessageDialog(centeringComp, chooser, "Choose Model for Help...", 3);
        chooser.getSelectedModel();
    }

    public Set<SessionNode> getChildren() {
        SessionNodeWrapper _sessionNodeWrapper = (SessionNodeWrapper)this.getModelNode();
        SessionNode _sessionNode = _sessionNodeWrapper.getSessionNode();
        return _sessionNode.getChildren();
    }

    private static void loadModelClassesFromConfig(SessionNode sessionNode) {
        String nodeName = sessionNode.getBoxType();
        if (nodeName != null) {
            String baseName = SessionEditorNode.extractBase(nodeName);
            Class[] newModelClasses = SessionEditorNode.modelClasses(baseName);
            if (newModelClasses != null) {
                sessionNode.setModelClasses(newModelClasses);
            } else {
                throw new RuntimeException("Model classes for this session node were not set in the configuration.");
            }
        }
    }

    private void destroyModel() {
        this.getSessionNode().destroyModel();
        this.getSessionNode().forgetOldModel();
    }

    public boolean editParameters(Class modelClass, Parameters params, Object[] parentModels) {
        if (parentModels == null) {
            throw new NullPointerException("Parent models array is null.");
        }
        if (params == null) {
            throw new NullPointerException("Parameters cannot be null.");
        }
        ParameterEditor paramEditor = this.getParameterEditor(modelClass);
        if (paramEditor == null) {
            return true;
        }
        paramEditor.setParams(params);
        paramEditor.setParentModels(parentModels);
        if (paramEditor instanceof FinalizingParameterEditor && paramEditor instanceof JDialog) {
            FinalizingParameterEditor e = (FinalizingParameterEditor)paramEditor;
            e.setup();
            return e.finalizeEdit();
        }
        paramEditor.setup();
        JComponent editor = (JComponent)((Object)paramEditor);
        SessionNodeWrapper nodeWrapper = (SessionNodeWrapper)this.getModelNode();
        String buttonType = nodeWrapper.getButtonType();
        editor.setName(buttonType + " Structure Editor");
        SessionEditorNode centeringComp = this;
        int ret = JOptionPane.showOptionDialog(centeringComp, editor, editor.getName(), 2, -1, null, null, null);
        return ret == 0 && (!(paramEditor instanceof FinalizingParameterEditor) || ((FinalizingParameterEditor)paramEditor).finalizeEdit());
    }

    public SessionNode getSessionNode() {
        SessionNodeWrapper wrapper = (SessionNodeWrapper)this.getModelNode();
        return wrapper.getSessionNode();
    }

    private EditorWindow spawnedEditor() {
        return this.spawnedEditor;
    }

    private void createParamObjects(SessionEditorNode sessionEditorNode) {
        Class[] modelClasses;
        SessionNode sessionNode = sessionEditorNode.getSessionNode();
        for (Class clazz : modelClasses = sessionNode.getModelClasses()) {
            SessionNodeModelConfig modelConfig;
            if (sessionNode.getParam(clazz) != null || (modelConfig = this.config.getModelConfig(clazz)) == null) continue;
            sessionNode.putParam(clazz, new Parameters(sessionNode.getParameters()));
        }
    }

    private static String extractBase(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        for (int i = name.length() - 1; i >= 0; --i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return name.substring(0, i + 1);
        }
        return "Node";
    }

    private static Class[] modelClasses(String boxType) {
        TetradApplicationConfig config = TetradApplicationConfig.getInstance();
        SessionNodeConfig nodeConfig = config.getSessionNodeConfig(boxType);
        if (nodeConfig == null) {
            throw new NullPointerException("THere is no configuration for " + boxType);
        }
        return nodeConfig.getModels();
    }

    private SimulationStudy getSimulationStudy() {
        return this.simulationStudy;
    }

    private SessionDisplayComp getSessionDisplayComp() {
        return (SessionDisplayComp)this.getDisplayComp();
    }
}

