/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.util.ImageUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

final class SessionEditorToolbar
extends JPanel {
    private boolean respondingToEvents = true;
    private final String selectType = "Select";
    private final String edgeSelectType = "Edge";
    private final Map<JToggleButton, String> nodeTypes = new HashMap<JToggleButton, String>();
    private boolean shiftDown;
    private final SessionEditorWorkbench workbench;

    public SessionEditorToolbar(SessionEditorWorkbench workbench) {
        if (workbench == null) {
            throw new NullPointerException("Workbench must not be null.");
        }
        this.workbench = workbench;
        Box buttonsPanel = Box.createVerticalBox();
        buttonsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        ButtonInfo[] buttonInfos = new ButtonInfo[]{new ButtonInfo("Select", "Select and Move", "move", "<html>Select and move nodes or groups of nodes <br>on the workbench.</html>"), new ButtonInfo("Edge", "Draw Edge", "flow", "<html>Add an edge from one node to another to declare<br>that the object in the first node should be used <br>to construct the object in the second node.<br>As a shortcut, hold down the Control key.</html>"), new ButtonInfo("Graph", "Graph", "graph", "<html>Add a graph node.</html>"), new ButtonInfo("Compare", "Compare", "compare", "<html>Add a node to compare graphs or SEM IM's.</html>"), new ButtonInfo("PM", "Parametric Model", "pm", "<html>Add a node for a parametric model.</html>"), new ButtonInfo("IM", "Instantiated Model", "im", "<html>Add a node for an instantiated model.</html>"), new ButtonInfo("Estimator", "Estimator", "estimator", "<html>Add a node for an estimator.</html>"), new ButtonInfo("Data", "Data", "data", "<html>Add a node for a data object.</html>"), new ButtonInfo("Simulation", "Simulation", "simulation", "<html>Add a node for a simulation object.</html>"), new ButtonInfo("Search", "Search", "search", "<html>Add a node for a search algorithm.</html>"), new ButtonInfo("Knowledge", "Knowledge", "knowledge", "<html>Add a knowledge box node.</html>"), new ButtonInfo("Updater", "Updater", "updater", "<html>Add a node for an updater.</html>"), new ButtonInfo("Regression", "Regression", "regression", "<html>Add a node for a regression.</html>"), new ButtonInfo("Note", "Note", "note", "<html>Add a note to the session.</html>")};
        JToggleButton[] buttons = new JToggleButton[buttonInfos.length];
        for (int i = 0; i < buttonInfos.length; ++i) {
            buttons[i] = this.constructButton(buttonInfos[i]);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < buttonInfos.length; ++i) {
            buttonGroup.add(buttons[i]);
        }
        ChangeListener changeListener = e -> {
            JToggleButton _button = (JToggleButton)e.getSource();
            if (_button.getModel().isSelected()) {
                this.setWorkbenchMode(_button);
            }
        };
        for (int i = 0; i < buttonInfos.length; ++i) {
            buttons[i].addChangeListener(changeListener);
        }
        JToggleButton button = this.getButtonForType(this.selectType);
        assert (button != null);
        button.getModel().setSelected(true);
        for (int i = 0; i < buttonInfos.length; ++i) {
            buttonsPanel.add(buttons[i]);
            buttonsPanel.add(Box.createVerticalStrut(5));
        }
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(buttonsPanel);
        scroll.setPreferredSize(new Dimension(130, 1000));
        this.add((Component)scroll, "Center");
        workbench.addPropertyChangeListener(e -> {
            if (!this.isRespondingToEvents()) {
                return;
            }
            String propertyName = e.getPropertyName();
            if ("nodeAdded".equals(propertyName)) {
                if (!this.isShiftDown()) {
                    this.resetSelectMove();
                }
            } else if ("edgeAdded".equals(propertyName)) {
                JToggleButton selectButton = this.getButtonForType(this.edgeSelectType);
                assert (selectButton != null);
                if (!selectButton.isSelected()) {
                    selectButton.doClick();
                    selectButton.requestFocus();
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            int keyCode = e.getKeyCode();
            int id = e.getID();
            if (keyCode == 16) {
                if (id == 401) {
                    this.setShiftDown(true);
                } else if (id == 402) {
                    this.setShiftDown(false);
                    this.resetSelectMove();
                }
            }
            return false;
        });
        this.resetSelectMove();
    }

    private void resetSelectMove() {
        JToggleButton selectButton = this.getButtonForType(this.selectType);
        assert (selectButton != null);
        if (!selectButton.isSelected()) {
            selectButton.doClick();
            selectButton.requestFocus();
        }
    }

    private boolean isRespondingToEvents() {
        return this.respondingToEvents;
    }

    public void setRespondingToEvents(boolean respondingToEvents) {
        this.respondingToEvents = respondingToEvents;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        System.out.println("process key event " + e);
        super.processKeyEvent(e);
    }

    private JToggleButton constructButton(ButtonInfo buttonInfo) {
        String imagePrefix = buttonInfo.getImagePrefix();
        if (imagePrefix == null) {
            throw new NullPointerException("Image prefix must not be null.");
        }
        JToggleButton button = new JToggleButton();
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SessionEditorToolbar.this.setShiftDown(e.isShiftDown());
            }
        });
        if ("Select".equals(buttonInfo.getNodeTypeName())) {
            button.setIcon(new ImageIcon(ImageUtils.getImage(this, "move.gif")));
        } else if ("Edge".equals(buttonInfo.getNodeTypeName())) {
            button.setIcon(new ImageIcon(ImageUtils.getImage(this, "flow.gif")));
        } else {
            button.setName(buttonInfo.getNodeTypeName());
            button.setText("<html><center>" + buttonInfo.getDisplayName() + "</center></html>");
        }
        button.setMaximumSize(new Dimension(110, 40));
        button.setToolTipText(buttonInfo.getToolTipText());
        this.nodeTypes.put(button, buttonInfo.getNodeTypeName());
        return button;
    }

    private void setWorkbenchMode(JToggleButton button) {
        String nodeType = this.nodeTypes.get(button);
        String edgeType = "Edge";
        if (this.selectType.equals(nodeType)) {
            this.workbench.setWorkbenchMode(0);
            this.workbench.setNextButtonType(null);
            this.setCursor(new Cursor(12));
            this.workbench.setCursor(new Cursor(12));
        } else if ("Edge".equals(nodeType)) {
            this.workbench.setWorkbenchMode(2);
            this.workbench.setNextButtonType(null);
            this.setCursor(new Cursor(0));
            this.workbench.setCursor(new Cursor(0));
        } else {
            this.workbench.setWorkbenchMode(1);
            this.workbench.setNextButtonType(nodeType);
            this.setCursor(new Cursor(1));
            this.workbench.setCursor(new Cursor(1));
        }
    }

    private JToggleButton getButtonForType(String nodeType) {
        for (JToggleButton o : this.nodeTypes.keySet()) {
            if (!nodeType.equals(this.nodeTypes.get(o))) continue;
            return o;
        }
        return null;
    }

    private boolean isShiftDown() {
        return this.shiftDown;
    }

    private void setShiftDown(boolean shiftDown) {
        this.shiftDown = shiftDown;
    }

    private static final class ButtonInfo {
        private final String nodeTypeName;
        private final String displayName;
        private final String imagePrefix;
        private final String toolTipText;

        public ButtonInfo(String nodeTypeName, String displayName, String imagePrefix, String toolTipText) {
            this.nodeTypeName = nodeTypeName;
            this.displayName = displayName;
            this.imagePrefix = imagePrefix;
            this.toolTipText = toolTipText;
        }

        public String getNodeTypeName() {
            return this.nodeTypeName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getImagePrefix() {
            return this.imagePrefix;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }
    }
}

