/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.app.SessionNodeConfig;
import edu.cmu.tetradapp.app.SessionNodeModelConfig;
import edu.cmu.tetradapp.app.TetradApplicationConfig;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

final class SessionUtils {
    SessionUtils() {
    }

    public static void showPermissibleParentsDialog(Class modelClass, JComponent centeringComp, boolean warning, boolean onlyModel) {
        TetradApplicationConfig config = TetradApplicationConfig.getInstance();
        SessionNodeConfig nodeConfig = config.getSessionNodeConfig(modelClass);
        if (nodeConfig == null) {
            throw new NullPointerException("No configuration for model: " + modelClass);
        }
        SessionNodeModelConfig modelConfig = nodeConfig.getModelConfig(modelClass);
        String[][] parentCombinations = SessionUtils.possibleParentCombinations(modelClass);
        StringBuilder b = new StringBuilder();
        b.append("<html>");
        b.append("The combinations of parent models you can use for ").append(modelConfig.getName()).append(" are:");
        for (int i = 0; i < parentCombinations.length; ++i) {
            String[] parentCombination = parentCombinations[i];
            b.append("\n  ").append(i + 1).append(". ");
            if (parentCombination.length == 0) {
                b.append("No inputs");
                continue;
            }
            for (int j = 0; j < parentCombination.length; ++j) {
                b.append(parentCombination[j]);
                if (j >= parentCombination.length - 1) continue;
                b.append(" + ");
            }
        }
        boolean messageType = true;
        JOptionPane.showMessageDialog(centeringComp, b.toString(), "Information on \"" + modelConfig.getName() + "\"", 1);
    }

    private static String[][] possibleParentCombinations(Class modelClass) {
        LinkedList parentCombinations = new LinkedList();
        Constructor<?>[] constructors = modelClass.getConstructors();
        boolean foundNull = false;
        block0: for (Constructor<?> constructor : constructors) {
            List<Class<?>> _list = Arrays.asList(constructor.getParameterTypes());
            LinkedList parameterTypes = new LinkedList(_list);
            Iterator j = parameterTypes.iterator();
            while (j.hasNext()) {
                Class parameterType = (Class)j.next();
                if (!SessionModel.class.isAssignableFrom(parameterType) && !Parameters.class.isAssignableFrom(parameterType)) continue block0;
                String string = SessionUtils.getModelName(parameterType);
                if (string != null) continue;
                j.remove();
            }
            if (parameterTypes.isEmpty()) {
                foundNull = true;
                continue;
            }
            LinkedList<String> combination = new LinkedList<String>();
            for (Object e : parameterTypes) {
                Class parameterType = (Class)e;
                String descrip = SessionUtils.getModelName(parameterType);
                combination.add(descrip);
            }
            parentCombinations.add(combination);
        }
        if (foundNull) {
            parentCombinations.add(0, new LinkedList());
        }
        String[][] _parentCombinations = new String[parentCombinations.size()][];
        for (int i = 0; i < parentCombinations.size(); ++i) {
            List combination = (List)parentCombinations.get(i);
            _parentCombinations[i] = new String[combination.size()];
            for (int j = 0; j < combination.size(); ++j) {
                _parentCombinations[i][j] = (String)combination.get(j);
            }
        }
        return _parentCombinations;
    }

    private static String getModelName(Class model) {
        TetradApplicationConfig tetradConfig = TetradApplicationConfig.getInstance();
        SessionNodeConfig config = tetradConfig.getSessionNodeConfig(model);
        if (config == null) {
            if (AbstractAlgorithmRunner.class.equals((Object)model)) {
                return "Algorithm";
            }
            return null;
        }
        SessionNodeModelConfig modelConfig = config.getModelConfig(model);
        return modelConfig.getName();
    }
}

