/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class SetupLoggingAction
extends AbstractAction {
    private static final long serialVersionUID = -3792483383186114713L;

    public SetupLoggingAction() {
        super("Logging");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent comp = SetupLoggingAction.buildSetupLoggingComponent();
        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), comp, "File Logging Setup", -1);
    }

    private static JComponent buildSetupLoggingComponent() {
        JComboBox<String> activateCombo = new JComboBox<String>(new String[]{"No", "Yes"});
        activateCombo.setMaximumSize(activateCombo.getPreferredSize());
        activateCombo.setSelectedItem(TetradLogger.getInstance().isLogging() ? "Yes" : "No");
        activateCombo.addActionListener(e -> {
            JComboBox combo = (JComboBox)e.getSource();
            TetradLogger.getInstance().setLogging("Yes".equals(combo.getSelectedItem()));
        });
        String saveLocation = TetradLogger.getInstance().getLoggingDirectory();
        JTextField saveField = new JTextField(saveLocation);
        saveField.addActionListener(e -> {
            JTextField field = (JTextField)e.getSource();
            try {
                TetradLogger.getInstance().setLoggingDirectory(field.getText());
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), ex.getMessage());
            }
        });
        JButton chooseButton = new JButton(" ... ");
        chooseButton.addActionListener(e -> {
            String saveLocation1 = TetradLogger.getInstance().getLoggingDirectory();
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setCurrentDirectory(new File(saveLocation1));
            int ret = chooser.showOpenDialog(JOptionUtils.centeringComp());
            if (ret == 0) {
                File selectedFile = chooser.getSelectedFile();
                Preferences.userRoot().put("loggingDirectory", selectedFile.getAbsolutePath());
                saveField.setText(selectedFile.getAbsolutePath());
            }
        });
        chooseButton.setBorder(new EtchedBorder());
        JTextField prefixField = new JTextField(TetradLogger.getInstance().getLoggingFilePrefix());
        prefixField.addCaretListener(e -> {
            JTextField field = (JTextField)e.getSource();
            String text = field.getText();
            if (!text.matches("[a-zA-Z_]*")) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Spaces, numbers, and special characters (except underlines) in filenames will be ignored. You might want to delete them.", "Friendly Detail Message", 2);
            }
            TetradLogger.getInstance().setLoggingFilePrefix(text);
        });
        Box b1 = Box.createVerticalBox();
        b1.add(SetupLoggingAction.createLogToBox());
        b1.add(Box.createVerticalStrut(5));
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Output Directory:"));
        b4.add(Box.createHorizontalGlue());
        b1.add(b4);
        Box b5 = Box.createHorizontalBox();
        b5.add(saveField);
        b5.add(chooseButton);
        b1.add(b5);
        b1.add(Box.createVerticalStrut(5));
        Box b6 = Box.createHorizontalBox();
        b6.add(new JLabel("File Prefix:"));
        b6.add(Box.createHorizontalGlue());
        b1.add(b6);
        Box b7 = Box.createHorizontalBox();
        b7.add(prefixField);
        b1.add(b7);
        b1.add(Box.createVerticalStrut(5));
        Box b8 = Box.createHorizontalBox();
        b8.add(new JLabel("<html>Output will be written to sequentially numbered files, using the<br>given file prefix, in the given directory, with one output file<br>generated per search.</html>"));
        b1.add(b8);
        return b1;
    }

    private static Box createLogToBox() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Log output to: "));
        box.add(Box.createHorizontalStrut(5));
        JCheckBox fileCheckBox = new JCheckBox(" File ");
        fileCheckBox.setSelected(TetradLogger.getInstance().isFileLoggingEnabled());
        fileCheckBox.setHorizontalTextPosition(2);
        fileCheckBox.addActionListener(e -> {
            JCheckBox box1 = (JCheckBox)e.getSource();
            TetradLogger.getInstance().setFileLoggingEnabled(box1.isSelected());
        });
        JCheckBox textareaCheckBox = new JCheckBox(" Log Display ");
        textareaCheckBox.setSelected(TetradLogger.getInstance().isDisplayLogEnabled());
        textareaCheckBox.setHorizontalTextPosition(2);
        textareaCheckBox.addActionListener(e -> {
            JCheckBox box12 = (JCheckBox)e.getSource();
            TetradLogger.getInstance().setDisplayLogEnabled(box12.isSelected());
        });
        box.add(fileCheckBox);
        box.add(textareaCheckBox);
        box.add(Box.createHorizontalGlue());
        return box;
    }
}

