/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetradapp.model.EditorUtils;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.List;

final class SubsessionSelection
implements Transferable {
    private final List sessionElements;
    private final DataFlavor[] dataFlavors = new DataFlavor[]{new DataFlavor(SubsessionSelection.class, "Subsession Selection")};
    private int numPastes;

    public SubsessionSelection(List sessionElements) {
        if (sessionElements == null) {
            throw new NullPointerException("List of session elements must not be null.");
        }
        for (Object sessionElement : sessionElements) {
            if (sessionElement instanceof GraphNode || sessionElement instanceof Edge) continue;
            throw new IllegalArgumentException("Model node list contains an object that is not a GraphNode or an Edge: " + sessionElement);
        }
        try {
            this.sessionElements = new MarshalledObject<List>(sessionElements).get();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new IllegalStateException("Could not clone.");
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        try {
            List returnList = new MarshalledObject<List>(this.sessionElements).get();
            Point point = EditorUtils.getTopLeftPoint(returnList);
            point.translate(50, 50);
            ++this.numPastes;
            return returnList;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.getTransferDataFlavors()[0]);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.dataFlavors;
    }

    public int getNumPastes() {
        return this.numPastes;
    }
}

