/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.app.TetradDesktop;
import edu.cmu.tetradapp.util.TextAreaOutputStream;
import edu.cmu.tetradapp.workbench.DisplayNodeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

class TetradLogArea
extends JPanel {
    private TextAreaOutputStream stream;

    public TetradLogArea(TetradDesktop tetradDesktop) {
        super(new BorderLayout());
        if (tetradDesktop == null) {
            throw new NullPointerException("The given desktop must not be null");
        }
        JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("Monospaced", 0, 12));
        if (TetradLogger.getInstance().isDisplayLogEnabled()) {
            this.stream = new TextAreaOutputStream(textArea);
            TetradLogger.getInstance().addOutputStream(this.stream);
        }
        JScrollPane pane = new JScrollPane(textArea);
        pane.setVerticalScrollBarPolicy(22);
        this.add((Component)this.createHeader(), "North");
        this.add((Component)pane, "Center");
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    private JComponent createHeader() {
        JPanel panel = new JPanel();
        panel.setBackground(DisplayNodeUtils.getNodeFillColor());
        panel.setLayout(new BorderLayout());
        String path = TetradLogger.getInstance().getLatestFilePath();
        JLabel label = new JLabel(path == null ? "Logging to console (select Setup... from Logging menu)" : "  Logging to " + path);
        label.setFont(label.getFont().deriveFont(1, 12.0f));
        label.setBackground(DisplayNodeUtils.getNodeFillColor());
        label.setForeground(Color.WHITE);
        label.setOpaque(false);
        label.setBorder(new EmptyBorder(1, 2, 1, 2));
        Box b = Box.createHorizontalBox();
        b.add(label);
        b.add(Box.createHorizontalGlue());
        panel.add((Component)b, "Center");
        return panel;
    }
}

