/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.Tetrad;
import edu.cmu.tetradapp.app.AboutTetradAction;
import edu.cmu.tetradapp.app.CloseSessionAction;
import edu.cmu.tetradapp.app.ConstructTemplateAction;
import edu.cmu.tetradapp.app.ContributorsAction;
import edu.cmu.tetradapp.app.CopySubsessionAction;
import edu.cmu.tetradapp.app.CutSubsessionAction;
import edu.cmu.tetradapp.app.ExitAction;
import edu.cmu.tetradapp.app.LaunchFlowchartAction;
import edu.cmu.tetradapp.app.LaunchManualAction;
import edu.cmu.tetradapp.app.LicenseAction;
import edu.cmu.tetradapp.app.LoadSessionAction;
import edu.cmu.tetradapp.app.NewSessionAction;
import edu.cmu.tetradapp.app.NumberFormatAction;
import edu.cmu.tetradapp.app.PasteSubsessionAction;
import edu.cmu.tetradapp.app.SaveSessionAction;
import edu.cmu.tetradapp.app.SaveSessionAsAction;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionVersionAction;
import edu.cmu.tetradapp.app.SetupLoggingAction;
import edu.cmu.tetradapp.app.TetradDesktop;
import edu.cmu.tetradapp.app.WarrantyAction;
import edu.cmu.tetradapp.app.WindowMenuListener;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

final class TetradMenuBar
extends JMenuBar {
    private static final long serialVersionUID = -2734606481426217430L;
    private final TetradDesktop desktop;

    public TetradMenuBar(TetradDesktop desktop) {
        this.desktop = desktop;
        this.setBorder(new EtchedBorder());
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = new JMenu("Edit");
        JMenu loggingMenu = new JMenu("Logging");
        JMenu templateMenu = new JMenu("Pipelines");
        JMenu windowMenu = new JMenu("Window");
        JMenu helpMenu = new JMenu("Help");
        this.add(fileMenu);
        this.add(editMenu);
        this.add(loggingMenu);
        this.add(templateMenu);
        this.add(windowMenu);
        this.add(helpMenu);
        this.buildFileMenu(fileMenu);
        this.buildEditMenu(editMenu);
        this.buildLoggingMenu(loggingMenu);
        this.buildTemplateMenu(templateMenu);
        this.buildWindowMenu(windowMenu);
        this.buildHelpMenu(helpMenu);
    }

    private void buildFileMenu(JMenu fileMenu) {
        JMenuItem newSession = new JMenuItem(new NewSessionAction());
        JMenuItem loadSession = new JMenuItem(new LoadSessionAction());
        JMenuItem closeSession = new JMenuItem(new CloseSessionAction());
        JMenuItem saveSession = new JMenuItem(new SaveSessionAction());
        fileMenu.add(newSession);
        fileMenu.add(loadSession);
        fileMenu.add(closeSession);
        fileMenu.addSeparator();
        fileMenu.add(saveSession);
        fileMenu.add(new SaveSessionAsAction());
        fileMenu.addSeparator();
        fileMenu.add(new SessionVersionAction());
        fileMenu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Save Session Workspace Image...");
        menuItem.addActionListener(e -> {
            SessionEditorIndirectRef editorRef = DesktopController.getInstance().getFrontmostSessionEditor();
            SessionEditor editor = (SessionEditor)editorRef;
            editor.saveSessionImage();
        });
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        JMenu settingsMenu = new JMenu("Settings");
        JMenuItem loggingSettingMenuItem = new JMenuItem(new SetupLoggingAction());
        JCheckBox showExperimentalBox = new JCheckBox(" Enable Experimental");
        boolean enableExperimental = Preferences.userRoot().getBoolean("enableExperimental", false);
        showExperimentalBox.setSelected(Tetrad.enableExperimental);
        Tetrad.enableExperimental = enableExperimental;
        showExperimentalBox.setSelected(enableExperimental);
        showExperimentalBox.addActionListener(e -> {
            JCheckBox box = (JCheckBox)e.getSource();
            Preferences.userRoot().putBoolean("enableExperimental", box.isSelected());
            Tetrad.enableExperimental = box.isSelected();
        });
        settingsMenu.add(loggingSettingMenuItem);
        settingsMenu.add(new JMenuItem(new NumberFormatAction()));
        settingsMenu.add(showExperimentalBox);
        fileMenu.add(settingsMenu);
        fileMenu.addSeparator();
        JMenuItem exit = new JMenuItem(new ExitAction());
        fileMenu.add(exit);
        exit.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        newSession.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        loadSession.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        saveSession.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        closeSession.setAccelerator(KeyStroke.getKeyStroke(87, 128));
    }

    private void buildEditMenu(JMenu editMenu) {
        JMenuItem cut = new JMenuItem(new CutSubsessionAction());
        JMenuItem copy = new JMenuItem(new CopySubsessionAction());
        JMenuItem paste = new JMenuItem(new PasteSubsessionAction());
        cut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        paste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        editMenu.add(cut);
        editMenu.add(copy);
        editMenu.add(paste);
        editMenu.addSeparator();
    }

    private void buildLoggingMenu(JMenu loggingMenu) {
        loggingMenu.addMenuListener(new LoggingMenuListener());
    }

    private void buildTemplateMenu(JMenu templateMenu) {
        String[] templateNames;
        for (String templateName : templateNames = ConstructTemplateAction.getTemplateNames()) {
            if ("--separator--".equals(templateName)) {
                templateMenu.addSeparator();
                continue;
            }
            ConstructTemplateAction action = new ConstructTemplateAction(templateName);
            templateMenu.add(action);
        }
    }

    private void buildWindowMenu(JMenu windowMenu) {
        WindowMenuListener windowMenuListener = new WindowMenuListener(windowMenu, this.desktop);
        windowMenu.addMenuListener(windowMenuListener);
    }

    private void buildHelpMenu(JMenu helpMenu) {
        helpMenu.add(new AboutTetradAction());
        helpMenu.add(new WarrantyAction());
        helpMenu.add(new LicenseAction());
        helpMenu.add(new ContributorsAction());
        helpMenu.addSeparator();
        helpMenu.add(new LaunchManualAction());
        helpMenu.add(new LaunchFlowchartAction());
    }

    private class LoggingMenuListener
    implements MenuListener {
        private LoggingMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu loggingMenu = (JMenu)e.getSource();
            loggingMenu.removeAll();
            JMenuItem displayLogging = new JMenuItem();
            displayLogging.setText(TetradMenuBar.this.desktop.isDisplayLogging() ? "Stop Logging" : "Start Logging");
            loggingMenu.add(displayLogging);
            displayLogging.addActionListener(e1 -> {
                JMenuItem item = (JMenuItem)e1.getSource();
                String text = item.getText();
                boolean logging = text.contains("Start");
                TetradMenuBar.this.desktop.setDisplayLogging(logging);
                TetradLogger.getInstance().setLogging(true);
                item.setText(logging ? "Start Logging" : "Stop Logging");
            });
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

