/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetradapp.app.TetradDesktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

final class WindowMenuListener
implements MenuListener,
ActionListener {
    private final JMenu windowMenu;
    private final Hashtable<JMenuItem, JInternalFrame> itemsToFrames;
    private final TetradDesktop desktop;

    public WindowMenuListener(JMenu windowMenu, TetradDesktop desktop) {
        if (windowMenu == null) {
            throw new NullPointerException("Window menu must not be null.");
        }
        if (desktop == null) {
            throw new NullPointerException("Desktop pane must not be null.");
        }
        this.windowMenu = windowMenu;
        this.desktop = desktop;
        this.itemsToFrames = new Hashtable();
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.windowMenu.removeAll();
        this.itemsToFrames.clear();
        JInternalFrame[] layer0Frames = this.desktop.getDesktopPane().getAllFramesInLayer(0);
        ArrayList<String> titles = new ArrayList<String>();
        HashMap<String, JInternalFrame> titlesToFrames = new HashMap<String, JInternalFrame>();
        for (JInternalFrame layer0Frame : layer0Frames) {
            String title = layer0Frame.getTitle();
            title = title == null || title.equals("") ? "[untitled]" : title;
            titles.add(title);
            titlesToFrames.put(title, layer0Frame);
        }
        Collections.sort(titles);
        for (String title1 : titles) {
            JMenuItem item = new JMenuItem(title1);
            this.windowMenu.add(item);
            item.addActionListener(this);
            this.itemsToFrames.put(item, (JInternalFrame)titlesToFrames.get(title1));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println(e.getActionCommand());
        Object item = e.getSource();
        JInternalFrame frame = this.itemsToFrames.get(item);
        frame.moveToFront();
        if (frame.getContentPane().getComponents().length > 0) {
            this.desktop.setMainTitle(frame.getContentPane().getComponent(0).getName());
        }
    }

    public String toString() {
        return "Some WindowMenuListener.";
    }
}

