/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.editor.CopySubgraphAction;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.editor.GraphFileMenu;
import edu.cmu.tetradapp.editor.IndTestTypeSetter;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.util.GraphHistory;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public abstract class AbstractSearchEditor
extends JPanel
implements GraphEditable,
IndTestTypeSetter {
    private final AlgorithmRunner algorithmRunner;
    private GraphWorkbench workbench;
    private final JButton executeButton = new JButton();
    private final String resultLabel;
    private JScrollPane workbenchScroll;
    boolean knowledgeMessageShown;
    private final GraphHistory graphHistory = new GraphHistory();

    AbstractSearchEditor(AlgorithmRunner algorithmRunner, String resultLabel) {
        if (algorithmRunner == null) {
            throw new NullPointerException();
        }
        if (resultLabel == null) {
            throw new NullPointerException();
        }
        this.algorithmRunner = algorithmRunner;
        this.resultLabel = resultLabel;
        this.setup(resultLabel);
    }

    @Override
    public final void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public void setGraph(Graph g) {
        this.workbench.setGraph(g);
        throw new UnsupportedOperationException("Cannot set the graph on a search editor.");
    }

    @Override
    public Graph getGraph() {
        if (this.workbench != null) {
            return this.workbench.getGraph();
        }
        return new EdgeListGraph();
    }

    @Override
    public List getSelectedModelComponents() {
        List<Component> selectedComponents = this.workbench.getSelectedComponents();
        ArrayList<Comparable<Node>> selectedModelComponents = new ArrayList<Comparable<Node>>();
        for (Component comp : selectedComponents) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List<Object> sessionElements, Point upperLeft) {
        throw new UnsupportedOperationException("Cannot paste into Search editor.");
    }

    protected abstract JPanel getToolbar();

    protected abstract void addSpecialMenus(JMenuBar var1);

    void execute() {
        Window owner = (Window)this.getTopLevelAncestor();
        WatchedProcess process = new WatchedProcess(owner){

            @Override
            public void watch() {
                Knowledge knowledge;
                Parameters searchParams;
                try {
                    AbstractSearchEditor.this.getExecuteButton().setEnabled(false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.setErrorMessage(null);
                if (!AbstractSearchEditor.this.knowledgeMessageShown && (searchParams = AbstractSearchEditor.this.getAlgorithmRunner().getParams()) != null && !(knowledge = (Knowledge)searchParams.get("knowledge", new Knowledge())).isEmpty()) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Using previously set knowledge. (To edit, use the Knowledge menu.)");
                    AbstractSearchEditor.this.knowledgeMessageShown = true;
                }
                try {
                    AbstractSearchEditor.this.storeLatestWorkbenchGraph();
                    AbstractSearchEditor.this.getAlgorithmRunner().execute();
                }
                catch (Exception e) {
                    CharArrayWriter writer1 = new CharArrayWriter();
                    PrintWriter writer2 = new PrintWriter(writer1);
                    e.printStackTrace(writer2);
                    String message = writer1.toString();
                    writer2.close();
                    e.printStackTrace(System.out);
                    TetradLogger.getInstance().error(message);
                    String messageString = e.getMessage();
                    if (e.getCause() != null) {
                        messageString = e.getCause().getMessage();
                    }
                    if (messageString == null) {
                        messageString = message;
                    }
                    this.setErrorMessage(messageString);
                    TetradLogger.getInstance().error("************Algorithm stopped!");
                    AbstractSearchEditor.this.getExecuteButton().setEnabled(true);
                    throw new RuntimeException(e);
                }
                Graph resultGraph = AbstractSearchEditor.this.resultGraph();
                AbstractSearchEditor.this.doDefaultArrangement(resultGraph);
                AbstractSearchEditor.this.getWorkbench().setBackground(Color.WHITE);
                AbstractSearchEditor.this.getWorkbench().setGraph(resultGraph);
                AbstractSearchEditor.this.getGraphHistory().clear();
                AbstractSearchEditor.this.getGraphHistory().add(resultGraph);
                AbstractSearchEditor.this.getWorkbench().repaint();
                AbstractSearchEditor.this.firePropertyChange("algorithmFinished", null, null);
                AbstractSearchEditor.this.getExecuteButton().setEnabled(true);
                AbstractSearchEditor.this.firePropertyChange("modelChanged", null, null);
            }
        };
        Thread watcher = new Thread(() -> {
            try {
                do {
                    Thread.sleep(300L);
                } while (process.isAlive());
                this.getExecuteButton().setEnabled(true);
                return;
            }
            catch (InterruptedException e) {
                this.getExecuteButton().setEnabled(true);
                return;
            }
        });
        watcher.start();
    }

    void doPostExecutionSteps() {
    }

    protected abstract void doDefaultArrangement(Graph var1);

    JButton getExecuteButton() {
        return this.executeButton;
    }

    AlgorithmRunner getAlgorithmRunner() {
        return this.algorithmRunner;
    }

    private Graph resultGraph() {
        Graph resultGraph = this.algorithmRunner.getGraph();
        if (resultGraph == null) {
            resultGraph = new EdgeListGraph();
        }
        return resultGraph;
    }

    void setWorkbench(GraphWorkbench graphWorkbench) {
        this.workbench = graphWorkbench;
    }

    void setWorkbenchScroll(JScrollPane workbenchScroll) {
        this.workbenchScroll = workbenchScroll;
    }

    void setup(String resultLabel) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getToolbar(), "West");
        this.add((Component)this.workbenchScroll(), "Center");
        this.add((Component)this.menuBar(), "North");
    }

    JScrollPane workbenchScroll() {
        Graph resultGraph = this.resultGraph();
        Graph sourceGraph = this.algorithmRunner.getSourceGraph();
        Parameters searchParams = this.algorithmRunner.getParams();
        Graph latestWorkbenchGraph = null;
        if (searchParams != null) {
            latestWorkbenchGraph = (Graph)searchParams.get("sourceGraph", null);
        }
        if (latestWorkbenchGraph == null) {
            LayoutUtil.arrangeBySourceGraph(resultGraph, sourceGraph);
        } else {
            LayoutUtil.arrangeBySourceGraph(resultGraph, latestWorkbenchGraph);
        }
        this.workbench = new GraphWorkbench(resultGraph);
        this.graphHistory.clear();
        this.graphHistory.add(resultGraph);
        this.workbench.setAllowDoubleClickActions(false);
        this.workbench.setAllowNodeEdgeSelection(true);
        this.workbenchScroll = new JScrollPane(this.workbench);
        this.workbench.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                AbstractSearchEditor.this.storeLatestWorkbenchGraph();
            }
        });
        return this.workbenchScroll;
    }

    JMenuBar menuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        GraphFileMenu fileMenu = new GraphFileMenu(this, this.getWorkbench(), false);
        file.add(fileMenu);
        file.add(new SaveComponentImage(this.workbench, "Save Graph Image..."));
        JMenu edit = new JMenu("Edit");
        JMenuItem copy = new JMenuItem(new CopySubgraphAction(this));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        edit.add(copy);
        menuBar.add(edit);
        this.addSpecialMenus(menuBar);
        return menuBar;
    }

    String getResultLabel() {
        return this.resultLabel;
    }

    JScrollPane getWorkbenchScroll() {
        return this.workbenchScroll;
    }

    Graph getLatestWorkbenchGraph() {
        if (this.algorithmRunner.getParams() == null) {
            return null;
        }
        Graph graph = (Graph)this.algorithmRunner.getParams().get("sourceGraph", null);
        if (graph == null) {
            return this.algorithmRunner.getSourceGraph();
        }
        return graph;
    }

    void storeLatestWorkbenchGraph() {
        Graph latestWorkbenchGraph = this.workbench.getGraph();
        if (latestWorkbenchGraph.getNumNodes() == 0) {
            return;
        }
        Parameters searchParams = this.algorithmRunner.getParams();
        try {
            Graph graph = new MarshalledObject<Graph>(latestWorkbenchGraph).get();
            if (graph == null) {
                throw new NullPointerException("Null graph");
            }
            if (searchParams != null) {
                searchParams.set("sourceGraph", (Object)graph);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            if (searchParams != null) {
                searchParams.set("sourceGraph", (Object)null);
            }
        }
        catch (ClassNotFoundException e) {
            if (searchParams != null) {
                searchParams.set("sourceGraph", (Object)null);
            }
            e.printStackTrace();
        }
    }

    GraphHistory getGraphHistory() {
        return this.graphHistory;
    }

    @Override
    public void setTestType(IndTestType testType) {
        this.getAlgorithmRunner().getParams().set("indTestType", (Object)testType);
    }

    @Override
    public IndTestType getTestType() {
        return (IndTestType)this.getAlgorithmRunner().getParams().get("indTestType", IndTestType.FISHER_Z);
    }

    @Override
    public DataModel getDataModel() {
        return this.getAlgorithmRunner().getDataModel();
    }

    @Override
    public Object getSourceGraph() {
        return this.getAlgorithmRunner().getParams().get("sourceGraph", null);
    }
}

