/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.pag.PagSamplingRfci;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.pag.RfciBsc;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.annotation.TestOfIndependence;
import edu.cmu.tetrad.util.ParamDescription;
import edu.cmu.tetrad.util.ParamDescriptions;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.Params;
import edu.cmu.tetradapp.model.GeneralAlgorithmRunner;
import edu.cmu.tetradapp.ui.PaddingPanel;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.LongTextField;
import edu.cmu.tetradapp.util.StringTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AlgorithmParameterPanel
extends JPanel {
    private static final long serialVersionUID = 274638263704283474L;
    protected final JPanel mainPanel = new JPanel();

    public AlgorithmParameterPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "North");
    }

    public void addToPanel(GeneralAlgorithmRunner algorithmRunner) {
        this.mainPanel.removeAll();
        Algorithm algorithm = algorithmRunner.getAlgorithm();
        Parameters parameters = algorithmRunner.getParameters();
        if (algorithm instanceof RfciBsc) {
            String title = algorithm.getClass().getAnnotation(edu.cmu.tetrad.annotation.Algorithm.class).name();
            LinkedHashSet<String> params = new LinkedHashSet<String>();
            params.add("depth");
            params.add("maxPathLength");
            params.add("completeRuleSetUsed");
            params.add("verbose");
            this.mainPanel.add(this.createSubPanel(title, params, parameters));
            this.mainPanel.add(Box.createVerticalStrut(10));
            title = "Stage One: PAG and constraints candidates Searching";
            params = new LinkedHashSet();
            params.add("numRandomizedSearchModels");
            this.mainPanel.add(this.createSubPanel(title, params, parameters));
            this.mainPanel.add(Box.createVerticalStrut(10));
            title = "Stage Two: Bayesian Scoring of Constraints";
            params = new LinkedHashSet();
            params.add("numBscBootstrapSamples");
            params.add("thresholdNoRandomConstrainSearch");
            params.add("lowerBound");
            params.add("upperBound");
            params.add("outputRBD");
            this.mainPanel.add(this.createSubPanel(title, params, parameters));
            this.mainPanel.add(Box.createVerticalStrut(10));
        } else if (algorithm instanceof PagSamplingRfci) {
            String title = algorithm.getClass().getAnnotation(edu.cmu.tetrad.annotation.Algorithm.class).name();
            LinkedHashSet<String> params = new LinkedHashSet<String>();
            params.add("numRandomizedSearchModels");
            params.add("resamplingEnsemble");
            params.add("verbose");
            this.mainPanel.add(this.createSubPanel(title, params, parameters));
            this.mainPanel.add(Box.createVerticalStrut(10));
            title = "RFCI Parameters";
            params.clear();
            params.addAll(PagSamplingRfci.RFCI_PARAMETERS);
            this.mainPanel.add(this.createSubPanel(title, params, parameters));
            this.mainPanel.add(Box.createVerticalStrut(10));
            title = "Probabilistic Test Parameters";
            params.clear();
            params.addAll(PagSamplingRfci.PROBABILISTIC_TEST_PARAMETERS);
            this.mainPanel.add(this.createSubPanel(title, params, parameters));
            this.mainPanel.add(Box.createVerticalStrut(10));
        } else {
            String title;
            Set<String> params = Params.getAlgorithmParameters(algorithm);
            if (!params.isEmpty()) {
                title = algorithm.getClass().getAnnotation(edu.cmu.tetrad.annotation.Algorithm.class).name();
                this.mainPanel.add(this.createSubPanel(title, params, parameters));
                this.mainPanel.add(Box.createVerticalStrut(10));
            }
            if (!(params = Params.getScoreParameters(algorithm)).isEmpty()) {
                title = ((UsesScoreWrapper)((Object)algorithm)).getScoreWrapper().getClass().getAnnotation(Score.class).name();
                this.mainPanel.add(this.createSubPanel(title, params, parameters));
                this.mainPanel.add(Box.createVerticalStrut(10));
            }
            if (!(params = Params.getTestParameters(algorithm)).isEmpty()) {
                title = ((TakesIndependenceWrapper)((Object)algorithm)).getIndependenceWrapper().getClass().getAnnotation(TestOfIndependence.class).name();
                this.mainPanel.add(this.createSubPanel(title, params, parameters));
                this.mainPanel.add(Box.createVerticalStrut(10));
            }
            if (algorithmRunner.getSourceGraph() == null && !(params = Params.getBootstrappingParameters(algorithm)).isEmpty()) {
                this.mainPanel.add(this.createSubPanel("Bootstrapping", params, parameters));
                this.mainPanel.add(Box.createVerticalStrut(10));
            }
        }
    }

    protected Box[] toArray(Map<String, Box> parameterComponents) {
        ParamDescriptions paramDescs = ParamDescriptions.getInstance();
        LinkedList boolComps = new LinkedList();
        LinkedList otherComps = new LinkedList();
        parameterComponents.forEach((k, v) -> {
            if (paramDescs.get((String)k).getDefaultValue() instanceof Boolean) {
                boolComps.add(v);
            } else {
                otherComps.add(v);
            }
        });
        return (Box[])Stream.concat(otherComps.stream(), boolComps.stream()).toArray(Box[]::new);
    }

    protected Map<String, Box> createParameterComponents(Set<String> params, Parameters parameters) {
        ParamDescriptions paramDescs = ParamDescriptions.getInstance();
        return params.stream().collect(Collectors.toMap(Function.identity(), e -> this.createParameterComponent((String)e, parameters, paramDescs.get((String)e)), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s.", u));
        }, TreeMap::new));
    }

    protected Box createParameterComponent(String parameter, Parameters parameters, ParamDescription paramDesc) {
        JComponent component;
        Serializable defaultValue = paramDesc.getDefaultValue();
        if (defaultValue instanceof Double) {
            double lowerBoundDouble = paramDesc.getLowerBoundDouble();
            double upperBoundDouble = paramDesc.getUpperBoundDouble();
            component = this.getDoubleField(parameter, parameters, (Double)defaultValue, lowerBoundDouble, upperBoundDouble);
        } else if (defaultValue instanceof Integer) {
            int lowerBoundInt = paramDesc.getLowerBoundInt();
            int upperBoundInt = paramDesc.getUpperBoundInt();
            component = this.getIntTextField(parameter, parameters, (Integer)defaultValue, lowerBoundInt, upperBoundInt);
        } else if (defaultValue instanceof Long) {
            long lowerBoundLong = paramDesc.getLowerBoundLong();
            long upperBoundLong = paramDesc.getUpperBoundLong();
            component = this.getLongTextField(parameter, parameters, (Long)defaultValue, lowerBoundLong, upperBoundLong);
        } else if (defaultValue instanceof Boolean) {
            component = this.getBooleanSelectionBox(parameter, parameters, (Boolean)defaultValue);
        } else if (defaultValue instanceof String) {
            component = this.getStringField(parameter, parameters, (String)((Object)defaultValue));
        } else {
            throw new IllegalArgumentException("Unexpected type: " + defaultValue.getClass());
        }
        Box paramRow = Box.createHorizontalBox();
        JLabel paramLabel = new JLabel(paramDesc.getShortDescription());
        String longDescription = paramDesc.getLongDescription();
        if (longDescription != null) {
            paramLabel.setToolTipText(longDescription);
        }
        paramRow.add(paramLabel);
        paramRow.add(Box.createHorizontalGlue());
        paramRow.add(component);
        return paramRow;
    }

    protected JPanel createSubPanel(String title, Set<String> params, Parameters parameters) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(title));
        Box paramsBox = Box.createVerticalBox();
        Box[] boxes = this.toArray(this.createParameterComponents(params, parameters));
        int lastIndex = boxes.length - 1;
        for (int i = 0; i < lastIndex; ++i) {
            paramsBox.add(boxes[i]);
            paramsBox.add(Box.createVerticalStrut(10));
        }
        paramsBox.add(boxes[lastIndex]);
        panel.add((Component)new PaddingPanel(paramsBox), "Center");
        return panel;
    }

    protected DoubleTextField getDoubleField(String parameter, Parameters parameters, double defaultValue, double lowerBound, double upperBound) {
        DoubleTextField field = new DoubleTextField(parameters.getDouble(parameter, defaultValue), 8, new DecimalFormat("0.####"), new DecimalFormat("0.0#E0"), 0.001);
        field.setFilter((value, oldValue) -> {
            if (value == field.getValue()) {
                return oldValue;
            }
            if (value < lowerBound) {
                return oldValue;
            }
            if (value > upperBound) {
                return oldValue;
            }
            try {
                parameters.set(parameter, (Object)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        return field;
    }

    protected IntTextField getIntTextField(String parameter, Parameters parameters, int defaultValue, double lowerBound, double upperBound) {
        IntTextField field = new IntTextField(parameters.getInt(parameter, defaultValue), 8);
        field.setFilter((value, oldValue) -> {
            if (value == field.getValue()) {
                return oldValue;
            }
            if ((double)value < lowerBound) {
                return oldValue;
            }
            if ((double)value > upperBound) {
                return oldValue;
            }
            try {
                parameters.set(parameter, (Object)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        return field;
    }

    protected LongTextField getLongTextField(String parameter, Parameters parameters, long defaultValue, long lowerBound, long upperBound) {
        LongTextField field = new LongTextField(parameters.getLong(parameter, defaultValue), 8);
        field.setFilter((value, oldValue) -> {
            if (value == field.getValue()) {
                return oldValue;
            }
            if (value < lowerBound) {
                return oldValue;
            }
            if (value > upperBound) {
                return oldValue;
            }
            try {
                parameters.set(parameter, (Object)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        return field;
    }

    protected Box getBooleanSelectionBox(String parameter, Parameters parameters, boolean defaultValue) {
        Box selectionBox = Box.createHorizontalBox();
        JRadioButton yesButton = new JRadioButton("Yes");
        JRadioButton noButton = new JRadioButton("No");
        ButtonGroup selectionBtnGrp = new ButtonGroup();
        selectionBtnGrp.add(yesButton);
        selectionBtnGrp.add(noButton);
        boolean aBoolean = parameters.getBoolean(parameter, defaultValue);
        if (aBoolean) {
            yesButton.setSelected(true);
        } else {
            noButton.setSelected(true);
        }
        selectionBox.add(yesButton);
        selectionBox.add(noButton);
        yesButton.addActionListener(e -> {
            JRadioButton button = (JRadioButton)e.getSource();
            if (button.isSelected()) {
                parameters.set(parameter, (Object)true);
            }
        });
        noButton.addActionListener(e -> {
            JRadioButton button = (JRadioButton)e.getSource();
            if (button.isSelected()) {
                parameters.set(parameter, (Object)false);
            }
        });
        return selectionBox;
    }

    protected StringTextField getStringField(String parameter, Parameters parameters, String defaultValue) {
        StringTextField field = new StringTextField(parameters.getString(parameter, defaultValue), 20);
        field.setFilter((value, oldValue) -> {
            if (value.equals(field.getValue().trim())) {
                return oldValue;
            }
            try {
                parameters.set(parameter, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        return field;
    }
}

