/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.BayesProperties;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.BayesEstimatorEditorWizard;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class BayesEstimatorEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JPanel targetPanel;
    private BayesEstimatorEditorWizard wizard;
    private final BayesEstimatorWrapper wrapper;

    public BayesEstimatorEditor(BayesIm bayesIm, DataSet dataSet) {
        this(new BayesEstimatorWrapper(new DataWrapper(dataSet), new BayesImWrapper(bayesIm)));
    }

    public BayesEstimatorEditor(BayesEstimatorWrapper bayesEstWrapper) {
        this.wrapper = bayesEstWrapper;
        this.setLayout(new BorderLayout());
        this.targetPanel = new JPanel();
        this.targetPanel.setLayout(new BorderLayout());
        this.resetBayesImEditor();
        this.add((Component)this.targetPanel, "Center");
        this.validate();
        if (this.wrapper.getNumModels() > 1) {
            JComboBox<Integer> comp = new JComboBox<Integer>();
            for (int i = 0; i < this.wrapper.getNumModels(); ++i) {
                comp.addItem(i + 1);
            }
            comp.addActionListener(e -> {
                Object selectedItem = comp.getSelectedItem();
                if (selectedItem instanceof Integer) {
                    this.wrapper.setModelIndex((Integer)selectedItem - 1);
                    this.resetBayesImEditor();
                    this.validate();
                }
            });
            comp.setMaximumSize(comp.getPreferredSize());
            Box b = Box.createHorizontalBox();
            b.add(new JLabel("Using model"));
            b.add(comp);
            b.add(new JLabel("from "));
            b.add(new JLabel(this.wrapper.getName()));
            b.add(Box.createHorizontalGlue());
            this.add((Component)b, "North");
        }
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private BayesEstimatorEditorWizard getWizard() {
        return this.wizard;
    }

    private void resetBayesImEditor() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        BayesIm bayesIm = this.wrapper.getEstimatedBayesIm();
        BayesPm bayesPm = bayesIm.getBayesPm();
        Graph graph = bayesPm.getDag();
        GraphWorkbench workbench = new GraphWorkbench(graph);
        this.wizard = new BayesEstimatorEditorWizard(bayesIm, workbench);
        this.wizard.enableEditing(false);
        this.wizard.addPropertyChangeListener(evt -> {
            if ("editorValueChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        workbenchScroll.setPreferredSize(new Dimension(400, 400));
        JScrollPane wizardScroll = new JScrollPane(this.getWizard());
        BayesProperties properties = new BayesProperties(this.wrapper.getDataSet());
        StringBuilder buf = new StringBuilder();
        buf.append("\nDf = ").append(properties.getDof());
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        buf.append("\nChi square = ").append(nf.format(properties.getChisq()));
        buf.append("\nBIC score = ").append(nf.format(properties.getBic()));
        buf.append("\n\nH0: Complete graph.");
        JTextArea modelParametersText = new JTextArea();
        modelParametersText.setText(buf.toString());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Model", wizardScroll);
        tabbedPane.add("Model Statistics", modelParametersText);
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, tabbedPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        this.setLayout(new BorderLayout());
        panel.add((Component)splitPane, "Center");
        this.setName("Bayes IM Editor");
        this.getWizard().addPropertyChangeListener(evt -> {
            if ("editorClosing".equals(evt.getPropertyName())) {
                this.firePropertyChange("editorClosing", null, this.getName());
            }
            if ("closeFrame".equals(evt.getPropertyName())) {
                this.firePropertyChange("closeFrame", null, null);
                this.firePropertyChange("editorClosing", true, true);
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(workbench, "Save Graph Image..."));
        panel.add((Component)menuBar, "North");
        this.targetPanel.add((Component)panel, "Center");
        this.validate();
    }
}

