/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.BayesImNodeEditingTable;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellEditor;

final class BayesEstimatorEditorWizard
extends JPanel {
    private static final long serialVersionUID = 5206106976460658161L;
    private final BayesIm bayesIm;
    private final JComboBox<Node> varNamesComboBox;
    private final GraphWorkbench workbench;
    private BayesImNodeEditingTable editingTable;
    private final JPanel tablePanel;
    private boolean enableEditing = true;

    public BayesEstimatorEditorWizard(BayesIm bayesIm, GraphWorkbench workbench) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        workbench.setAllowDoubleClickActions(false);
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        this.setFont(new Font("SanSerif", 1, 12));
        this.varNamesComboBox = this.createVarNamesComboBox(bayesIm);
        workbench.scrollWorkbenchToNode((Node)this.varNamesComboBox.getSelectedItem());
        JButton nextButton = new JButton("Next");
        nextButton.setMnemonic('N');
        Node node = (Node)this.varNamesComboBox.getSelectedItem();
        this.editingTable = new BayesImNodeEditingTable(node, bayesIm);
        this.editingTable.addPropertyChangeListener(evt -> {
            if ("modelChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        JScrollPane scroll = new JScrollPane(this.editingTable);
        scroll.setPreferredSize(new Dimension(0, 150));
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)scroll, "Center");
        this.editingTable.grabFocus();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Choose the next variable to view:  "));
        b1.add(this.varNamesComboBox);
        b1.add(nextButton);
        b1.add(Box.createHorizontalGlue());
        Box b4 = Box.createHorizontalBox();
        b4.add((Component)this.tablePanel, "Center");
        this.add(b1);
        this.add(Box.createVerticalStrut(10));
        this.add(b4);
        this.varNamesComboBox.addActionListener(e -> {
            this.getWorkbench().scrollWorkbenchToNode((Node)this.varNamesComboBox.getSelectedItem());
            this.setCurrentNode((Node)this.varNamesComboBox.getSelectedItem());
        });
        nextButton.addActionListener(e -> {
            int current = this.varNamesComboBox.getSelectedIndex();
            int max = this.varNamesComboBox.getItemCount();
            if (++current == max) {
                JOptionPane.showMessageDialog(this, "There are no more variables.");
            }
            int set = current < max ? current : 0;
            this.varNamesComboBox.setSelectedIndex(set);
        });
        workbench.addPropertyChangeListener(evt -> {
            List selection;
            Object newValue;
            if (evt.getPropertyName().equals("selectedNodes") && (newValue = evt.getNewValue()) instanceof List && (selection = (List)newValue).size() == 1) {
                this.varNamesComboBox.setSelectedItem(selection.get(0));
            }
        });
        this.bayesIm = bayesIm;
        this.workbench = workbench;
    }

    private JComboBox<Node> createVarNamesComboBox(BayesIm bayesIm) {
        JComboBox<Node> varNameComboBox = new JComboBox<Node>();
        varNameComboBox.setBackground(Color.white);
        Graph graph = bayesIm.getBayesPm().getDag();
        ArrayList<Node> nodes = new ArrayList<Node>(graph.getNodes());
        Collections.sort(nodes);
        nodes.forEach(varNameComboBox::addItem);
        if (varNameComboBox.getItemCount() > 0) {
            varNameComboBox.setSelectedIndex(0);
        }
        return varNameComboBox;
    }

    private void setCurrentNode(Node node) {
        TableCellEditor cellEditor = this.editingTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
        this.editingTable = new BayesImNodeEditingTable(node, this.getBayesIm());
        this.editingTable.addPropertyChangeListener(evt -> {
            if ("modelChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        JScrollPane scroll = new JScrollPane(this.editingTable);
        scroll.setPreferredSize(new Dimension(0, 150));
        this.tablePanel.removeAll();
        this.tablePanel.add((Component)scroll, "Center");
        this.tablePanel.revalidate();
        this.tablePanel.repaint();
        this.editingTable.grabFocus();
    }

    private BayesIm getBayesIm() {
        return this.bayesIm;
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    public boolean isEnableEditing() {
        return this.enableEditing;
    }

    public void enableEditing(boolean enableEditing) {
        this.enableEditing = enableEditing;
        if (this.workbench != null) {
            this.workbench.enableEditing(enableEditing);
        }
    }
}

