/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetradapp.editor.BayesImEditorWizard;
import edu.cmu.tetradapp.editor.LoadBayesImXmlAction;
import edu.cmu.tetradapp.editor.LoadBayesImXsdlXmlAction;
import edu.cmu.tetradapp.editor.SaveBayesImXmlAction;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.SaveScreenshot;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class BayesImEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JPanel targetPanel;
    private BayesImEditorWizard wizard;
    private final BayesImWrapper wrapper;

    public BayesImEditor(BayesImWrapper wrapper) {
        this.wrapper = wrapper;
        this.setLayout(new BorderLayout());
        this.targetPanel = new JPanel();
        this.targetPanel.setLayout(new BorderLayout());
        this.setEditorPanel();
        this.add((Component)this.targetPanel, "Center");
        this.validate();
        if (wrapper.getNumModels() > 1) {
            JComboBox<Integer> comp = new JComboBox<Integer>();
            for (int i = 0; i < wrapper.getNumModels(); ++i) {
                comp.addItem(i + 1);
            }
            comp.setSelectedIndex(wrapper.getModelIndex());
            comp.addActionListener(e -> {
                wrapper.setModelIndex(comp.getSelectedIndex() - 1);
                this.setEditorPanel();
                this.validate();
            });
            comp.setMaximumSize(comp.getPreferredSize());
            Box b = Box.createHorizontalBox();
            b.add(new JLabel("Using model"));
            b.add(comp);
            b.add(new JLabel("from "));
            b.add(new JLabel(wrapper.getModelSourceName()));
            b.add(Box.createHorizontalGlue());
            this.add((Component)b, "North");
        }
    }

    private void setEditorPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        BayesIm bayesIm = this.wrapper.getBayesIm();
        Graph graph = bayesIm.getDag();
        GraphWorkbench workbench = new GraphWorkbench(graph);
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveBayesImXmlAction(this));
        file.add(new LoadBayesImXmlAction(this.wrapper, this));
        file.add(new LoadBayesImXsdlXmlAction(this.wrapper, this));
        file.add(new SaveScreenshot(this, true, "Save Screenshot..."));
        file.add(new SaveComponentImage(workbench, "Save Graph Image..."));
        this.setLayout(new BorderLayout());
        panel.add((Component)menuBar, "North");
        this.wizard = new BayesImEditorWizard(bayesIm, workbench);
        this.wizard.enableEditing(false);
        this.wizard.addPropertyChangeListener(evt -> {
            if ("editorValueChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        JScrollPane wizardScroll = new JScrollPane(this.getWizard());
        workbenchScroll.setPreferredSize(new Dimension(450, 450));
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, wizardScroll);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        panel.add((Component)splitPane, "Center");
        this.setName("Bayes IM Editor");
        this.getWizard().addPropertyChangeListener(evt -> {
            if ("editorClosing".equals(evt.getPropertyName())) {
                this.firePropertyChange("editorClosing", null, this.getName());
            }
            if ("closeFrame".equals(evt.getPropertyName())) {
                this.firePropertyChange("closeFrame", null, null);
                this.firePropertyChange("editorClosing", true, true);
            }
            if ("modelChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", evt.getOldValue(), evt.getNewValue());
            }
        });
        this.targetPanel.add((Component)panel, "Center");
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    public BayesImEditorWizard getWizard() {
        return this.wizard;
    }

    public void getBayesIm() {
        this.removeAll();
        this.setEditorPanel();
        this.revalidate();
        this.repaint();
        this.firePropertyChange("modelChanged", null, null);
    }
}

