/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetradapp.editor.BayesImEditorWizardObs;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.SaveScreenshot;
import edu.cmu.tetradapp.model.BayesImWrapperObs;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class BayesImEditorObs
extends JPanel {
    private static final long serialVersionUID = 3600349007912545105L;
    private BayesImEditorWizardObs wizard;
    private final BayesImWrapperObs wrapper;

    public BayesImEditorObs(BayesImWrapperObs wrapper, BayesIm bayesIm) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.wrapper = wrapper;
        this.init(bayesIm);
    }

    private void init(BayesIm bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException("Bayes IM must not be null.");
        }
        BayesPm bayesPm = bayesIm.getBayesPm();
        Graph graph = bayesPm.getDag();
        GraphWorkbench workbench = new GraphWorkbench(graph);
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveScreenshot(this, true, "Save Screenshot..."));
        file.add(new SaveComponentImage(workbench, "Save Graph Image..."));
        this.setLayout(new BorderLayout());
        this.add((Component)menuBar, "North");
        this.wizard = new BayesImEditorWizardObs(bayesIm, workbench);
        this.wizard.enableEditing(false);
        this.wizard.addPropertyChangeListener(evt -> {
            if ("editorValueChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        JScrollPane wizardScroll = new JScrollPane(this.getWizard());
        workbenchScroll.setPreferredSize(new Dimension(450, 450));
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, wizardScroll);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        this.add((Component)splitPane, "Center");
        this.setName("Bayes IM Obs Editor");
        this.getWizard().addPropertyChangeListener(evt -> {
            if ("editorClosing".equals(evt.getPropertyName())) {
                this.firePropertyChange("editorClosing", null, this.getName());
            }
            if ("closeFrame".equals(evt.getPropertyName())) {
                this.firePropertyChange("closeFrame", null, null);
                this.firePropertyChange("editorClosing", true, true);
            }
            if ("modelChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public BayesImEditorObs(BayesImWrapperObs bayesImWrapperObs) {
        this(bayesImWrapperObs, bayesImWrapperObs.getBayesIm());
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private BayesImEditorWizardObs getWizard() {
        return this.wizard;
    }

    public void getBayesIm(BayesIm bayesIm) {
        this.wrapper.setBayesIm(bayesIm);
        this.removeAll();
        this.init(this.wrapper.getBayesIm());
        this.revalidate();
        this.repaint();
        this.firePropertyChange("modelChanged", null, null);
    }
}

