/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetradapp.editor.BayesImNodeEditingTableObs;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;

public final class BayesImEditorWizardObs
extends JPanel {
    private static final long serialVersionUID = -2275425522013903246L;
    private final BayesIm bayesIm;
    private final GraphWorkbench workbench;
    private boolean enableEditing = true;

    public BayesImEditorWizardObs(BayesIm bayesIm, GraphWorkbench workbench) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        workbench.setAllowDoubleClickActions(false);
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        this.setFont(new Font("SanSerif", 1, 12));
        BayesImNodeEditingTableObs editingTable = new BayesImNodeEditingTableObs(bayesIm);
        editingTable.addPropertyChangeListener(evt -> {
            if ("modelChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        JScrollPane scroll = new JScrollPane(editingTable);
        scroll.setPreferredSize(new Dimension(0, 150));
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)scroll, "Center");
        editingTable.grabFocus();
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Click in the appropriate box and assign a probability to each combination"));
        b3.add(Box.createHorizontalGlue());
        Box b3a = Box.createHorizontalBox();
        b3a.add(new JLabel("of variable values in that row."));
        b3a.add(Box.createHorizontalGlue());
        Box b4 = Box.createHorizontalBox();
        b4.add((Component)tablePanel, "Center");
        Box b5 = Box.createHorizontalBox();
        b5.add(new JLabel("Right click in table to randomize."));
        b5.add(Box.createHorizontalGlue());
        Box b6 = Box.createHorizontalBox();
        b6.add(new JLabel("Note: Editing this table with arbitrary numbers may result in a table "));
        b6.add(Box.createHorizontalGlue());
        Box b6a = Box.createHorizontalBox();
        b6a.add(new JLabel("inconsistent with the graph constraints."));
        b6a.add(Box.createHorizontalGlue());
        this.add(b3);
        this.add(b3a);
        this.add(b4);
        this.add(b5);
        this.add(Box.createVerticalStrut(5));
        this.add(b6);
        this.add(b6a);
        this.bayesIm = bayesIm;
        this.workbench = workbench;
    }

    public BayesIm getBayesIm() {
        return this.bayesIm;
    }

    public boolean isEnableEditing() {
        return this.enableEditing;
    }

    public void enableEditing(boolean enableEditing) {
        this.enableEditing = enableEditing;
        if (this.workbench != null) {
            this.workbench.enableEditing(enableEditing);
        }
    }
}

