/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.NumberCellEditor;
import edu.cmu.tetradapp.editor.NumberCellRenderer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;

class BayesImNodeEditingTable
extends JTable {
    private int focusRow;
    private int focusCol;
    private int lastX;
    private int lastY;

    public BayesImNodeEditingTable(Node node, BayesIm bayesIm) {
        if (node == null) {
            return;
        }
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        if (bayesIm.getNodeIndex(node) < 0) {
            throw new IllegalArgumentException("Node " + node + " is not a node for BayesIm " + bayesIm + ".");
        }
        Model model = new Model(node, bayesIm, this);
        model.addPropertyChangeListener(evt -> {
            if ("modelChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        this.setModel(model);
        this.setDefaultEditor(Number.class, new NumberCellEditor());
        this.setDefaultRenderer(Number.class, new NumberCellRenderer());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        ListSelectionModel rowSelectionModel = this.getSelectionModel();
        rowSelectionModel.addListSelectionListener(e -> {
            ListSelectionModel m = (ListSelectionModel)e.getSource();
            this.setFocusRow(m.getAnchorSelectionIndex());
        });
        ListSelectionModel columnSelectionModel = this.getColumnModel().getSelectionModel();
        columnSelectionModel.addListSelectionListener(e -> {
            ListSelectionModel m = (ListSelectionModel)e.getSource();
            this.setFocusColumn(m.getAnchorSelectionIndex());
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    BayesImNodeEditingTable.this.showPopup(e);
                }
            }
        });
        this.setFocusRow(0);
        this.setFocusColumn(0);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        if (this.getModel() instanceof Model) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Model model = (Model)this.getModel();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                int minimumWidth;
                TableColumn column = this.getColumnModel().getColumn(i);
                String columnName = model.getColumnName(i);
                int currentWidth = column.getPreferredWidth();
                if (columnName == null || (minimumWidth = fontMetrics.stringWidth(columnName) + 8) <= currentWidth) continue;
                column.setPreferredWidth(minimumWidth);
            }
        }
    }

    private void showPopup(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem randomizeRow = new JMenuItem("Randomize this row");
        JMenuItem randomizeIncompleteRows = new JMenuItem("Randomize incomplete rows in table");
        JMenuItem randomizeEntireTable = new JMenuItem("Randomize entire table");
        JMenuItem randomizeAllTables = new JMenuItem("Randomize all tables");
        JMenuItem clearRow = new JMenuItem("Clear this row");
        JMenuItem clearEntireTable = new JMenuItem("Clear entire table");
        randomizeRow.addActionListener(e1 -> {
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            BayesImNodeEditingTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            Point point = new Point(this.getLastX(), this.getLastY());
            int rowIndex = editingTable.rowAtPoint(point);
            BayesIm bayesIm = this.getBayesIm();
            bayesIm.randomizeRow(nodeIndex, rowIndex);
            this.getEditingTableModel().fireTableDataChanged();
            this.firePropertyChange("modelChanged", null, null);
        });
        randomizeIncompleteRows.addActionListener(e12 -> {
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            BayesIm bayesIm = this.getBayesIm();
            if (!this.existsIncompleteRow(bayesIm, nodeIndex)) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "There are no incomplete rows in this table.");
                return;
            }
            BayesImNodeEditingTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            bayesIm.randomizeIncompleteRows(nodeIndex);
            this.getEditingTableModel().fireTableDataChanged();
            this.firePropertyChange("modelChanged", null, null);
        });
        randomizeEntireTable.addActionListener(e13 -> {
            int ret;
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            BayesIm bayesIm = this.getBayesIm();
            if (this.existsCompleteRow(bayesIm, nodeIndex) && (ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will modify all values in the table. Continue?", "Warning", 0)) == 1) {
                return;
            }
            BayesImNodeEditingTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            bayesIm.randomizeTable(nodeIndex);
            this.getEditingTableModel().fireTableDataChanged();
            this.firePropertyChange("modelChanged", null, null);
        });
        randomizeAllTables.addActionListener(e14 -> {
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will modify all values in the entire Bayes model! Continue?", "Warning", 0);
            if (ret == 1) {
                return;
            }
            BayesIm bayesIm = this.getBayesIm();
            for (int nodeIndex = 0; nodeIndex < this.getBayesIm().getNumNodes(); ++nodeIndex) {
                BayesImNodeEditingTable editingTable = this;
                TableCellEditor cellEditor = editingTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                bayesIm.randomizeTable(nodeIndex);
                this.getEditingTableModel().fireTableDataChanged();
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        clearRow.addActionListener(e15 -> {
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            BayesImNodeEditingTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            Point point = new Point(this.getLastX(), this.getLastY());
            int rowIndex = editingTable.rowAtPoint(point);
            BayesIm bayesIm = this.getBayesIm();
            bayesIm.clearRow(nodeIndex, rowIndex);
            this.getEditingTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
            this.firePropertyChange("modelChanged", null, null);
        });
        clearEntireTable.addActionListener(e16 -> {
            int ret;
            int nodeIndex = this.getEditingTableModel().getNodeIndex();
            BayesIm bayesIm = this.getBayesIm();
            if (this.existsCompleteRow(bayesIm, nodeIndex) && (ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will delete all values in the table. Continue?", "Warning", 0)) == 1) {
                return;
            }
            BayesImNodeEditingTable editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            bayesIm.clearTable(nodeIndex);
            this.getEditingTableModel().fireTableDataChanged();
            this.firePropertyChange("modelChanged", null, null);
        });
        popup.add(randomizeRow);
        popup.add(randomizeIncompleteRows);
        popup.add(randomizeEntireTable);
        popup.add(randomizeAllTables);
        popup.addSeparator();
        popup.add(clearRow);
        popup.add(clearEntireTable);
        this.lastX = e.getX();
        this.lastY = e.getY();
        popup.show((Component)e.getSource(), e.getX(), e.getY());
    }

    private boolean existsCompleteRow(BayesIm bayesIm, int nodeIndex) {
        boolean existsCompleteRow = false;
        for (int rowIndex = 0; rowIndex < bayesIm.getNumRows(nodeIndex); ++rowIndex) {
            if (bayesIm.isIncomplete(nodeIndex, rowIndex)) continue;
            existsCompleteRow = true;
            break;
        }
        return existsCompleteRow;
    }

    private boolean existsIncompleteRow(BayesIm bayesIm, int nodeIndex) {
        boolean existsCompleteRow = false;
        for (int rowIndex = 0; rowIndex < bayesIm.getNumRows(nodeIndex); ++rowIndex) {
            if (!bayesIm.isIncomplete(nodeIndex, rowIndex)) continue;
            existsCompleteRow = true;
            break;
        }
        return existsCompleteRow;
    }

    @Override
    public void setModel(@NotNull TableModel model) {
        super.setModel(model);
    }

    private void setFocusRow(int row) {
        if (row == -1) {
            return;
        }
        Model editingTableModel = (Model)this.getModel();
        int failedRow = editingTableModel.getFailedRow();
        if (failedRow != -1) {
            row = failedRow;
            editingTableModel.resetFailedRow();
        }
        this.focusRow = row;
        if (this.focusCol < this.getRowCount()) {
            this.setRowSelectionInterval(this.focusRow, this.focusRow);
            this.editCellAt(this.focusRow, this.focusCol);
        }
    }

    private void setFocusColumn(int col) {
        Model editingTableModel = (Model)this.getModel();
        int failedCol = editingTableModel.getFailedCol();
        if (failedCol != -1) {
            col = failedCol;
            editingTableModel.resetFailedCol();
        }
        if (col < this.getNumParents()) {
            col = this.getNumParents();
        }
        this.focusCol = FastMath.max(col, this.getNumParents());
        if (this.focusCol >= this.getNumParents() && this.focusCol < this.getColumnCount()) {
            this.setColumnSelectionInterval(this.focusCol, this.focusCol);
            this.editCellAt(this.focusRow, this.focusCol);
        }
    }

    private int getNumParents() {
        Model editingTableModel = (Model)this.getModel();
        BayesIm bayesIm = editingTableModel.getBayesIm();
        int nodeIndex = editingTableModel.getNodeIndex();
        return bayesIm.getNumParents(nodeIndex);
    }

    private Model getEditingTableModel() {
        return (Model)this.getModel();
    }

    private BayesIm getBayesIm() {
        return this.getEditingTableModel().getBayesIm();
    }

    private int getLastX() {
        return this.lastX;
    }

    private int getLastY() {
        return this.lastY;
    }

    static final class Model
    extends AbstractTableModel {
        private final BayesIm bayesIm;
        private final int nodeIndex;
        private int failedRow = -1;
        private int failedCol = -1;
        private PropertyChangeSupport pcs;

        public Model(Node node, BayesIm bayesIm, JComponent messageAnchor) {
            if (node == null) {
                throw new NullPointerException("Node must not be null.");
            }
            if (bayesIm == null) {
                throw new NullPointerException("Bayes IM must not be null.");
            }
            if (messageAnchor == null) {
                throw new NullPointerException("Message anchor must not be null.");
            }
            this.bayesIm = bayesIm;
            this.nodeIndex = bayesIm.getNodeIndex(node);
        }

        @Override
        public String getColumnName(int col) {
            Node node = this.getBayesIm().getNode(this.getNodeIndex());
            if (col < this.getBayesIm().getNumParents(this.getNodeIndex())) {
                int parent = this.getBayesIm().getParent(this.getNodeIndex(), col);
                return this.getBayesIm().getNode(parent).getName();
            }
            int numNodeVals = this.getBayesIm().getNumColumns(this.getNodeIndex());
            int valIndex = col - this.getBayesIm().getNumParents(this.getNodeIndex());
            if (valIndex < numNodeVals) {
                String value = this.getBayesIm().getBayesPm().getCategory(node, valIndex);
                return node.getName() + "=" + value;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.getBayesIm().getNumRows(this.getNodeIndex());
        }

        @Override
        public int getColumnCount() {
            int numParents = this.getBayesIm().getNumParents(this.getNodeIndex());
            int numColumns = this.getBayesIm().getNumColumns(this.getNodeIndex());
            return numParents + numColumns;
        }

        @Override
        public Object getValueAt(int tableRow, int tableCol) {
            int[] parentVals = this.getBayesIm().getParentValues(this.getNodeIndex(), tableRow);
            if (tableCol < parentVals.length) {
                Node columnNode = this.getBayesIm().getNode(this.getBayesIm().getParent(this.getNodeIndex(), tableCol));
                BayesPm bayesPm = this.getBayesIm().getBayesPm();
                return bayesPm.getCategory(columnNode, parentVals[tableCol]);
            }
            int colIndex = tableCol - parentVals.length;
            if (colIndex < this.getBayesIm().getNumColumns(this.getNodeIndex())) {
                return this.getBayesIm().getProbability(this.getNodeIndex(), tableRow, colIndex);
            }
            return "null";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= this.getBayesIm().getNumParents(this.getNodeIndex());
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            int numParents = this.getBayesIm().getNumParents(this.getNodeIndex());
            int colIndex = col - numParents;
            if ("".equals(aValue) || aValue == null) {
                this.getBayesIm().setProbability(this.getNodeIndex(), row, colIndex, Double.NaN);
                this.fireTableRowsUpdated(row, row);
                this.getPcs().firePropertyChange("modelChanged", null, null);
                return;
            }
            try {
                NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                double probability = Double.parseDouble((String)aValue);
                double sumInRow = this.sumInRow(row, colIndex) + probability;
                double oldProbability = this.getBayesIm().getProbability(this.nodeIndex, row, colIndex);
                if (!Double.isNaN(oldProbability)) {
                    oldProbability = Double.parseDouble(nf.format(oldProbability));
                }
                if (probability == oldProbability) {
                    return;
                }
                if (this.probabilityOutOfRange(probability)) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Probabilities must be in range [0.0, 1.0].");
                    this.failedRow = row;
                    this.failedCol = col;
                } else if (this.numNanCols(row) == 0) {
                    if (sumInRow < 0.99995 || sumInRow > 1.00005) {
                        this.emptyRow(row);
                        this.getBayesIm().setProbability(this.getNodeIndex(), row, colIndex, probability);
                        if (this.bayesIm.getNumColumns(this.nodeIndex) == 2) {
                            this.fillInSingleRemainingColumn(row);
                        }
                        this.fireTableRowsUpdated(row, row);
                        this.getPcs().firePropertyChange("modelChanged", null, null);
                    }
                } else if (sumInRow > 1.00005) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Sum of probabilities in row must not exceed 1.0.");
                    this.failedRow = row;
                    this.failedCol = col;
                } else {
                    this.getBayesIm().setProbability(this.getNodeIndex(), row, colIndex, probability);
                    this.fillInSingleRemainingColumn(row);
                    this.fillInZerosIfSumIsOne(row);
                    this.fireTableRowsUpdated(row, row);
                    this.getPcs().firePropertyChange("modelChanged", null, null);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not interpret '" + aValue + "'");
                this.failedRow = row;
                this.failedCol = col;
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.getPcs().addPropertyChangeListener(l);
        }

        private PropertyChangeSupport getPcs() {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            return this.pcs;
        }

        private void fillInSingleRemainingColumn(int rowIndex) {
            int leftOverColumn = this.uniqueNanCol(rowIndex);
            if (leftOverColumn != -1) {
                double difference = 1.0 - this.sumInRow(rowIndex, leftOverColumn);
                this.getBayesIm().setProbability(this.getNodeIndex(), rowIndex, leftOverColumn, difference);
            }
        }

        private void fillInZerosIfSumIsOne(int rowIndex) {
            double sum = this.sumInRow(rowIndex, -1);
            if (sum > 0.9995 && sum < 1.0005) {
                int numColumns = this.getBayesIm().getNumColumns(this.getNodeIndex());
                for (int i = 0; i < numColumns; ++i) {
                    double probability = this.getBayesIm().getProbability(this.getNodeIndex(), rowIndex, i);
                    if (!Double.isNaN(probability)) continue;
                    this.getBayesIm().setProbability(this.getNodeIndex(), rowIndex, i, 0.0);
                }
            }
        }

        private boolean probabilityOutOfRange(double value) {
            return value < 0.0 || value > 1.0;
        }

        private int uniqueNanCol(int rowIndex) {
            int numNanCols = 0;
            int lastNanCol = -1;
            for (int i = 0; i < this.getBayesIm().getNumColumns(this.getNodeIndex()); ++i) {
                double probability = this.getBayesIm().getProbability(this.getNodeIndex(), rowIndex, i);
                if (!Double.isNaN(probability)) continue;
                ++numNanCols;
                lastNanCol = i;
            }
            return numNanCols == 1 ? lastNanCol : -1;
        }

        private int numNanCols(int rowIndex) {
            int numNanCols = 0;
            for (int i = 0; i < this.getBayesIm().getNumColumns(this.getNodeIndex()); ++i) {
                double probability = this.getBayesIm().getProbability(this.getNodeIndex(), rowIndex, i);
                if (!Double.isNaN(probability)) continue;
                ++numNanCols;
            }
            return numNanCols;
        }

        private void emptyRow(int rowIndex) {
            for (int i = 0; i < this.getBayesIm().getNumColumns(this.getNodeIndex()); ++i) {
                this.getBayesIm().setProbability(this.getNodeIndex(), rowIndex, i, Double.NaN);
            }
        }

        private double sumInRow(int rowIndex, int skipCol) {
            double sum = 0.0;
            for (int i = 0; i < this.getBayesIm().getNumColumns(this.getNodeIndex()); ++i) {
                double probability = this.getBayesIm().getProbability(this.getNodeIndex(), rowIndex, i);
                if (i == skipCol || Double.isNaN(probability)) continue;
                NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                probability = Double.parseDouble(nf.format(probability));
                sum += probability;
            }
            return sum;
        }

        public Class getColumnClass(int col) {
            boolean isParent = col < this.getBayesIm().getNumParents(this.getNodeIndex());
            return isParent ? Object.class : Number.class;
        }

        public BayesIm getBayesIm() {
            return this.bayesIm;
        }

        public int getNodeIndex() {
            return this.nodeIndex;
        }

        public int getFailedRow() {
            return this.failedRow;
        }

        public int getFailedCol() {
            return this.failedCol;
        }

        public void resetFailedRow() {
            this.failedRow = -1;
        }

        public void resetFailedCol() {
            this.failedCol = -1;
        }
    }
}

