/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesImObs;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.NumberCellEditor;
import edu.cmu.tetradapp.editor.NumberCellRenderer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

class BayesImNodeEditingTableObs
extends JTable {
    private int focusRow;
    private int focusCol;

    public BayesImNodeEditingTableObs(BayesIm bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        Model model = new Model(bayesIm, this);
        model.addPropertyChangeListener(evt -> {
            if ("modelChanged".equals(evt.getPropertyName())) {
                this.firePropertyChange("modelChanged", null, null);
            }
        });
        this.setModel(model);
        this.setDefaultEditor(Number.class, new NumberCellEditor());
        this.setDefaultRenderer(Number.class, new NumberCellRenderer());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        ListSelectionModel rowSelectionModel = this.getSelectionModel();
        rowSelectionModel.addListSelectionListener(e -> {
            ListSelectionModel m = (ListSelectionModel)e.getSource();
            this.setFocusRow(m.getAnchorSelectionIndex());
        });
        ListSelectionModel columnSelectionModel = this.getColumnModel().getSelectionModel();
        columnSelectionModel.addListSelectionListener(e -> this.setFocusColumn());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    BayesImNodeEditingTableObs.this.showPopup(e);
                }
            }
        });
        this.setFocusRow(0);
        this.setFocusColumn();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        if (this.getModel() instanceof Model) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Model model = (Model)this.getModel();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                int minimumWidth;
                TableColumn column = this.getColumnModel().getColumn(i);
                String columnName = model.getColumnName(i);
                int currentWidth = column.getPreferredWidth();
                if (columnName == null || (minimumWidth = fontMetrics.stringWidth(columnName) + 8) <= currentWidth) continue;
                column.setPreferredWidth(minimumWidth);
            }
        }
    }

    private void showPopup(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem randomizeEntireTable = new JMenuItem("Randomize entire table");
        JMenuItem clearEntireTable = new JMenuItem("Clear entire table");
        randomizeEntireTable.addActionListener(e1 -> {
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will modify all values in the table. Continue?", "Warning", 0);
            if (ret == 1) {
                return;
            }
            BayesImNodeEditingTableObs editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            this.getBayesIm().createRandomCellTable();
            this.getEditingTableModel().fireTableDataChanged();
            this.firePropertyChange("modelChanged", null, null);
        });
        clearEntireTable.addActionListener(e12 -> {
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This will delete all values in the table. Continue?", "Warning", 0);
            if (ret == 1) {
                return;
            }
            BayesImNodeEditingTableObs editingTable = this;
            TableCellEditor cellEditor = editingTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            this.getBayesIm().getJPD().clearCellTable();
            this.getEditingTableModel().fireTableDataChanged();
            this.firePropertyChange("modelChanged", null, null);
        });
        popup.add(randomizeEntireTable);
        popup.add(clearEntireTable);
        popup.show((Component)e.getSource(), e.getX(), e.getY());
    }

    @Override
    public void setModel(@NotNull TableModel model) {
        super.setModel(model);
    }

    private void setFocusRow(int row) {
        if (row == -1) {
            return;
        }
        Model editingTableModel = (Model)this.getModel();
        int failedRow = editingTableModel.getFailedRow();
        if (failedRow != -1) {
            row = failedRow;
            editingTableModel.resetFailedRow();
        }
        this.focusRow = row;
        if (this.focusRow < this.getRowCount()) {
            this.setRowSelectionInterval(this.focusRow, this.focusRow);
            this.editCellAt(this.focusRow, this.focusCol);
        }
    }

    private void setFocusColumn() {
        Model editingTableModel = (Model)this.getModel();
        int failedCol = editingTableModel.getFailedCol();
        if (failedCol != -1) {
            editingTableModel.resetFailedCol();
        }
        this.focusCol = this.getColumnCount() - 1;
        this.setColumnSelectionInterval(this.focusCol, this.focusCol);
        this.editCellAt(this.focusRow, this.focusCol);
    }

    private Model getEditingTableModel() {
        return (Model)this.getModel();
    }

    private MlBayesImObs getBayesIm() {
        return this.getEditingTableModel().getBayesIm();
    }

    static final class Model
    extends AbstractTableModel {
        private final MlBayesImObs bayesIm;
        private int failedRow = -1;
        private int failedCol = -1;
        private PropertyChangeSupport pcs;
        private final List<Node> obsNodes = new ArrayList<Node>();

        public Model(BayesIm bayesIm, JComponent messageAnchor) {
            if (bayesIm == null) {
                throw new NullPointerException("Bayes IM must not be null.");
            }
            if (messageAnchor == null) {
                throw new NullPointerException("Message anchor must not be null.");
            }
            this.bayesIm = (MlBayesImObs)bayesIm;
            for (int i = 0; i < bayesIm.getNumNodes(); ++i) {
                Node nodeO = bayesIm.getNode(i);
                if (nodeO.getNodeType() != NodeType.MEASURED) continue;
                this.obsNodes.add(nodeO);
            }
        }

        @Override
        public String getColumnName(int col) {
            if (col < this.obsNodes.size()) {
                return this.obsNodes.get(col).getName();
            }
            if (col == this.obsNodes.size()) {
                return "Probability";
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.getBayesIm().getNumRows();
        }

        @Override
        public int getColumnCount() {
            return this.obsNodes.size() + 1;
        }

        @Override
        public Object getValueAt(int tableRow, int tableCol) {
            if (tableCol < this.obsNodes.size()) {
                int categoryIndex = this.getBayesIm().getRowValues(tableRow)[tableCol];
                BayesPm bayesPm = this.getBayesIm().getBayesPm();
                return bayesPm.getCategory(this.obsNodes.get(tableCol), categoryIndex);
            }
            if (tableCol == this.obsNodes.size()) {
                return this.getBayesIm().getProbability(tableRow);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col >= this.obsNodes.size();
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if ("".equals(aValue) || aValue == null) {
                this.getBayesIm().setProbability(row, Double.NaN);
                this.fireTableRowsUpdated(row, row);
                this.getPcs().firePropertyChange("modelChanged", null, null);
                return;
            }
            try {
                NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                double probability = Double.parseDouble((String)aValue);
                double sum = this.sumProb(row) + probability;
                double oldProbability = this.getBayesIm().getProbability(row);
                if (!Double.isNaN(oldProbability)) {
                    oldProbability = Double.parseDouble(nf.format(oldProbability));
                }
                if (probability == oldProbability) {
                    return;
                }
                if (this.probabilityOutOfRange(probability)) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Probabilities must be in range [0.0, 1.0].");
                    this.failedRow = row;
                    this.failedCol = col;
                } else if (sum > 1.00005) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Sum of probabilities in the column must not exceed 1.0.");
                    this.failedRow = row;
                    this.failedCol = col;
                } else {
                    this.getBayesIm().setProbability(row, probability);
                    if (this.numNanRows() == 0 && sum < 0.99995) {
                        if (this.getBayesIm().getNumRows() == 2) {
                            this.getBayesIm().setProbability(row, probability);
                            this.fillInSingleRemainingRow();
                            this.fireTableRowsUpdated(row, row);
                            this.getPcs().firePropertyChange("modelChanged", null, null);
                        } else {
                            this.getBayesIm().setProbability(row, oldProbability);
                            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Probabilities in the column must sum up to 1.0.\nLeave one row (or two) blank while working.");
                            this.failedRow = row;
                            this.failedCol = col;
                        }
                    } else {
                        this.fillInSingleRemainingRow();
                        this.fillInZerosIfSumIsOne();
                        this.fireTableRowsUpdated(row, row);
                        this.getPcs().firePropertyChange("modelChanged", null, null);
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not interpret '" + aValue + "'");
                this.failedRow = row;
                this.failedCol = col;
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.getPcs().addPropertyChangeListener(l);
        }

        private PropertyChangeSupport getPcs() {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            return this.pcs;
        }

        private void fillInSingleRemainingRow() {
            int leftOverRow = this.uniqueNanRow();
            if (leftOverRow != -1) {
                double difference = 1.0 - this.sumProb(leftOverRow);
                this.getBayesIm().setProbability(leftOverRow, difference);
            }
        }

        private void fillInZerosIfSumIsOne() {
            double sum = this.sumProb(-1);
            if (sum > 0.9995 && sum < 1.0005) {
                int numRows = this.getBayesIm().getNumRows();
                for (int i = 0; i < numRows; ++i) {
                    double probability = this.getBayesIm().getProbability(i);
                    if (!Double.isNaN(probability)) continue;
                    this.getBayesIm().setProbability(i, 0.0);
                }
            }
        }

        private boolean probabilityOutOfRange(double value) {
            return value < 0.0 || value > 1.0;
        }

        private int uniqueNanRow() {
            int numNanRows = 0;
            int lastNanRow = -1;
            for (int i = 0; i < this.getBayesIm().getNumRows(); ++i) {
                double probability = this.getBayesIm().getProbability(i);
                if (!Double.isNaN(probability)) continue;
                ++numNanRows;
                lastNanRow = i;
            }
            return numNanRows == 1 ? lastNanRow : -1;
        }

        private int numNanRows() {
            int numNanRows = 0;
            for (int i = 0; i < this.getBayesIm().getNumRows(); ++i) {
                double probability = this.getBayesIm().getProbability(i);
                if (!Double.isNaN(probability)) continue;
                ++numNanRows;
            }
            return numNanRows;
        }

        private double sumProb(int rowToSkip) {
            double sum = 0.0;
            for (int i = 0; i < this.getBayesIm().getNumRows(); ++i) {
                double probability = this.getBayesIm().getProbability(i);
                if (i == rowToSkip || Double.isNaN(probability)) continue;
                NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
                probability = Double.parseDouble(nf.format(probability));
                sum += probability;
            }
            return sum;
        }

        public Class getColumnClass(int col) {
            return col == this.getColumnCount() - 1 ? Number.class : Object.class;
        }

        public MlBayesImObs getBayesIm() {
            return this.bayesIm;
        }

        public int getFailedRow() {
            return this.failedRow;
        }

        public int getFailedCol() {
            return this.failedCol;
        }

        public void resetFailedRow() {
            this.failedRow = -1;
        }

        public void resetFailedCol() {
            this.failedCol = -1;
        }
    }
}

