/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetradapp.editor.BayesPmEditorWizard;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class BayesPmEditor
extends JPanel
implements PropertyChangeListener,
DelegatesEditing {
    private final JPanel targetPanel;
    private final BayesPmWrapper wrapper;
    private BayesPmEditorWizard wizard;

    public BayesPmEditor(BayesPmWrapper wrapper) {
        this.wrapper = wrapper;
        this.setLayout(new BorderLayout());
        this.targetPanel = new JPanel();
        this.targetPanel.setLayout(new BorderLayout());
        this.setEditorPanel();
        this.add((Component)this.targetPanel, "Center");
        this.validate();
        if (wrapper.getNumModels() > 1) {
            JComboBox<Integer> comp = new JComboBox<Integer>();
            for (int i = 0; i < wrapper.getNumModels(); ++i) {
                comp.addItem(i + 1);
            }
            comp.addActionListener(e -> {
                wrapper.setModelIndex((Integer)comp.getSelectedItem() - 1);
                this.setEditorPanel();
                this.validate();
            });
            comp.setMaximumSize(comp.getPreferredSize());
            Box b = Box.createHorizontalBox();
            b.add(new JLabel("Using model"));
            b.add(comp);
            b.add(new JLabel("from "));
            b.add(new JLabel(wrapper.getModelSourceName()));
            b.add(Box.createHorizontalGlue());
            this.add((Component)b, "North");
        }
    }

    private void setEditorPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        if (this.wrapper.getBayesPm().getDag().getNumNodes() == 0) {
            throw new IllegalArgumentException("There are no nodes in that Bayes PM.");
        }
        this.setLayout(new BorderLayout());
        Graph graph = this.wrapper.getBayesPm().getDag();
        GraphWorkbench workbench = new GraphWorkbench(graph);
        workbench.enableEditing(false);
        BayesPmEditorWizard wizard = new BayesPmEditorWizard(this.wrapper.getBayesPm(), workbench);
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        JScrollPane wizardScroll = new JScrollPane(wizard);
        workbenchScroll.setPreferredSize(new Dimension(450, 450));
        wizardScroll.setPreferredSize(new Dimension(450, 450));
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, wizardScroll);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        panel.add((Component)splitPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(workbench, "Save Graph Image..."));
        panel.add((Component)menuBar, "North");
        this.setName("Bayes PM Editor");
        wizard.addPropertyChangeListener(this);
        wizard.setEditingLatentVariablesAllowed(this.isEditingLatentVariablesAllowed());
        wizard.setEditingMeasuredVariablesAllowed(true);
        this.wizard = wizard;
        this.targetPanel.add((Component)panel, "Center");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("editorClosing".equals(e.getPropertyName())) {
            this.firePropertyChange("editorClosing", null, this.getName());
        }
        if ("closeFrame".equals(e.getPropertyName())) {
            this.firePropertyChange("closeFrame", null, null);
        }
        if ("modelChanged".equals(e.getPropertyName())) {
            this.firePropertyChange("modelChanged", e.getOldValue(), e.getNewValue());
        }
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    @Override
    public JComponent getEditDelegate() {
        return this.wizard;
    }

    private boolean isEditingLatentVariablesAllowed() {
        return true;
    }
}

