/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.util.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class BayesPmParamsEditor
extends JPanel
implements ParameterEditor {
    private Parameters params;
    private IntTextField lowerBoundField;
    private IntTextField upperBoundField;

    @Override
    public void setParams(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        this.lowerBoundField = new IntTextField(this.getParams().getInt("lowerBoundNumVals", 2), 4);
        this.lowerBoundField.setFilter((value, oldValue) -> {
            try {
                this.getParams().set("lowerBoundNumVals", (Object)value);
                return value;
            }
            catch (Exception e) {
                return oldValue;
            }
        });
        this.upperBoundField = new IntTextField(this.getParams().getInt("upperBoundNumVals", 4), 4);
        this.upperBoundField.setFilter((value, oldValue) -> {
            try {
                this.getParams().set("upperBoundNumVals", (Object)value);
                return value;
            }
            catch (Exception e) {
                return oldValue;
            }
        });
        this.setLayout(new BorderLayout());
        JRadioButton trinary = new JRadioButton("<html>3-valued:</html>");
        JRadioButton range = new JRadioButton("<html>Range:</html>");
        ButtonGroup group = new ButtonGroup();
        group.add(trinary);
        group.add(range);
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Categories for variables should be:"));
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        Box b3 = Box.createHorizontalBox();
        b3.add(trinary);
        b3.add(Box.createHorizontalGlue());
        b1.add(b3);
        Box b4 = Box.createHorizontalBox();
        b4.add(Box.createHorizontalStrut(25));
        b4.add(new JLabel("<html>All variables will initially have 3 categories, '0', '1' and '2', <br>which can then be changed variable by variable in the editor.</html>"));
        b4.add(Box.createHorizontalGlue());
        b1.add(b4);
        b1.add(Box.createVerticalStrut(10));
        Box b5 = Box.createHorizontalBox();
        b5.add(range);
        b5.add(Box.createHorizontalGlue());
        b1.add(b5);
        Box b6 = Box.createHorizontalBox();
        b6.add(Box.createHorizontalStrut(25));
        b6.add(new JLabel("<html>Each variable will be automatically be assigned a number of categories<br>in a range.</html>"));
        b6.add(Box.createHorizontalGlue());
        b1.add(b6);
        b1.add(Box.createVerticalStrut(10));
        Box b7 = Box.createHorizontalBox();
        b7.add(Box.createHorizontalStrut(25));
        b7.add(new JLabel("Least number of categories for each variable:  "));
        b7.add(Box.createHorizontalGlue());
        b7.add(this.lowerBoundField);
        b1.add(b7);
        Box b8 = Box.createHorizontalBox();
        b8.add(Box.createHorizontalStrut(25));
        b8.add(new JLabel("Greatest number of categories for each variable:  "));
        b8.add(Box.createHorizontalGlue());
        b8.add(this.upperBoundField);
        b1.add(b8);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
        if (this.getParams().getString("bayesPmInitializationMode", "trinary").equals("trinary")) {
            trinary.setSelected(true);
            this.lowerBoundField.setEnabled(false);
            this.upperBoundField.setEnabled(false);
        } else {
            range.setSelected(true);
            this.lowerBoundField.setEnabled(true);
            this.upperBoundField.setEnabled(true);
        }
        trinary.addActionListener(e -> {
            this.getParams().set("bayesPmInitializationMode", "trinary");
            this.lowerBoundField.setEnabled(false);
            this.upperBoundField.setEnabled(false);
        });
        range.addActionListener(e -> {
            this.getParams().set("bayesPmInitializationMode", "range");
            this.lowerBoundField.setEnabled(true);
            this.upperBoundField.setEnabled(true);
        });
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private synchronized Parameters getParams() {
        return this.params;
    }
}

