/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetradapp.editor.EvidenceWizardMultiple;
import edu.cmu.tetradapp.editor.EvidenceWizardSingle;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.editor.UpdatedBayesImWizard;
import edu.cmu.tetradapp.model.ApproximateUpdaterWrapper;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.JunctionTreeWrapper;
import edu.cmu.tetradapp.model.RowSummingExactWrapper;
import edu.cmu.tetradapp.model.UpdaterWrapper;
import edu.cmu.tetradapp.util.WatchedProcess;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class BayesUpdaterEditor
extends JPanel
implements DelegatesEditing {
    private static final int SINGLE_VALUE = 0;
    private static final int MULTI_VALUE = 1;
    private final UpdaterWrapper updaterWrapper;
    private GraphWorkbench workbench;
    private EvidenceWizardSingle evidenceWizardSingle;
    private EvidenceWizardMultiple evidenceWizardMultiple;
    private JPanel singleResultPanel;
    private JPanel multiResultPanel;
    private int updatedBayesImWizardTab;
    private JPanel cardPanel;
    private int mode = 0;

    private BayesUpdaterEditor(UpdaterWrapper updaterWrapper) {
        if (updaterWrapper == null) {
            throw new NullPointerException("Updater Wrapper must not be null.");
        }
        this.updaterWrapper = updaterWrapper;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createSplitPane(this.getUpdaterWrapper()), "Center");
        this.setName("Bayes Updater Editor");
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(this.workbench, "Save Graph Image..."));
        this.add((Component)menuBar, "North");
        this.workbench.addPropertyChangeListener(evt -> {
            if (this.mode == 1 && "selectedNodes".equals(evt.getPropertyName())) {
                this.setMode(1);
            }
        });
    }

    public BayesUpdaterEditor(RowSummingExactWrapper wrapper) {
        this((UpdaterWrapper)wrapper);
    }

    public BayesUpdaterEditor(CptInvariantUpdaterWrapper wrapper) {
        this((UpdaterWrapper)wrapper);
    }

    public BayesUpdaterEditor(ApproximateUpdaterWrapper wrapper) {
        this((UpdaterWrapper)wrapper);
    }

    public BayesUpdaterEditor(JunctionTreeWrapper wrapper) {
        this((UpdaterWrapper)wrapper);
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private EvidenceWizardSingle getEvidenceWizardSingle() {
        return this.evidenceWizardSingle;
    }

    private EvidenceWizardMultiple getEvidenceWizardMultiple() {
        return this.evidenceWizardMultiple;
    }

    @Override
    public JComponent getEditDelegate() {
        return this.evidenceWizardSingle;
    }

    private UpdaterWrapper getUpdaterWrapper() {
        return this.updaterWrapper;
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("editorClosing".equals(e.getPropertyName())) {
            this.firePropertyChange("editorClosing", null, this.getName());
        } else if ("closeFrame".equals(e.getPropertyName())) {
            this.firePropertyChange("closeFrame", null, null);
            this.firePropertyChange("editorClosing", true, true);
        } else if ("updatedBayesImWizardTab".equals(e.getPropertyName())) {
            this.updatedBayesImWizardTab = (Integer)e.getNewValue();
        }
    }

    private JSplitPane createSplitPane(UpdaterWrapper updaterWrapper) {
        JScrollPane workbenchScroll = this.createWorkbenchScroll(updaterWrapper);
        workbenchScroll.setBorder(new TitledBorder("Manipulated Graph"));
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, this.createRightPanel(updaterWrapper));
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        return splitPane;
    }

    private JScrollPane createWorkbenchScroll(UpdaterWrapper updaterWrapper) {
        this.workbench = new GraphWorkbench(updaterWrapper.getBayesUpdater().getManipulatedGraph());
        this.workbench.setAllowDoubleClickActions(false);
        JScrollPane workbenchScroll = new JScrollPane(this.getWorkbench());
        workbenchScroll.setPreferredSize(new Dimension(400, 400));
        return workbenchScroll;
    }

    private JPanel createRightPanel(UpdaterWrapper bayesUpdater) {
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.add((Component)this.createMenuBar(), "North");
        rightPanel.add((Component)this.createWizardPanel(bayesUpdater), "Center");
        BayesIm bayesIm = bayesUpdater.getBayesUpdater().getBayesIm();
        boolean incomplete = false;
        for (int i = 0; i < bayesIm.getNumNodes(); ++i) {
            if (!bayesIm.isIncomplete(i)) continue;
            incomplete = true;
            break;
        }
        if (incomplete) {
            JLabel label = new JLabel("NOTE: The Bayes IM is not completely specified.");
            label.setFont(new Font("Dialog", 1, 12));
            rightPanel.add((Component)label, "South");
        }
        return rightPanel;
    }

    private JPanel createWizardPanel(UpdaterWrapper updaterWrapper) {
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        this.evidenceWizardSingle = new EvidenceWizardSingle(updaterWrapper, this.getWorkbench());
        this.getEvidenceWizardSingle().addPropertyChangeListener(e -> {
            if ("updateButtonPressed".equals(e.getPropertyName())) {
                this.resetSingleResultPanel();
                this.show("viewSingleResult");
            }
        });
        this.cardPanel.add((Component)new JScrollPane(this.getEvidenceWizardSingle()), "editEvidenceSingle");
        this.evidenceWizardMultiple = new EvidenceWizardMultiple(updaterWrapper, this.getWorkbench());
        this.getEvidenceWizardMultiple().addPropertyChangeListener(e -> {
            if ("updateButtonPressed".equals(e.getPropertyName())) {
                this.resetMultipleResultPanel();
                this.show("viewMultiResult");
            }
        });
        this.cardPanel.add((Component)new JScrollPane(this.getEvidenceWizardMultiple()), "editEvidenceMultiple");
        this.singleResultPanel = new JPanel();
        this.singleResultPanel.setLayout(new BorderLayout());
        this.resetSingleResultPanel();
        this.multiResultPanel = new JPanel();
        this.multiResultPanel.setLayout(new BorderLayout());
        this.resetMultipleResultPanel();
        this.cardPanel.add((Component)new JScrollPane(this.singleResultPanel), "viewSingleResult");
        this.cardPanel.add((Component)new JScrollPane(this.multiResultPanel), "viewMultiResult");
        return this.cardPanel;
    }

    private void show(String s) {
        CardLayout card = (CardLayout)this.cardPanel.getLayout();
        card.show(this.cardPanel, s);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu evidenceMenu = new JMenu("Evidence");
        menuBar.add(evidenceMenu);
        JMenuItem editEvidence = new JMenuItem("Edit Evidence");
        editEvidence.setAccelerator(KeyStroke.getKeyStroke(69, 512));
        evidenceMenu.add(editEvidence);
        JMenu modeMenu = new JMenu("Mode");
        menuBar.add(modeMenu);
        JCheckBoxMenuItem singleVariable = new JCheckBoxMenuItem("In-Depth Information (Single Variable)");
        JCheckBoxMenuItem multiVariable = new JCheckBoxMenuItem("Marginals Only (Multiple Variables)");
        ButtonGroup group = new ButtonGroup();
        group.add(singleVariable);
        group.add(multiVariable);
        if (this.mode == 0) {
            singleVariable.setSelected(true);
        } else if (this.mode == 1) {
            multiVariable.setSelected(true);
        }
        modeMenu.add(singleVariable);
        modeMenu.add(multiVariable);
        editEvidence.addActionListener(e -> this.setMode(this.mode));
        singleVariable.addActionListener(e -> this.setMode(0));
        multiVariable.addActionListener(e -> this.setMode(1));
        return menuBar;
    }

    private void setMode(int mode) {
        this.mode = mode;
        if (mode == 0) {
            this.show("editEvidenceSingle");
        } else if (mode == 1) {
            this.show("editEvidenceMultiple");
        } else {
            throw new IllegalStateException();
        }
    }

    private void resetSingleResultPanel() {
        Window owner = (Window)this.getTopLevelAncestor();
        if (owner == null) {
            this.resetSingleResultPanelSub();
        } else {
            new WatchedProcess(owner){

                @Override
                public void watch() {
                    BayesUpdaterEditor.this.resetSingleResultPanelSub();
                }
            };
        }
    }

    private void resetSingleResultPanelSub() {
        UpdatedBayesImWizard wizard = new UpdatedBayesImWizard(this.getUpdaterWrapper(), this.getWorkbench(), this.updatedBayesImWizardTab, this.getSelectedNode());
        wizard.addPropertyChangeListener(e -> {
            if ("updatedBayesImWizardTab".equals(e.getPropertyName())) {
                this.updatedBayesImWizardTab = (Integer)e.getNewValue();
            }
        });
        this.singleResultPanel.removeAll();
        this.singleResultPanel.add((Component)wizard, "Center");
        this.singleResultPanel.revalidate();
        this.singleResultPanel.repaint();
    }

    private void resetMultipleResultPanel() {
        JTextArea textArea = this.getEvidenceWizardMultiple().getTextArea();
        this.multiResultPanel.removeAll();
        this.multiResultPanel.add((Component)textArea, "Center");
        this.multiResultPanel.revalidate();
        this.multiResultPanel.repaint();
    }

    private Node getSelectedNode() {
        UpdatedBayesImWizard wizard = null;
        Node selectedNode = null;
        for (int i = 0; i < this.singleResultPanel.getComponentCount(); ++i) {
            Component component = this.singleResultPanel.getComponent(i);
            if (!(component instanceof UpdatedBayesImWizard)) continue;
            wizard = (UpdatedBayesImWizard)component;
        }
        if (wizard != null) {
            selectedNode = wizard.getSelectedNode();
        }
        return selectedNode;
    }
}

