/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.search.BpcAlgorithmType;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

class BuildPureClustersIndTestParamsEditor2
extends JComponent {
    private final Parameters paramsPureClusters;

    public BuildPureClustersIndTestParamsEditor2(Parameters paramsPureClusters, boolean discreteData) {
        this.paramsPureClusters = paramsPureClusters;
        DecimalFormat smallNumberFormat = new DecimalFormat("0E00");
        DoubleTextField alphaField = new DoubleTextField(this.getParams().getDouble("alpha", 0.001), 8, new DecimalFormat("0.0########"), smallNumberFormat, 1.0E-4);
        alphaField.setFilter((value, oldValue) -> {
            try {
                this.getParams().set("alpha", (Object)0.001);
                return value;
            }
            catch (IllegalArgumentException e) {
                return oldValue;
            }
        });
        JComboBox<TestType> testSelector = new JComboBox<TestType>();
        if (!discreteData) {
            TestType[] descriptions = TestType.getTestDescriptions();
            testSelector.removeAllItems();
            for (TestType description : descriptions) {
                testSelector.addItem(description);
            }
            TestType tetradTestType = (TestType)this.getParams().get("tetradTestType", TestType.TETRAD_WISHART);
            testSelector.setSelectedItem(tetradTestType);
            testSelector.addActionListener(e -> {
                JComboBox combo = (JComboBox)e.getSource();
                TestType index = (TestType)combo.getSelectedItem();
                if (index != null) {
                    this.getParams().set("tetradTestType", (Object)index);
                }
            });
        }
        BpcAlgorithmType[] descriptions = BpcAlgorithmType.getAlgorithmDescriptions();
        JComboBox<BpcAlgorithmType> algorithmSelector = new JComboBox<BpcAlgorithmType>(descriptions);
        algorithmSelector.setSelectedItem(this.getParams().get("bpcAlgorithmthmType", BpcAlgorithmType.FIND_ONE_FACTOR_CLUSTERS));
        if (this.getParams().get("bpcAlgorithmthmType", BpcAlgorithmType.FIND_ONE_FACTOR_CLUSTERS) == BpcAlgorithmType.FIND_TWO_FACTOR_CLUSTERS) {
            testSelector.removeAllItems();
            testSelector.addItem(TestType.SAG);
            testSelector.addItem(TestType.GAP);
            testSelector.setSelectedItem(TestType.GAP);
        } else {
            TestType type1 = (TestType)testSelector.getItemAt(0);
            TestType type2 = (TestType)testSelector.getItemAt(1);
            if (type1 != TestType.TETRAD_WISHART || type2 != TestType.TETRAD_DELTA) {
                testSelector.removeAllItems();
                testSelector.addItem(TestType.TETRAD_WISHART);
                testSelector.addItem(TestType.TETRAD_DELTA);
            }
        }
        TestType tetradTestType = (TestType)this.getParams().get("tetradTestType", TestType.TETRAD_WISHART);
        testSelector.setSelectedItem(tetradTestType);
        if (paramsPureClusters.get("tetradTestType", TestType.TETRAD_WISHART) == TestType.TETRAD_WISHART) {
            testSelector.setSelectedItem(TestType.TETRAD_WISHART);
            this.getParams().set("tetradTestType", (Object)TestType.TETRAD_WISHART);
        } else {
            testSelector.setSelectedItem(TestType.TETRAD_DELTA);
            this.getParams().set("tetradTestType", (Object)TestType.TETRAD_DELTA);
        }
        algorithmSelector.addActionListener(e -> {
            JComboBox combo = (JComboBox)e.getSource();
            BpcAlgorithmType type = (BpcAlgorithmType)combo.getSelectedItem();
            this.getParams().set("bpcAlgorithmType", (Object)type);
            if (type == BpcAlgorithmType.FIND_TWO_FACTOR_CLUSTERS) {
                testSelector.removeAllItems();
                testSelector.addItem(TestType.SAG);
                testSelector.addItem(TestType.GAP);
                testSelector.setSelectedItem(TestType.GAP);
            } else {
                testSelector.removeAllItems();
                testSelector.addItem(TestType.TETRAD_WISHART);
                testSelector.addItem(TestType.TETRAD_DELTA);
                if (this.getParams().get("tetradTestType", TestType.TETRAD_WISHART) == TestType.TETRAD_WISHART) {
                    testSelector.setSelectedItem(TestType.TETRAD_WISHART);
                    this.getParams().set("tetradTestType", (Object)TestType.TETRAD_WISHART);
                } else {
                    testSelector.setSelectedItem(TestType.TETRAD_DELTA);
                    this.getParams().set("tetradTestType", (Object)TestType.TETRAD_DELTA);
                }
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        if (!discreteData) {
            Box b1 = Box.createHorizontalBox();
            b1.add(new JLabel("Test:"));
            b1.add(Box.createHorizontalGlue());
            b1.add(testSelector);
            this.add(b1);
            this.add(Box.createHorizontalGlue());
        }
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("Alpha:"));
        b3.add(Box.createHorizontalGlue());
        b3.add(alphaField);
        this.add(b3);
        this.add(Box.createHorizontalGlue());
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Algorithm:"));
        b4.add(Box.createHorizontalGlue());
        b4.add(algorithmSelector);
        this.add(b4);
        this.add(Box.createHorizontalGlue());
    }

    private Parameters getParams() {
        return this.paramsPureClusters;
    }
}

