/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.VariableSource;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.util.DoubleTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BuildPureClustersParamsEditor
extends JPanel
implements ParameterEditor {
    private Parameters params;
    private Object[] parentModels;

    @Override
    public void setParams(Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
        if (parentModels == null) {
            throw new NullPointerException();
        }
        this.parentModels = parentModels;
    }

    @Override
    public void setup() {
        boolean isDiscreteModel;
        DoubleTextField alphaField = new DoubleTextField(this.params.getDouble("alpha", 0.001), 4, NumberFormatUtil.getInstance().getNumberFormat());
        alphaField.setFilter((value, oldValue) -> {
            try {
                this.getParams().set("alpha", (Object)0.001);
                return value;
            }
            catch (Exception e) {
                return oldValue;
            }
        });
        TestType[] descriptions = TestType.getTestDescriptions();
        JComboBox<TestType> testSelector = new JComboBox<TestType>(descriptions);
        testSelector.setSelectedItem(this.getParams().get("tetradTestType", TestType.TETRAD_WISHART));
        testSelector.addActionListener(e -> {
            JComboBox combo = (JComboBox)e.getSource();
            TestType testType = (TestType)combo.getSelectedItem();
            this.getParams().set("tetradTestType", (Object)testType);
        });
        TestType[] purifyDescriptions = TestType.getPurifyTestDescriptions();
        JComboBox<TestType> purifySelector = new JComboBox<TestType>(purifyDescriptions);
        purifySelector.setSelectedItem(this.getParams().get("purifyTestType", TestType.NONE));
        purifySelector.addActionListener(e -> {
            JComboBox combo = (JComboBox)e.getSource();
            TestType testType = (TestType)combo.getSelectedItem();
            this.getParams().set("purifyTestType", (Object)testType);
        });
        VariableSource dataModel = null;
        for (Object parentModel : this.parentModels) {
            if (!(parentModel instanceof DataWrapper)) continue;
            DataWrapper dataWrapper = (DataWrapper)parentModel;
            dataModel = dataWrapper.getSelectedDataModel();
        }
        if (dataModel == null) {
            throw new IllegalStateException("Null data model.");
        }
        ArrayList<String> varNames = new ArrayList<String>(dataModel.getVariableNames());
        if (dataModel instanceof ICovarianceMatrix) {
            isDiscreteModel = false;
        } else {
            DataSet dataSet = (DataSet)dataModel;
            isDiscreteModel = dataSet.isDiscrete();
        }
        this.params.set("varNames", (Object)varNames);
        alphaField.setValue(this.params.getDouble("alpha", 0.001));
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Alpha:"));
        b1.add(Box.createHorizontalGlue());
        b1.add(alphaField);
        b.add(b1);
        if (!isDiscreteModel) {
            Box b2 = Box.createHorizontalBox();
            b2.add(new JLabel("Statistical Test:"));
            b2.add(Box.createHorizontalGlue());
            b2.add(testSelector);
            b.add(b2);
            Box b3 = Box.createHorizontalBox();
            b3.add(new JLabel("Purify Test:"));
            b3.add(Box.createHorizontalGlue());
            b3.add(purifySelector);
            b.add(b3);
        } else {
            this.params.set("purifyTestType", (Object)TestType.DISCRETE_LRT);
            this.params.set("tetradTestType", (Object)TestType.DISCRETE);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)b, "Center");
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private Parameters getParams() {
        return this.params;
    }
}

