/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.CopySubgraphAction;
import edu.cmu.tetradapp.editor.GraphEditable;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class CPDAGDisplay
extends JPanel
implements GraphEditable {
    private GraphWorkbench workbench;

    public CPDAGDisplay(Graph graph) {
        List<Graph> dags = SearchGraphUtils.generateCpdagDags(graph, false);
        if (dags.size() == 0) {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "There are no consistent DAG's.");
            return;
        }
        Graph dag = dags.get(0);
        this.workbench = new GraphWorkbench(dag);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, dags.size(), 1);
        model.addChangeListener(e -> {
            int index = model.getNumber().intValue();
            this.workbench.setGraph((Graph)dags.get(index - 1));
        });
        JSpinner spinner = new JSpinner();
        JComboBox<String> orient = new JComboBox<String>(new String[]{"Orient --- only", "Orient ---, &lt;->"});
        spinner.setModel(model);
        JLabel totalLabel = new JLabel(" of " + dags.size());
        orient.setMaximumSize(orient.getPreferredSize());
        orient.addActionListener(e -> {
            JComboBox box = (JComboBox)e.getSource();
            String option = (String)box.getSelectedItem();
            if ("Orient --- only".equals(option)) {
                List<Graph> _dags = SearchGraphUtils.generateCpdagDags(graph, false);
                dags.clear();
                dags.addAll(_dags);
                SpinnerNumberModel model1 = new SpinnerNumberModel(1, 1, dags.size(), 1);
                model1.addChangeListener(e1 -> {
                    int index = model1.getNumber().intValue();
                    this.workbench.setGraph((Graph)dags.get(index - 1));
                });
                spinner.setModel(model1);
                totalLabel.setText(" of " + dags.size());
                this.workbench.setGraph((Graph)dags.get(0));
            } else if ("Orient ---, &lt;->".equals(option)) {
                List<Graph> _dags = SearchGraphUtils.generateCpdagDags(graph, true);
                dags.clear();
                dags.addAll(_dags);
                SpinnerNumberModel model1 = new SpinnerNumberModel(1, 1, dags.size(), 1);
                model1.addChangeListener(e12 -> {
                    int index = model1.getNumber().intValue();
                    this.workbench.setGraph((Graph)dags.get(index - 1));
                });
                spinner.setModel(model1);
                totalLabel.setText(" of " + dags.size());
                this.workbench.setGraph((Graph)dags.get(0));
            }
        });
        spinner.setPreferredSize(new Dimension(50, 20));
        spinner.setMaximumSize(spinner.getPreferredSize());
        Box b = Box.createVerticalBox();
        Box b1 = Box.createHorizontalBox();
        b1.add(Box.createHorizontalGlue());
        b1.add(orient);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("DAG "));
        b1.add(spinner);
        b1.add(totalLabel);
        b.add(b1);
        Box b2 = Box.createHorizontalBox();
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.workbench);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        graphPanel.add(jScrollPane);
        graphPanel.setBorder(new TitledBorder("DAG in forbid_latent_common_causes"));
        b2.add(graphPanel);
        b.add(b2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.menuBar(), "North");
        this.add((Component)b, "Center");
    }

    @Override
    public List getSelectedModelComponents() {
        Component[] components = this.getWorkbench().getComponents();
        ArrayList<Comparable<Node>> selectedModelComponents = new ArrayList<Comparable<Node>>();
        for (Component comp : components) {
            if (comp instanceof DisplayNode) {
                selectedModelComponents.add(((DisplayNode)comp).getModelNode());
                continue;
            }
            if (!(comp instanceof DisplayEdge)) continue;
            selectedModelComponents.add(((DisplayEdge)comp).getModelEdge());
        }
        return selectedModelComponents;
    }

    @Override
    public void pasteSubsession(List<Object> sessionElements, Point upperLeft) {
        this.getWorkbench().pasteSubgraph(sessionElements, upperLeft);
        this.getWorkbench().deselectAll();
        for (Object o : sessionElements) {
            if (!(o instanceof GraphNode)) continue;
            Node modelNode = (Node)o;
            this.getWorkbench().selectNode(modelNode);
        }
        this.getWorkbench().selectConnectingEdges();
    }

    @Override
    public GraphWorkbench getWorkbench() {
        return this.workbench;
    }

    @Override
    public Graph getGraph() {
        return this.workbench.getGraph();
    }

    @Override
    public void setGraph(Graph graph) {
        this.workbench.setGraph(graph);
    }

    private JMenuBar menuBar() {
        JMenu edit = new JMenu("Edit");
        JMenuItem copy = new JMenuItem(new CopySubgraphAction(this));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        edit.add(copy);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(edit);
        return menuBar;
    }
}

