/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetradapp.editor.BayesEstimatorEditor;
import edu.cmu.tetradapp.editor.SemEstimatorEditor;
import edu.cmu.tetradapp.model.CPDAGFitModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class CPDAGFitEditor
extends JPanel {
    private final CPDAGFitModel comparison;

    public CPDAGFitEditor(CPDAGFitModel comparison) {
        this.comparison = comparison;
        this.setup();
    }

    private void setup() {
        JPanel editor;
        int i;
        JTabbedPane pane = new JTabbedPane(2);
        DataModelList data = this.comparison.getDataModelList();
        List<BayesIm> bayesIms = this.comparison.getBayesIms();
        List<SemPm> semPms = this.comparison.getSemPms();
        if (bayesIms != null && semPms != null) {
            throw new IllegalArgumentException("That's weird; both Bayes and SEM estimations were done. Please complain.");
        }
        if (bayesIms != null) {
            for (i = 0; i < bayesIms.size(); ++i) {
                editor = new BayesEstimatorEditor(bayesIms.get(i), (DataSet)data.get(i));
                JPanel panel = new JPanel();
                JScrollPane scroll = new JScrollPane(editor);
                scroll.setPreferredSize(new Dimension(900, 600));
                panel.add(Box.createVerticalStrut(10));
                Box box = Box.createHorizontalBox();
                panel.add(box);
                panel.add(Box.createVerticalStrut(10));
                Box box1 = Box.createHorizontalBox();
                box1.add(new JLabel("Graph Comparison: "));
                box1.add(Box.createHorizontalGlue());
                this.add(box1);
                this.setLayout(new BorderLayout());
                pane.add("" + (i + 1), scroll);
            }
        }
        if (semPms != null) {
            for (i = 0; i < semPms.size(); ++i) {
                editor = new SemEstimatorEditor(semPms.get(i), (DataSet)data.get(i));
                pane.add("" + (i + 1), editor);
            }
        }
        this.add(pane);
    }
}

