/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.model.MeasurementModelWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import org.apache.commons.math3.util.FastMath;

public final class ClusterEditor
extends JPanel {
    private final List<String> varNames;
    private final Clusters clusters;
    private JPanel clustersPanel;
    private ArrayList nameFields;

    public ClusterEditor(Clusters clusters, List<String> varNames) {
        if (clusters == null) {
            throw new NullPointerException();
        }
        if (varNames == null) {
            throw new NullPointerException();
        }
        this.clusters = clusters;
        this.varNames = varNames;
        this.setLayout(new BorderLayout());
        this.add((Component)this.clusterDisplay(), "Center");
        if (clusters.getNumClusters() == 0) {
            this.setNumDisplayClusters(3);
            clusters.setNumClusters(3);
        }
    }

    public ClusterEditor(MeasurementModelWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.clusters = wrapper.getClusters();
        this.varNames = wrapper.getVarNames();
        this.setLayout(new BorderLayout());
        this.add((Component)this.clusterDisplay(), "Center");
        if (this.clusters.getNumClusters() == 0) {
            this.setNumDisplayClusters(3);
            this.clusters.setNumClusters(3);
        }
    }

    public Clusters getClusters() {
        return new Clusters(this.clusters);
    }

    private Box clusterDisplay() {
        Box b = Box.createVerticalBox();
        b.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Not in cluster:"));
        b1.add(Box.createHorizontalGlue());
        b1.add(new JLabel("# Clusters = "));
        int numClusters = this.clusters.getNumClusters();
        numClusters = FastMath.max(numClusters, 3);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(numClusters, 3, 100, 1);
        spinnerNumberModel.addChangeListener(e -> {
            SpinnerNumberModel model = (SpinnerNumberModel)e.getSource();
            int numClusters1 = model.getNumber().intValue();
            this.setNumDisplayClusters(numClusters1);
            this.clusters.setNumClusters(numClusters1);
        });
        JSpinner spinner = new JSpinner(spinnerNumberModel);
        spinner.setMaximumSize(spinner.getPreferredSize());
        b1.add(spinner);
        b.add(b1);
        this.clustersPanel = new JPanel();
        this.clustersPanel.setLayout(new BorderLayout());
        this.clustersPanel.add((Component)this.getClusterBoxes(this.clusters.getNumClusters()), "Center");
        b.add(this.clustersPanel);
        Box c = Box.createHorizontalBox();
        c.add(new JLabel("Use shift key to select multiple items."));
        c.add(Box.createGlue());
        b.add(c);
        return b;
    }

    private void setNumDisplayClusters(int numClusters) {
        if (numClusters < 0) {
            int numStoredClusters = this.getClustersPrivate().getNumClusters();
            int n = (int)FastMath.pow((double)this.getVarNames().size(), 0.5);
            int defaultNumClusters = n + 1;
            int numClusters2 = FastMath.max(numStoredClusters, defaultNumClusters);
            this.clusters.setNumClusters(numClusters2);
        } else {
            this.clusters.setNumClusters(numClusters);
        }
        this.clustersPanel.removeAll();
        this.clustersPanel.add((Component)this.getClusterBoxes(this.clusters.getNumClusters()), "Center");
        this.clustersPanel.revalidate();
        this.clustersPanel.repaint();
    }

    private Box getClusterBoxes(int numClusters) {
        Box c = Box.createVerticalBox();
        List<String> varsNotInCluster = this.getClustersPrivate().getVarsNotInCluster(this.getVarNames());
        DragDropList l1 = new DragDropList(varsNotInCluster, -1, 2);
        l1.setBorder(null);
        Box b2 = Box.createHorizontalBox();
        JScrollPane scrollPane = new JScrollPane(l1);
        scrollPane.setPreferredSize(new Dimension(400, 50));
        b2.add(scrollPane);
        c.add(b2);
        c.add(Box.createVerticalStrut(5));
        Box d = Box.createHorizontalBox();
        d.add(Box.createHorizontalGlue());
        this.nameFields = new ArrayList();
        for (int cluster = 0; cluster < numClusters; ++cluster) {
            Box d1 = Box.createVerticalBox();
            Box d2 = Box.createHorizontalBox();
            d2.add(Box.createHorizontalGlue());
            d2.add(new JLabel(this.getClustersPrivate().getClusterName(cluster)));
            d2.add(Box.createHorizontalGlue());
            d1.add(d2);
            d.add(d1);
            List<String> clusterNames = this.getClustersPrivate().getCluster(cluster);
            DragDropList clusterList = new DragDropList(clusterNames, cluster, 1);
            JScrollPane scrollPane2 = new JScrollPane(clusterList);
            scrollPane2.setPreferredSize(new Dimension(50, 275));
            scrollPane2.setMaximumSize(new Dimension(200, 275));
            d1.add(scrollPane2);
            d.add(d1);
            d.add(Box.createHorizontalGlue());
        }
        JScrollPane scroll = new JScrollPane(d);
        scroll.setPreferredSize(new Dimension(400, 300));
        c.add(scroll);
        return c;
    }

    private Clusters getClustersPrivate() {
        return this.clusters;
    }

    private List<String> getVarNames() {
        return this.varNames;
    }

    public ArrayList getNameFields() {
        return this.nameFields;
    }

    public class DragDropList
    extends JList
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private List movedList;
        private final int cluster;

        public DragDropList(List items, int cluster, int orientation) {
            if (cluster < -1) {
                throw new IllegalArgumentException();
            }
            this.cluster = cluster;
            this.setLayoutOrientation(orientation);
            this.setVisibleRowCount(0);
            this.setCellRenderer((list, value, index, isSelected, cellHasFocus) -> {
                Color fillColor = new Color(153, 204, 204);
                Color selectedFillColor = new Color(255, 204, 102);
                JLabel comp = new JLabel(" " + value + " ");
                comp.setOpaque(true);
                if (isSelected) {
                    comp.setForeground(Color.BLACK);
                    comp.setBackground(selectedFillColor);
                } else {
                    comp.setForeground(Color.BLACK);
                    comp.setBackground(fillColor);
                }
                comp.setHorizontalAlignment(0);
                comp.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE), new LineBorder(Color.BLACK)));
                return comp;
            });
            new DropTarget(this, 2, this, true);
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.setModel(new DefaultListModel());
            for (Object item : items) {
                ((DefaultListModel)this.getModel()).addElement(item);
            }
        }

        public int getCluster() {
            return this.cluster;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this.getSelectedIndex() == -1) {
                return;
            }
            List list = this.getSelectedValuesList();
            if (list == null) {
                this.getToolkit().beep();
            } else {
                this.movedList = list;
                ListSelection transferable = new ListSelection(list);
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferable, this);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable tr = dropTargetDropEvent.getTransferable();
                DataFlavor flavor = tr.getTransferDataFlavors()[0];
                List list = (List)tr.getTransferData(flavor);
                for (Object aList : list) {
                    DefaultListModel model;
                    String name = (String)aList;
                    if (this.getCluster() >= 0) {
                        try {
                            ClusterEditor.this.getClustersPrivate().addToCluster(this.getCluster(), name);
                            model = (DefaultListModel)this.getModel();
                            model.addElement(name);
                            this.sort(model);
                            dropTargetDropEvent.dropComplete(true);
                        }
                        catch (IllegalStateException e) {
                            String s = e.getMessage();
                            if (!"".equals(s)) {
                                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), s);
                            } else {
                                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not drop properly.");
                            }
                            e.printStackTrace();
                            dropTargetDropEvent.dropComplete(false);
                        }
                        continue;
                    }
                    ClusterEditor.this.getClustersPrivate().removeFromClusters(name);
                    model = (DefaultListModel)this.getModel();
                    model.addElement(name);
                    this.sort(model);
                    dropTargetDropEvent.dropComplete(true);
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!dsde.getDropSuccess()) {
                return;
            }
            if (this.movedList != null) {
                for (Object aMovedList : this.movedList) {
                    ((DefaultListModel)this.getModel()).removeElement(aMovedList);
                }
                this.movedList = null;
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        private void sort(DefaultListModel model) {
            Object[] elements = model.toArray();
            Arrays.sort(elements);
            model.clear();
            for (Object element : elements) {
                model.addElement(element);
            }
        }
    }

    public static class ListSelection
    implements Transferable {
        private final List list;
        private final DataFlavor[] dataFlavors = new DataFlavor[]{new DataFlavor(ListSelection.class, "String List Selection")};

        public ListSelection(List list) {
            if (list == null) {
                throw new NullPointerException("List of list must not be null.");
            }
            this.list = list;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.list;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.getTransferDataFlavors()[0]);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.dataFlavors;
        }
    }
}

