/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class CovMatrixTable
extends AbstractTableModel {
    private final ICovarianceMatrix covMatrix;
    private Matrix editingMatrix;
    private boolean editingMatrixPositiveDefinite;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public CovMatrixTable(ICovarianceMatrix covMatrix) {
        this.covMatrix = covMatrix;
        this.editingMatrix = covMatrix.getMatrix().copy();
        this.editingMatrixPositiveDefinite = MatrixUtils.isPositiveDefinite(this.editingMatrix);
    }

    @Override
    public int getRowCount() {
        return this.getNumVariables() < 100 ? 100 : this.getNumVariables() + 4;
    }

    @Override
    public int getColumnCount() {
        return this.getNumVariables() < 30 ? 30 : this.getNumVariables() + 1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int firstDataRow = 4;
        boolean firstDataCol = true;
        int matrixRow = row - 4;
        int matrixCol = col - 1;
        int lastDataRow = 4 + this.getNumVariables();
        int lastDataCol = 1 + this.getNumVariables();
        if (row == 1 && col == 0) {
            return "Sample Size";
        }
        if (row == 1 && col == 1) {
            return this.getSampleSize();
        }
        if (col == 0 && row >= 4 && row < lastDataRow) {
            return this.getVariableName(matrixRow);
        }
        if (row == 3 && col >= 1 && col < lastDataCol) {
            return this.getVariableName(matrixCol);
        }
        if (row >= 4 && row < lastDataRow && matrixCol <= matrixRow) {
            return this.getValue(matrixRow, matrixCol);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        int firstDataRow = 4;
        boolean firstDataCol = true;
        int matrixRow = row - 4;
        int matrixCol = col - 1;
        int lastDataRow = 4 + this.getNumVariables();
        int lastDataCol = 1 + this.getNumVariables();
        if (row == 1 && col == 1) {
            return true;
        }
        if (col == 0 && row >= 4 && row < lastDataRow) {
            return true;
        }
        if (row == 3 && col >= 1 && col < lastDataCol) {
            return true;
        }
        if (row >= 4 && row < lastDataRow && col >= 1 && matrixCol < matrixRow) {
            return true;
        }
        return !(this.covMatrix instanceof CorrelationMatrix) && row >= 4 && row < lastDataRow && col >= 1 && matrixCol == matrixRow;
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        String value;
        int firstDataRow = 4;
        boolean firstDataCol = true;
        int matrixRow = row - 4;
        int matrixCol = col - 1;
        int lastDataRow = 4 + this.getNumVariables();
        int lastDataCol = 1 + this.getNumVariables();
        if (row == 1 && col == 1) {
            value = (String)aValue;
            this.covMatrix.setSampleSize(Integer.parseInt(value));
            this.pcs.firePropertyChange("modelChanged", null, null);
            this.fireTableDataChanged();
        }
        if (col == 0 && row >= 4 && row < lastDataRow) {
            this.setVariableName(matrixRow, (String)aValue);
            this.fireTableDataChanged();
        }
        if (row == 3 && col >= 1 && col < lastDataCol) {
            this.setVariableName(matrixCol, (String)aValue);
            this.fireTableDataChanged();
        }
        if (row >= 4 && row < lastDataRow && col >= 1 && matrixCol <= matrixRow) {
            value = (String)aValue;
            double v = Double.parseDouble(value);
            this.setEditingValue(matrixRow, matrixCol, v);
            this.pcs.firePropertyChange("modelChanged", null, null);
            this.fireTableDataChanged();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    private void setVariableName(int index, String name) {
        List<Node> variables = this.getCovMatrix().getVariables();
        for (Node o : variables) {
            ContinuousVariable _variable = (ContinuousVariable)o;
            if (!name.equals(_variable.getName())) continue;
            return;
        }
        ContinuousVariable variable = (ContinuousVariable)variables.get(index);
        variable.setName(name);
    }

    private void setEditingValue(int row, int col, double v) {
        if (row == col && v <= 0.0) {
            return;
        }
        this.editingMatrix.set(row, col, v);
        this.editingMatrix.set(col, row, v);
        this.editingMatrixPositiveDefinite = MatrixUtils.isPositiveDefinite(this.editingMatrix);
        if (this.editingMatrixPositiveDefinite) {
            this.getCovMatrix().setMatrix(this.editingMatrix.copy());
        }
    }

    private int getSampleSize() {
        return this.getCovMatrix().getSampleSize();
    }

    private String getVariableName(int matrixRow) {
        return this.getCovMatrix().getVariableName(matrixRow);
    }

    private double getValue(int matrixRow, int matrixCol) {
        return this.editingMatrix.get(matrixRow, matrixCol);
    }

    public ICovarianceMatrix getCovMatrix() {
        return this.covMatrix;
    }

    private int getNumVariables() {
        return this.covMatrix.getSize();
    }

    public boolean isEditingMatrixPositiveDefinite() {
        return this.editingMatrixPositiveDefinite;
    }

    public void restore() {
        this.editingMatrix = this.covMatrix.getMatrix();
        this.editingMatrixPositiveDefinite = MatrixUtils.isPositiveDefinite(this.editingMatrix);
        this.pcs.firePropertyChange("modelChanged", null, null);
        this.fireTableDataChanged();
    }
}

